<?php $__env->startSection('title', translate('shipping_method')); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <div class="mb-3">
        <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
            <img src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/business-setup.png')); ?>" alt="">
            <?php echo e(translate('shipping_method_update')); ?>

        </h2>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('admin.business-settings.shipping-method.update',[$method['id']])); ?>"
                          class="text-start"
                          method="post">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <div class="row ">
                                <div class="col-md-12">
                                    <label class="title-color" for="title"><?php echo e(translate('title')); ?></label>
                                    <input type="text" name="title" value="<?php echo e($method['title']); ?>" class="form-control" placeholder="<?php echo e(translate('title')); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row ">
                                <div class="col-md-12">
                                    <label class="title-color" for="duration"><?php echo e(translate('duration')); ?></label>
                                    <input type="text" name="duration" value="<?php echo e($method['duration']); ?>"
                                           class="form-control"
                                           placeholder="<?php echo e(translate('ex').' '.':'.' '.translate('4_to_6_days')); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row ">
                                <div class="col-md-12">
                                    <label class="title-color" for="cost"><?php echo e(translate('cost')); ?></label>
                                    <input type="number" min="0" max="1000000" name="cost"
                                           value="<?php echo e(usdToDefaultCurrency(amount: $method['cost'])); ?>"
                                           class="form-control"
                                           placeholder="<?php echo e(translate('ex').' '.':'.' '.translate('10')); ?>$">
                                </div>
                            </div>
                        </div>
                        <div class="d-flex gap-10 flex-wrap justify-content-end">
                            <button type="submit" class="btn btn--primary px-4"><?php echo e(translate('update')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/youngerlifestyle/public_html/resources/views/admin-views/shipping-method/update-view.blade.php ENDPATH**/ ?>