<?php $__env->startSection('title', translate('forgot_password').' | '.$web_config['name']->value.' '.translate('ecommerce')); ?>

<?php $__env->startSection('content'); ?>
<section class="seller-registration-section section-gap">
    <div class="container">
        <div class="row">
            <div class="col-lg-5 d-none d-lg-block">
                <div class="seller-registration-thumb h-100 d-flex flex-column align-items-center justify-content-between align-items-start">
                    <div class="section-title w-100 text-center">
                        <h2 class="title text-capitalize"><?php echo e(translate('forget_password')); ?></h2>
                    </div>
                    <div class="my-auto">
                        <img loading="lazy" src="<?php echo e(theme_asset('assets/img/forget-pass/forget-pass.png')); ?>" class="mw-100 mb-auto d-none d-md-block"
                            alt="img/icons">
                    </div>
                </div>
            </div>

            <div class="col-lg-7">
                <div class="ps-xl-5">
                    <div class="seller-registration-content">
                        <div class="seller-registration-content-top text-center">
                            <img loading="lazy" src="<?php echo e(theme_asset('assets/img/forget-pass/forget-icon.png')); ?>" class="mw-100" alt="<?php echo e(translate('icons')); ?>">
                            <div>
                                <?php if($verification_by=='email'): ?>
                                    <?php echo e(translate('please_enter_your_email_to_send_a_verification_code_for_forget_password')); ?>

                                <?php elseif($verification_by=='phone'): ?>
                                    <?php echo e(translate('please_enter_your_phone_number_to send_a_verification_code_for_forget_password')); ?>

                                <?php endif; ?>
                            </div>
                        </div>
                        <form action="<?php echo e(route('customer.auth.forgot-password')); ?>" class="forget-password-form" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="row g-4">
                                <?php if($verification_by=='email'): ?>
                                    <div class="col-sm-12">
                                        <label class="form--label mb-2" for="recover-email"><?php echo e(translate('email')); ?></label>
                                        <input class="form-control" type="email" name="identity" id="recover-email" autocomplete="off" required>
                                    </div>
                                <?php else: ?>
                                    <div class="form-group">
                                        <label class="form--label mb-2" for="recover-phone"><?php echo e(translate('phone')); ?></label>
                                        <input class="form-control" type="text" name="identity" id="recover-phone" autocomplete="off" required>
                                    </div>
                                <?php endif; ?>
                                <div class="col-sm-12">
                                    <div class="d-flex flex-wrap justify-content-center align-items-center gap-3">
                                        <button type="button" class="btn btn-base __btn-outline form-control w-auto min-w-180 thisIsALinkElement" data-linkpath="<?php echo e(route('home')); ?>"
                                            class="btn btn-base __btn-outline form-control w-auto min-w-180"><?php echo e(translate('back_again')); ?></button>
                                        <button type="submit"
                                            class="btn btn-base form-control w-auto min-w-180"><?php echo e(translate('verify')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme-views.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitede1/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/customer-views/auth/recover-password.blade.php ENDPATH**/ ?>