<?php ($overallRating = getOverallRating($product->reviews)); ?>
<div class="product-card">
    <div class="img">
        <a href="<?php echo e(route('product',$product->slug)); ?>" class="d-block h-100">
            <img loading="lazy" class="w-100" alt="<?php echo e(translate('product')); ?>"
                 src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.$product['thumbnail'], type: 'product')); ?>">
        </a>
        <?php if(isset($product->created_at) && $product->created_at->diffInMonths(\Carbon\Carbon::now()) < 1): ?>
            <span class="badge badge-title z-2"><?php echo e(translate('new')); ?></span>
        <?php endif; ?>
        <?php ($url = Illuminate\Support\Str::startsWith(request()->url(), url('product/'))); ?>
        <div class="hover-content d-flex justify-content-<?php echo e($url == true ? 'between':'end'); ?>">
            <?php if(($url) == true ): ?>
                <a href="javascript:"
                   title="<?php echo e(isset($product->category) ? $product->category->name : ''); ?>"><?php echo e(\Illuminate\Support\Str::limit(isset($product->category) ? $product->category->name:'', 16)); ?></a>
            <?php endif; ?>
            <div class="d-flex flex-wrap column-gap-3">
                <?php if(($url) != true ): ?>
                    <a href="javascript:" data-id="<?php echo e($product->id); ?>" class="d-inline-flex quickView_action">
                        <i class="bi bi-eye"></i>
                    </a>
                <?php endif; ?>
                <?php ($wishlist = count($product->wishList)>0 ? 1 : 0); ?>
                <a href="javascript:" class="d-inline-flex wish-icon addWishlist_function_view_page"
                   data-id="<?php echo e($product->id); ?>">
                    <i class="wishlist_<?php echo e($product->id); ?> bi <?php echo e(($wishlist == 1?'bi-heart-fill text-danger':'bi-heart')); ?>"></i>
                </a>
                <?php ($compare_list = count($product->compareList)>0 ? 1 : 0); ?>
                <a href="javascript:" class="d-inline-flex wish-icon addCompareList_view_page"
                   data-id="<?php echo e($product['id']); ?>">
                    <i class="bi bi-shuffle compare_list_icon-<?php echo e($product['id']); ?>"></i>
                </a>

                <?php if(($url) != true ): ?>
                    <?php if(json_decode($product->variation) != null): ?>
                        <span class="btn add-to-cart-plus-btn wish-icon">
                            <a href="javascript:" data-id="<?php echo e($product['id']); ?>" class="quickView_action">
                                <i class="bi bi-plus"></i>
                            </a>
                        </span>
                    <?php else: ?>
                        <span class="btn add-to-cart-plus-btn wish-icon">
                            <?php ($product_card_gen_id=rand(11111,99999)); ?>
                            <form class="cart add-to-cart-form-<?php echo e($product['id']); ?>" action="<?php echo e(route('cart.add')); ?>"
                                  id="add-to-cart-form-<?php echo e($product_card_gen_id); ?>"
                                  data-errormessage="<?php echo e(translate('please_choose_all_the_options')); ?>"
                                  data-outofstock="<?php echo e(translate('sorry').', '.translate('out_of_stock')); ?>.">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($product->id); ?>">
                                <input type="number" name="quantity" value="<?php echo e($product->minimum_order_qty ?? 1); ?>"
                                       class="product_quantity__qty" hidden>
                            </form>
                            <a href="javascript:" class="store_vacation_check_function"
                               data-id="<?php echo e($product['id']); ?>"
                               data-added_by="<?php echo e($product['added_by']); ?>"
                               data-user_id="<?php echo e($product['user_id']); ?>"
                               data-action_url="<?php echo e(route('ajax-shop-vacation-check')); ?>"
                               data-product_cart_id="<?php echo e($product_card_gen_id); ?>"
                            >
                                <i class="bi bi-plus"></i>
                            </a>
                        </span>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="cont">
        <h6 class="title">
            <a href="<?php echo e(route('product',$product->slug)); ?>"
               title="<?php echo e($product['name']); ?>"><?php echo e(\Illuminate\Support\Str::limit($product['name'], 18)); ?></a>
        </h6>
        <div class="d-flex flex-wrap row-gap-1 align-items-center column-gap-2 text-capitalize">
            <h4 class="price">
                <span><?php echo e(\App\Utils\Helpers::currency_converter($product->unit_price-\App\Utils\Helpers::get_product_discount($product,$product->unit_price))); ?></span>
                <?php if($product->discount > 0): ?>
                    <del><?php echo e(\App\Utils\Helpers::currency_converter($product->unit_price)); ?></del>
                <?php endif; ?>
            </h4>

            <?php if(($product['product_type'] == 'physical')): ?>
                <?php if($product['current_stock'] <= 0): ?>
                    <span class="status text-danger"><?php echo e(translate('out_of_stock')); ?></span>
                <?php elseif($product['current_stock'] <= $web_config['products_stock_limit']): ?>
                    <span class="status"><?php echo e(translate('limited_Stock')); ?></span>
                <?php else: ?>
                    <span class="status"><?php echo e(translate('in_stock')); ?></span>
                <?php endif; ?>
            <?php else: ?>
                <span class="status"><?php echo e(translate('in_stock')); ?></span>
            <?php endif; ?>
        </div>
        <div class="rating">
            <?php for($i = 1; $i <= 5; $i++): ?>
                <?php if($i <= (int)$overallRating[0]): ?>
                    <i class="bi bi-star-fill filled"></i>
                <?php elseif($overallRating[0] != 0 && $i <= (int)$overallRating[0] + 1.1 && $overallRating[0] > ((int)$overallRating[0])): ?>
                    <i class="bi bi-star-half filled"></i>
                <?php else: ?>
                    <i class="bi bi-star-fill"></i>
                <?php endif; ?>
            <?php endfor; ?>
        </div>
    </div>
</div>

<?php /**PATH /home/youngerlifestyle/public_html/resources/themes/theme_fashion/theme-views/partials/_product-medium-card.blade.php ENDPATH**/ ?>