<?php $__env->startSection('title',translate('products').' | '.$web_config['name']->value.' '.translate('ecommerce')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta property="og:image" content="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['web_logo']); ?>"/>
    <meta property="og:title" content="Products of <?php echo e($web_config['name']); ?> "/>
    <meta property="og:url" content="<?php echo e(config('app.url')); ?>">
    <meta property="og:description" content="<?php echo substr($web_config['about']->value,0,100); ?>">

    <meta property="twitter:card" content="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['web_logo']); ?>"/>
    <meta property="twitter:title" content="Products of <?php echo e($web_config['name']); ?>"/>
    <meta property="twitter:url" content="<?php echo e(config('app.url')); ?>">
    <meta property="twitter:description" content="<?php echo substr($web_config['about']->value,0,100); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <section class="promo-page-header">
        <?php if($banner): ?>
            <img loading="lazy" src="<?php echo e(getValidImage(path: 'storage/app/public/banner/'.($banner ? json_decode($banner['value'])->image:''), type:'banner')); ?>"
                 class="w-100" alt="<?php echo e(translate('banner')); ?>">
        <?php else: ?>
            <div class="product_blank_banner"></div>
        <?php endif; ?>
    </section>

    <div class="container">
        <?php echo $__env->make('theme-views.layouts.partials._search-form-partials', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <section class="all-products-section pt-20px scroll_to_form_top">
        <form action="<?php echo e(route('ajax-filter-products')); ?>" method="POST" id="fashion_products_list_form">
            <?php echo csrf_field(); ?>
            <div class="container">
                <div class="section-title mb-4">
                    <div
                        class="d-flex flex-column flex-sm-row justify-content-between row-gap-3 column-gap-2 align-items-sm-center search-page-title">
                        <ul class="breadcrumb">
                            <li>
                                <a href="<?php echo e(route('home')); ?>"><?php echo e(translate('home')); ?></a>
                            </li>
                            <li>
                                <a href="javascript:" class="text-capitalize text-base product_view_title"
                                   data-allproduct="<?php echo e(translate('all_products')); ?>">
                                    <?php echo e(translate(str_replace(['-', '_', '/'],' ',request('data_from')))); ?> <?php echo e(translate('products')); ?> <?php echo e(request('brand_name') ? ' / '.str_replace('_',' ',request('brand_name')) : ''); ?> <?php echo e(request('name') ? '('.request('name').')' : ''); ?>

                                </a>
                            </li>
                        </ul>
                        <div
                            class="d-flex flex-wrap-reverse justify-content-between justify-content-sm-end align-items-center column-gap-3 row-gap-2 text-capitalize min-w-lg-190">
                            <div class="flex-grow-1">
                                <div class="position-relative select2-prev-icon d-none d-lg-block">
                                    <i class="bi bi-sort-up"></i>
                                    <select
                                        class="select2-init form-control size-40px filter_select_input filter_by_product_list_web ps-32px"
                                        name="sort_by"
                                        data-primary_select="<?php echo e(translate('sort_by')); ?> : <?php echo e(translate('default')); ?>">
                                        <option value="default"><?php echo e(translate('sort_by')); ?>

                                            : <?php echo e(translate('default')); ?></option>
                                        <option
                                            value="latest" <?php echo e(request('data_from') == 'latest' ? 'selected':''); ?>><?php echo e(translate('sort_by')); ?>

                                            : <?php echo e(translate('latest')); ?></option>
                                        <option value="a-z"><?php echo e(translate('sort_by')); ?>

                                            : <?php echo e(translate('a_to_z_order')); ?></option>
                                        <option value="z-a"><?php echo e(translate('sort_by')); ?>

                                            : <?php echo e(translate('z_to_a_order')); ?></option>
                                        <option value="low-high"><?php echo e(translate('sort_by')); ?>

                                            : <?php echo e(translate('low_to_high_price')); ?>

                                        </option>
                                        <option value="high-low"><?php echo e(translate('sort_by')); ?>

                                            : <?php echo e(translate('high_to_low_price')); ?>

                                        </option>
                                    </select>
                                </div>
                                <div class="d-lg-none">
                                    <button type="button" class="btn btn-base filter-toggle d-lg-none">
                                        <i class="bi bi-funnel"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <main class="main-wrapper">

                    <aside class="sidebar">
                        <?php echo $__env->make('theme-views.partials.products._products-list-aside',['categories'=>$categories, 'colors'=>$colors_in_shop], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </aside>

                    <article class="article">
                        <div id="selected_filter_area">
                            <?php echo $__env->make('theme-views.product._selected_filter_tags',['tags_category'=>$tag_category,'tags_brands'=>$tag_brand,'rating'=>null], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <?php ($paginate_count = $products->total() > 20 ? ceil($products->total()/20) : 1); ?>
                        <div id="ajax_products_section">
                            <?php echo $__env->make('theme-views.product._ajax-products',['products'=>$products,'page'=>1,'paginate_count'=>$paginate_count], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </article>
                </main>
            </div>
        </form>
    </section>

    <?php echo $__env->make('theme-views.partials._how-to-section', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme-views.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesignbd/ecom10.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/product/view.blade.php ENDPATH**/ ?>