<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(session()->get('direction')); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="base-url" content="<?php echo e(url('/')); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="_token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title'); ?></title>

    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['fav_icon']->value); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['fav_icon']->value); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(theme_asset('assets/css/'.(session()->get('direction') == 'rtl' ? 'bootstrap-rtl.min.css': 'bootstrap.css' ))); ?>" />

    <link rel="stylesheet" media="screen" href="<?php echo e(theme_asset('assets/plugins/font-awesome-4.7.0/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(theme_asset('assets/css/roboto-font.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(theme_asset('assets/css/bootstrap-icons.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(theme_asset('assets/css/owl.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(theme_asset('assets/css/nouislider.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(theme_asset('assets/css/select2.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(theme_asset('assets/plugins/magnific-popup-1.1.0/magnific-popup.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(theme_asset('assets/plugins/sweet_alert/sweetalert2.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(theme_asset('assets/css/toastr.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(theme_asset('assets/css/main.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(theme_asset('assets/css/custom.css')); ?>" />

    <link rel="shortcut icon" href="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['fav_icon']->value); ?>" type="image/x-icon" />

    <?php echo $__env->yieldPushContent('css_or_js'); ?>

    <style>
        :root {
            --base: <?php echo e($web_config['primary_color']); ?>;
            --base-rgb: <?php echo e(\App\Utils\hex_to_rgb($web_config['primary_color'])); ?>;
            --base-3: <?php echo e($web_config['primary_color']); ?>;
            --base-4: <?php echo e($web_config['primary_color_light']); ?>;
            --base-2: <?php echo e($web_config['secondary_color']); ?>;
            --bs-2-rgb: <?php echo e(\App\Utils\hex_to_rgb($web_config['secondary_color'])); ?>;

            --bs-btn-disabled-bg:<?php echo e($web_config['primary_color']); ?> ;
            --bs-btn-disabled-border-color: <?php echo e($web_config['primary_color']); ?>;
            --bs-btn-disabled-color: #fff;
        }
        .secondary-color,
        .btn-base.secondary-color {
            --base: <?php echo e($web_config['secondary_color']); ?>;
            --base-rgb: <?php echo e(\App\Utils\hex_to_rgb($web_config['secondary_color'])); ?>;
            --border: <?php echo e($web_config['secondary_color']); ?>;
            --bs-2-rgb: <?php echo e(\App\Utils\hex_to_rgb($web_config['secondary_color'])); ?>;

            --bs-btn-disabled-color: #00000085;
            --bs-btn-disabled-bg:<?php echo e($web_config['secondary_color']); ?> ;
            --bs-btn-disabled-border-color: <?php echo e($web_config['secondary_color']); ?>75;
        }
        .__btn-outline-warning.secondary-color {
            --base: <?php echo e($web_config['primary_color']); ?>;
            --base-rgb: <?php echo e(\App\Utils\hex_to_rgb($web_config['primary_color'])); ?>;
            --base-3: <?php echo e($web_config['primary_color']); ?>;
            --base-4: <?php echo e($web_config['primary_color_light']); ?>;
            --base-2: <?php echo e($web_config['secondary_color']); ?>;
            --bs-2-rgb: <?php echo e(\App\Utils\hex_to_rgb($web_config['secondary_color'])); ?>;
            --warning: <?php echo e($web_config['secondary_color']); ?>;
            --warning-rgb: <?php echo e(\App\Utils\hex_to_rgb($web_config['secondary_color'])); ?>;

            --bs-btn-disabled-color: #00000085;
            --bs-btn-disabled-bg: transparent ;
            --bs-btn-disabled-border-color: <?php echo e($web_config['secondary_color']); ?>75;
        }
        <?php if(isset($web_config['announcement']) && $web_config['announcement']['status']==1): ?>
            .offer-bar {
                background-color : <?php echo e($web_config['announcement']['color']); ?>;
                color : <?php echo e($web_config['announcement']['text_color']); ?>;
            }
        <?php endif; ?>
    </style>

    <script src="<?php echo e(theme_asset('assets/js/jquery-3.7.1.min.js')); ?>"></script>

    <?php ($googleTagManagerId = getWebConfig(name: 'google_tag_manager_id')); ?>
    <?php if($googleTagManagerId ): ?>
        <script>
        "use strict";
        (function (w, d, s, l, i) {
                w[l] = w[l] || [];
                w[l].push({
                    'gtm.start':
                        new Date().getTime(), event: 'gtm.js'
                });
                var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : '';
                j.async = true;
                j.src =
                    'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
                f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', '<?php echo e($googleTagManagerId); ?>');</script>
    <?php endif; ?>

    <?php ($pixel_analytics_user_code = getWebConfig(name: 'pixel_analytics')); ?>
    <?php if($pixel_analytics_user_code): ?>
        <script>
            !function(f,b,e,v,n,t,s)
            {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
                n.callMethod.apply(n,arguments):n.queue.push(arguments)};
                if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
                n.queue=[];t=b.createElement(e);t.async=!0;
                t.src=v;s=b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t,s)}(window, document,'script',
                'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '<?php echo e($pixel_analytics_user_code); ?>');
            fbq('track', 'PageView');
        </script>
        <noscript>
            <img loading="lazy" height="1" width="1" style="display:none"
                 src="https://www.facebook.com/tr?id=<?php echo e($pixel_analytics_user_code); ?>&ev=PageView&noscript=1"/>
        </noscript>
    <?php endif; ?>
</head>

<body>

    <script>
        "use strict";
        function setThemeMode() {
            if (localStorage.getItem('theme') === null) {
                document.body.setAttribute('theme', 'light');
            } else {
                document.body.setAttribute('theme', localStorage.getItem('theme'));
            }
        }
        setThemeMode();
    </script>

    <?php if($googleTagManagerId): ?>
        <noscript>
            <iframe src="<?php echo e('https://www.googletagmanager.com/ns.html?id='.$googleTagManagerId); ?>"
                    height="0" width="0" style="display:none;visibility:hidden"></iframe>
        </noscript>
    <?php endif; ?>

    <div class="overlay"></div>

    <div class="preloader d--none" id="loading">
        <img loading="lazy" width="200" alt="<?php echo e(translate('loader')); ?>"
             src="<?php echo e(getValidImage(path: 'storage/app/public/company/'.getWebConfig(name: 'loader_gif'), type: 'source', source: theme_asset('assets/img/loader.gif'))); ?>">
    </div>

    <?php echo $__env->make('theme-views.layouts.partials._header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('theme-views.layouts.partials.modal._quick-view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div id="login-and-register-modal-section"></div>

    <div class="d-none d-md-block">
        <?php if($web_config['guest_checkout_status'] || auth('customer')->check()): ?>
            <a href="<?php echo e(route('shop-cart')); ?>" class="floating-cart" id="floating_cart_items">
                <?php echo $__env->make('theme-views.layouts.partials._cart-floating', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </a>
        <?php else: ?>
            <a href="javascript:" class="floating-cart floating-cart-custom-css customer_login_register_modal" id="floating_cart_items" data-bs-toggle="modal">
                <?php echo $__env->make('theme-views.layouts.partials._cart-floating', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </a>
        <?php endif; ?>
    </div>


    <?php ($cookie = $web_config['cookie_setting'] ? json_decode($web_config['cookie_setting']['value'], true):null); ?>
    <?php if($cookie && $cookie['status']==1): ?>
        <section class="cookie-section" id="cookie-section"></section>
    <?php endif; ?>


    <?php echo $__env->make('theme-views.layouts.partials.modal._initial', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('theme-views.layouts.partials.modal._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <div class="app-bar px-sm-2 d-xl-none" id="mobile_app_bar">
        <?php echo $__env->make('theme-views.layouts.partials._app-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <?php echo $__env->make('theme-views.layouts.partials._footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <span id="get-login-modal-data" data-route="<?php echo e(route('customer.auth.get-login-modal-data')); ?>"></span>
    <span id="get-current-route-name" data-route="<?php echo e(Route::currentRouteName()); ?>"></span>
    <span id="update_nav_cart_url" data-url="<?php echo e(route('cart.nav-cart')); ?>"></span>
    <span id="update_floating_nav_cart_url" data-url="<?php echo e(route('cart.floating-nav-cart-items')); ?>"></span>
    <span id="update_quantity_url" data-url="<?php echo e(route('cart.updateQuantity.guest')); ?>"></span>
    <span id="update_nav_cart_url" data-url="<?php echo e(route('cart.nav-cart')); ?>"></span>
    <span id="remove_from_cart_url" data-url="<?php echo e(route('cart.remove')); ?>"></span>
    <span id="update_quantity_basic_url" data-url="<?php echo e(route('cart.updateQuantity')); ?>"></span>
    <span id="order_again_url" data-url="<?php echo e(route('cart.order-again')); ?>"></span>
    <span id="store_wishlist_url" data-url="<?php echo e(route('store-wishlist')); ?>"></span>
    <span id="quick_view_url" data-url="<?php echo e(route('quick-view')); ?>"></span>
    <span id="delete_wishlist_url" data-url="<?php echo e(route('delete-wishlist')); ?>"></span>
    <span id="checkout_details_url" data-url="<?php echo e(route('checkout-details')); ?>"></span>
    <span id="order_note_url" data-url="<?php echo e(route('order_note')); ?>"></span>
    <span id="store_compare_list_url" data-url="<?php echo e(route('product-compare.index')); ?>"></span>
    <span id="digital_product_download_otp_reset" data-route="<?php echo e(route('digital-product-download-otp-reset')); ?>"></span>
    <span id="set_shipping_url" data-url="<?php echo e(url('/')); ?>/customer/set-shipping-method"></span>
    <span id="authentication-status" data-auth="<?php echo e(auth('customer')->check() ? 'true' : 'false'); ?>"></span>
    <span class="cannot_use_zero" data-text="<?php echo e(translate('cannot_Use_0_only')); ?>"></span>
    <span class="out_of_stock" data-text="<?php echo e(translate('Out_Of_Stock')); ?>"></span>
    <span class="minimum_order_quantity_msg" data-text="<?php echo e(translate('minimum_order_quantity_cannot_be_less_than')); ?>"></span>
    <span class="item_has_been_removed_from_cart" data-text="<?php echo e(translate('item_has_been_removed_from_cart')); ?>"></span>
    <span class="please_fill_out_this_field" data-text="<?php echo e(translate('please_fill_out_this_field')); ?>"></span>
    <span class="text-wishList" data-text="<?php echo e(translate('wishlist')); ?>"></span>
    <span class="text-otp-related"
          data-otpsendagain="<?php echo e(translate('OTP_has_been_sent_again')); ?>"
          data-otpnewcode="<?php echo e(translate('please_wait_for_new_code')); ?>"
    ></span>
    <span class="text-custom-storage"
        data-textno="<?php echo e(translate('no')); ?>"
        data-textyes="<?php echo e(translate('yes')); ?>"
        data-textnow="<?php echo e(translate('now')); ?>"
        data-textsuccessfullycopied="<?php echo e(translate('successfully_copied')); ?>"
        data-text-no-discount="<?php echo e(translate('no_discount')); ?>"
        data-stock-available="<?php echo e(translate('stock_available')); ?>"
        data-stock-not-available="<?php echo e(translate('stock_not_available')); ?>"
        data-update-this-address="<?php echo e(translate('update_this_Address')); ?>"
        data-password-characters-limit="<?php echo e(translate('your_password_must_be_at_least_8_characters')); ?>"
        data-password-not-match="<?php echo e(translate('password_does_not_Match')); ?>"
        data-textpleaseselectpaymentmethods="<?php echo e(translate('please_select_a_payment_Methods')); ?>"
        data-reviewmessage="<?php echo e(translate('you_can_review_after_the_product_is_delivered')); ?>"
        data-refundmessage="<?php echo e(translate('you_can_refund_request_after_the_product_is_delivered')); ?>"
        data-textshoptemporaryclose="<?php echo e(translate('This_shop_is_temporary_closed_or_on_vacation').' '.translate('You_cannot_add_product_to_cart_from_this_shop_for_now')); ?>"
    ></span>

    <?php ($whatsapp = getWebConfig(name: 'whatsapp')); ?>
    <div class="social-chat-icons">
        <?php if(isset($whatsapp['status']) && $whatsapp['status'] == 1 ): ?>
            <div class="">
                <a href="https://wa.me/<?php echo e($whatsapp['phone']); ?>?text=Hello%20there!" target="_blank">
                    <img loading="lazy" src="<?php echo e(theme_asset('assets/img/whatsapp.svg')); ?>" width="35" class="chat-image-shadow"
                         alt="<?php echo e(translate('Chat_with_us_on_WhatsApp')); ?>">
                </a>
            </div>
        <?php endif; ?>
    </div>

    <script src="<?php echo e(theme_asset('assets/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('assets/js/owl.min.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('assets/js/countdown.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('assets/js/nouislider.min.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('assets/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('assets/js/easyzoom.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('assets/plugins/magnific-popup-1.1.0/jquery.magnific-popup.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('assets/plugins/sweet_alert/sweetalert2.js')); ?>"></script>

    <script src="<?php echo e(theme_asset('assets/js/main.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('assets/js/toastr.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('assets/js/custom.js')); ?>"></script>

    <?php echo Toastr::message(); ?>


    <script>
        "use strict";

        <?php if($errors->any()): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                toastr.error('<?php echo e($error); ?>', Error, {
                    CloseButton: true,
                    ProgressBar: true
                });
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <?php if(Request::is('/') &&  \Illuminate\Support\Facades\Cookie::has('popup_banner')==false): ?>
            $(window).on('load', function () {
                $('#initialModal').modal('show');
            });
            <?php (\Illuminate\Support\Facades\Cookie::queue('popup_banner', 'off', 1)); ?>
        <?php endif; ?>

        <?php ($cookie = $web_config['cookie_setting'] ? json_decode($web_config['cookie_setting']['value'], true):null); ?>
        let cookie_content = `<div class="container">
                                <div class="d-flex flex-wrap align-items-center justify-content-between column-gap-4 row-gap-3">
                                    <div class="text-wrapper">
                                        <h5 class="title"><?php echo e(translate('Your_Privacy_Matter')); ?></h5>
                                        <div><?php echo e($cookie ? $cookie['cookie_text'] : ''); ?></div>
                                    </div>
                                    <div class="btn-wrapper">
                                        <button type="button" class="btn absolute-white btn-link" id="cookie-reject"><?php echo e(translate('no')); ?>, <?php echo e(translate('thanks')); ?></button>
                                        <button type="button" class="btn btn-success cookie-accept" id="cookie-accept"><?php echo e(translate('yes')); ?>, <?php echo e(translate('accept_All_Cookies')); ?></button>
                                    </div>
                                </div>
                            </div>`;

        <?php if(!auth('customer')->check()): ?>
            $(document).ready(function() {
                const currentUrl = new URL(window.location.href);
                const referralCodeParameter = new URLSearchParams(currentUrl.search).get("referral_code");

                if (referralCodeParameter) {
                    $('#SignUpModal').modal('show');
                    let referralCodeElement = $('#referral_code');
                    if (referralCodeElement.length) {
                        referralCodeElement.val(referralCodeParameter);
                    }
                }
            });
        <?php endif; ?>
    </script>

    <?php echo $__env->yieldPushContent('script'); ?>
</body>

</html>
<?php /**PATH /home/elitedesign/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/layouts/app.blade.php ENDPATH**/ ?>