<?php $__env->startSection('title', $product['name'].' | '.$web_config['name']->value.' '.translate('ecommerce')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="description" content="<?php echo e($product->slug); ?>">
    <meta name="keywords" content="<?php $__currentLoopData = explode(' ',$product['name']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyword): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($keyword.' , '); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>">
    <?php if($product->added_by=='seller'): ?>
        <meta name="author" content="<?php echo e($product->seller->shop?$product->seller->shop->name:$product->seller->f_name); ?>">
    <?php elseif($product->added_by=='admin'): ?>
        <meta name="author" content="<?php echo e($web_config['name']->value); ?>">
    <?php endif; ?>

    <?php if($product['meta_image']): ?>
        <meta property="og:image" content="<?php echo e(asset("storage/app/public/product/meta")); ?>/<?php echo e($product->meta_image); ?>"/>
        <meta property="twitter:card"
              content="<?php echo e(asset("storage/app/public/product/meta")); ?>/<?php echo e($product->meta_image); ?>"/>
    <?php else: ?>
        <meta property="og:image" content="<?php echo e(asset("storage/app/public/product/thumbnail")); ?>/<?php echo e($product->thumbnail); ?>"/>
        <meta property="twitter:card"
              content="<?php echo e(asset("storage/app/public/product/thumbnail/")); ?>/<?php echo e($product->thumbnail); ?>"/>
    <?php endif; ?>

    <?php if($product['meta_title']): ?>
        <meta property="og:title" content="<?php echo e($product->meta_title); ?>"/>
        <meta property="twitter:title" content="<?php echo e($product->meta_title); ?>"/>
    <?php else: ?>
        <meta property="og:title" content="<?php echo e($product->name); ?>"/>
        <meta property="twitter:title" content="<?php echo e($product->name); ?>"/>
    <?php endif; ?>
    <meta property="og:url" content="<?php echo e(route('product',[$product->slug])); ?>">

    <?php if($product['meta_description']): ?>
        <meta property="twitter:description" content="<?php echo $product['meta_description']; ?>">
        <meta property="og:description" content="<?php echo $product['meta_description']; ?>">
    <?php else: ?>
        <meta property="og:description"
              content="<?php $__currentLoopData = explode(' ',$product['name']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyword): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($keyword.' , '); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>">
        <meta property="twitter:description"
              content="<?php $__currentLoopData = explode(' ',$product['name']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyword): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($keyword.' , '); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>">
    <?php endif; ?>
    <meta property="twitter:url" content="<?php echo e(route('product',[$product->slug])); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <section class="product-single-section pt-20px">
        <div class="container">
            <div class="section-title mb-4">
                <div
                    class="d-flex flex-wrap justify-content-between row-gap-3 column-gap-2 align-items-center search-page-title">
                    <ul class="breadcrumb">
                        <li>
                            <a href="<?php echo e(route('home')); ?>"><?php echo e(translate('home')); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('products',['id'=> $product->category_id,'data_from'=>'category','page'=>1])); ?>">
                                <?php echo e(translate('products')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="javascript:" class="text-base"><?php echo e($product->name); ?></a>
                        </li>
                    </ul>
                    <div class="text-capitalize"><?php echo e(translate('similar_category_product')); ?>

                        <span class="text-base cursor-pointer thisIsALinkElement"
                              data-linkpath="<?php echo e(route('products',['id'=> $product->category_id,'data_from'=>'category','page'=>1])); ?>">
                    <?php echo e($relatedProducts); ?> <?php echo e(translate('item')); ?></span>
                    </div>
                </div>
            </div>

            <?php if( preg_match('/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=|\?v=)([^#\&\?]*).*/',$product->video_url)): ?>
                <div class="modal fade" id="videoModal" tabindex="-1" aria-labelledby="videoModalLabel"
                     aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-lg">
                        <div class="modal-content">
                            <div class="modal-body p-0">
                                <iframe class="videoModalIframe" src="<?php echo e($product->video_url); ?>" frameborder="0"
                                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                        allowfullscreen></iframe>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="product-single-wrapper">
                <?php if($product->images!=null && json_decode($product->images)>0): ?>
                    <div class="product-single-thumb">
                        <?php if(json_decode($product->colors) && $product->color_image): ?>
                            <div class="overflow-hidden rounded">
                                <div class="product-share-icons">
                                    <a href="javascript:" class="share-icon" title="<?php echo e(translate('share')); ?>">
                                        <i class="bi bi-share-fill"></i>
                                    </a>
                                    <ul>
                                        <li>
                                            <a href="javascript:" class="social_share_function"
                                               data-url="<?php echo e(route('product',$product->slug)); ?>"
                                               data-social="facebook.com/sharer/sharer.php?u="
                                            >
                                                <i class="bi bi-facebook"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:" class="social_share_function"
                                               data-url="<?php echo e(route('product',$product->slug)); ?>"
                                               data-social="twitter.com/intent/tweet?text="
                                            >
                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                     fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                                                    <path
                                                        d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865l8.875 11.633Z"/>
                                                </svg>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:" class="social_share_function"
                                               data-url="<?php echo e(route('product',$product->slug)); ?>"
                                               data-social="linkedin.com/shareArticle?mini=true&url="
                                            >
                                                <i class="bi bi-linkedin"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:" class="social_share_function"
                                               data-url="<?php echo e(route('product',$product->slug)); ?>"
                                               data-social="api.whatsapp.com/send?text="
                                            >
                                                <i class="bi bi-whatsapp"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div id="sync1" class="owl-carousel owl-theme product-single-main-slider">
                                    <?php $__currentLoopData = json_decode($product->color_image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(count(json_decode($product->color_image)) > 1 && $key==1 && preg_match('/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=|\?v=)([^#\&\?]*).*/',$product->video_url)): ?>
                                            <div class="main-thumb border rounded overflow-hidden">
                                                <div class="" data-bs-toggle="modal" data-bs-target="#videoModal">
                                                    <a href="javascript:">
                                                        <img loading="lazy"
                                                             src="https://i.ytimg.com/vi/<?php echo e(substr($product->video_url, strrpos($product->video_url, '/') + 1)); ?>/0.jpg"
                                                             alt="<?php echo e(translate('products')); ?>"
                                                             class="onerror-placeholder-image"
                                                             height="380px">
                                                    </a>
                                                    <div class="play--icon">
                                                        <i class="bi bi-play-btn-fill"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($photo->color != null): ?>
                                            <div class="main-thumb border rounded overflow-hidden">
                                                <div class="easyzoom easyzoom--overlay">
                                                    <a href="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type:'product')); ?>">
                                                        <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                             src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type:'product')); ?>">
                                                    </a>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php $__currentLoopData = json_decode($product->color_image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($photo->color == null): ?>
                                            <div class="main-thumb border rounded overflow-hidden">
                                                <div class="easyzoom easyzoom--overlay">
                                                    <a href="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type:'product')); ?>">
                                                        <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                             src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type:'product')); ?>">
                                                    </a>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php if(count(json_decode($product->color_image)) < 1 && preg_match('/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=|\?v=)([^#\&\?]*).*/',$product->video_url)): ?>
                                        <div class="main-thumb border rounded overflow-hidden">
                                            <div class="" data-bs-toggle="modal" data-bs-target="#videoModal">
                                                <a href="javascript:">
                                                    <img loading="lazy"
                                                         src="https://i.ytimg.com/vi/<?php echo e(substr($product->video_url, strrpos($product->video_url, '/') + 1)); ?>/0.jpg"
                                                         alt="<?php echo e(translate('products')); ?>"
                                                         class="onerror-placeholder-image"
                                                         height="380px">
                                                </a>
                                                <div class="play--icon">
                                                    <i class="bi bi-play-btn-fill"></i>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="overflow-hidden rounded">
                                <div class="product-share-icons">
                                    <a href="javascript:" class="share-icon" title="<?php echo e(translate('share')); ?>">
                                        <i class="bi bi-share-fill"></i>
                                    </a>
                                    <ul>
                                        <li>
                                            <a href="javascript:" class="social_share_function"
                                               data-url="<?php echo e(route('product',$product->slug)); ?>"
                                               data-social="facebook.com/sharer/sharer.php?u=">
                                                <i class="bi bi-facebook"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:" class="social_share_function"
                                               data-url="<?php echo e(route('product',$product->slug)); ?>"
                                               data-social="twitter.com/intent/tweet?text=">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                     fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                                                    <path
                                                        d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865l8.875 11.633Z"/>
                                                </svg>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:" class="social_share_function"
                                               data-url="<?php echo e(route('product',$product->slug)); ?>"
                                               data-social="linkedin.com/shareArticle?mini=true&url=">
                                                <i class="bi bi-linkedin"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:" class="social_share_function"
                                               data-url="<?php echo e(route('product',$product->slug)); ?>"
                                               data-social="api.whatsapp.com/send?text=">
                                                <i class="bi bi-whatsapp"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div id="sync1" class="owl-carousel owl-theme product-single-main-slider">
                                    <?php $__currentLoopData = json_decode($product->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(count(json_decode($product->images)) > 1 && $key==1 && preg_match('/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=|\?v=)([^#\&\?]*).*/',$product->video_url)): ?>
                                            <div class="main-thumb border rounded overflow-hidden">
                                                <div class="" data-bs-toggle="modal" data-bs-target="#videoModal">
                                                    <a href="javascript:">
                                                        <img loading="lazy"
                                                             src="https://i.ytimg.com/vi/<?php echo e(substr($product->video_url, strrpos($product->video_url, '/') + 1)); ?>/0.jpg"
                                                             alt="<?php echo e(translate('products')); ?>"
                                                             class="onerror-placeholder-image">
                                                    </a>
                                                    <div class="play--icon">
                                                        <i class="bi bi-play-btn-fill"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <div class="main-thumb border rounded overflow-hidden">
                                            <div class="easyzoom easyzoom--overlay">
                                                <a href="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo, type:'product')); ?>">
                                                    <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                         src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo, type:'product')); ?>">
                                                </a>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(count(json_decode($product->images)) < 1 && preg_match('/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=|\?v=)([^#\&\?]*).*/',$product->video_url)): ?>
                                        <div class="main-thumb border rounded overflow-hidden">
                                            <div class="" data-bs-toggle="modal" data-bs-target="#videoModal">
                                                <a href="javascript:">
                                                    <img loading="lazy"
                                                         src="https://i.ytimg.com/vi/<?php echo e(substr($product->video_url, strrpos($product->video_url, '/') + 1)); ?>/0.jpg"
                                                         alt="<?php echo e(translate('products')); ?>"
                                                         class="onerror-placeholder-image">
                                                </a>
                                                <div class="play--icon">
                                                    <i class="bi bi-play-btn-fill"></i>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="overflow-hidden">
                            <div id="sync2" class="owl-carousel owl-theme product-single-thumbnails">
                                <?php if($product->images!=null && json_decode($product->images)>0): ?>
                                    <?php if(json_decode($product->colors) && $product->color_image): ?>
                                        <?php $__currentLoopData = json_decode($product->color_image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($key == 1): ?>
                                                <?php if( preg_match('/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=|\?v=)([^#\&\?]*).*/',$product->video_url)): ?>
                                                    <div class="thumb youtube_video">
                                                        <img loading="lazy"
                                                             src="https://i.ytimg.com/vi/<?php echo e(substr($product->video_url, strrpos($product->video_url, '/') + 1)); ?>/0.jpg"
                                                             class="w-100px onerror-placeholder-image" alt="<?php echo e(translate('products')); ?>">
                                                        <div class="play--icon">
                                                            <i class="bi bi-play-btn-fill"></i>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if($photo->color != null): ?>
                                                <div class="thumb color_variants_preview-box-<?php echo e($photo->color); ?>">
                                                    <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                         src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type:'product')); ?>">
                                                </div>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php $__currentLoopData = json_decode($product->color_image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($photo->color == null): ?>
                                                <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                     src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type:'product')); ?>">
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <?php ($product_images = json_decode($product->images)); ?>
                                        <?php $__currentLoopData = $product_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(count($product_images) > 1 && $key==1 && preg_match('/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=|\?v=)([^#\&\?]*).*/',$product->video_url)): ?>
                                                <div class="thumb youtube_video">
                                                    <img loading="lazy"
                                                         src="https://i.ytimg.com/vi/<?php echo e(substr($product->video_url, strrpos($product->video_url, '/') + 1)); ?>/0.jpg"
                                                         class="w-100px onerror-placeholder-image" alt="<?php echo e(translate('products')); ?>">
                                                    <div class="play--icon">
                                                        <i class="bi bi-play-btn-fill"></i>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <div class="thumb ">
                                                <img loading="lazy" src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo, type: 'product')); ?>"
                                                     alt="<?php echo e(translate('product')); ?>">
                                            </div>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(count($product_images) <= 1 && preg_match('/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=|\?v=)([^#\&\?]*).*/',$product->video_url)): ?>
                                            <div class="thumb youtube_video">
                                                <img loading="lazy"
                                                     src="https://i.ytimg.com/vi/<?php echo e(substr($product->video_url, strrpos($product->video_url, '/') + 1)); ?>/0.jpg"
                                                     class="w-100px onerror-placeholder-image" alt="<?php echo e(translate('products')); ?>">
                                                <div class="play--icon">
                                                    <i class="bi bi-play-btn-fill"></i>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="product-single-content">
                    <form class="cart add_to_cart_form" action="<?php echo e(route('cart.add')); ?>" id="add-to-cart-form"
                          data-redirecturl="<?php echo e(route('checkout-details')); ?>"
                          data-varianturl="<?php echo e(route('cart.variant_price')); ?>"
                          data-errormessage="<?php echo e(translate('please_choose_all_the_options')); ?>"
                          data-outofstock="<?php echo e(translate('sorry').', '.translate('out_of_stock')); ?>.">
                        <?php echo csrf_field(); ?>
                        <h3 class="title"><?php echo e($product->name); ?></h3>
                        <input type="hidden" name="id" value="<?php echo e($product->id); ?>">
                        <div class="d-flex flex-wrap align-items-center column-gap-4">
                            <?php if($product->reviews_count > 0): ?>
                                <div class=" review position-relative">
                                    <i class="bi bi-star-fill"></i>
                                    <span><?php echo e(round($overallRating[0], 1)); ?> <small>(<?php echo e($product->reviews_count); ?> <?php echo e(translate('review')); ?>)</small></span>

                                    <div class="review-details-popup z-3">
                                        <div class="mb-4px"><?php echo e(translate('rating')); ?></div>
                                        <div class="review-items d-flex flex-column row-gap-1">
                                            <div class="d-flex column-gap-2 align-items-center">
                                                <div class="stars">
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                </div>
                                                <span class="progress">
                                                <div class="progress-fill"
                                                     style="--fill:<?php echo e(($rating[0] != 0?number_format($rating[0]*100 / array_sum($rating)):0)); ?>%"></div>
                                            </span>
                                                <span>(<?php echo e($rating[0]); ?>)</span>
                                            </div>
                                            <div class="d-flex column-gap-2 align-items-center">
                                                <div class="stars">
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                </div>
                                                <span class="progress">
                                                <div class="progress-fill"
                                                     style="--fill:<?php echo e(($rating[1] != 0?number_format($rating[1]*100 / array_sum($rating)):0)); ?>%"></div>
                                            </span>
                                                <span>(<?php echo e($rating[1]); ?>)</span>
                                            </div>
                                            <div class="d-flex column-gap-2 align-items-center">
                                                <div class="stars">
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                </div>
                                                <span class="progress">
                                                <div class="progress-fill"
                                                     style="--fill:<?php echo e(($rating[2] != 0?number_format($rating[2]*100 / array_sum($rating)):0)); ?>%"></div>
                                            </span>
                                                <span>(<?php echo e($rating[2]); ?>)</span>
                                            </div>
                                            <div class="d-flex column-gap-2 align-items-center">
                                                <div class="stars">
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                </div>
                                                <span class="progress">
                                                <div class="progress-fill"
                                                     style="--fill:<?php echo e(($rating[3] != 0?number_format($rating[3]*100 / array_sum($rating)):0)); ?>%"></div>
                                            </span>
                                                <span>(<?php echo e($rating[3]); ?>)</span>
                                            </div>
                                            <div class="d-flex column-gap-2 align-items-center">
                                                <div class="stars">
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                </div>
                                                <span class="progress">
                                                <div class="progress-fill"
                                                     style="--fill:<?php echo e(($rating[4] != 0?number_format($rating[4]*100 / array_sum($rating)):0)); ?>%"></div>
                                            </span>
                                                <span>(<?php echo e($rating[4]); ?>)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class=" review position-relative">
                                    <i class="bi bi-star-fill"></i>
                                    <span><?php echo e(round($overallRating[0], 1)); ?> <small class="text-capitalize">(<?php echo e(translate('no_review')); ?>)</small></span>
                                </div>
                            <?php endif; ?>
                            <?php if($product['product_type'] == 'physical' ): ?>
                                <span class="badge badge-soft-success stock_status">
                                    <span class="in_stock_status"><?php echo e($product->current_stock); ?></span> <?php echo e(translate('stock_available')); ?>

                                </span>
                                <span
                                    class="badge badge-soft-danger d-none out_of_stock_status"><?php echo e(translate('out_of_stock')); ?></span>
                                <span
                                    class="badge badge-soft-secondary limited_status d-none"><?php echo e(translate('limited_stock')); ?></span>
                            <?php endif; ?>

                        </div>
                        <div class="categories">
                            <span class="text-capitalize"><?php echo e(translate('category_tag')); ?> :</span>
                            <?php if($product->category_id): ?>
                                <a href="<?php echo e(route('products',['id'=> $product->category_id,'data_from'=>'category','page'=>1])); ?>"
                                   class="text-base">
                                    <?php echo e(ucwords(isset($product->category) ? $product->category->name:'')); ?>

                                </a>
                            <?php endif; ?>

                            <?php if($product->sub_category_id): ?>
                                <a href="<?php echo e(route('products',['id'=> $product->sub_category_id,'data_from'=>'category','page'=>1])); ?>"
                                   class="text-base">
                                    <?php echo e(ucwords(\App\Utils\CategoryManager::get_category_name($product->sub_category_id))); ?>

                                </a>
                            <?php endif; ?>

                            <?php if($product->sub_sub_category_id): ?>
                                <a href="<?php echo e(route('products',['id'=> $product->sub_sub_category_id,'data_from'=>'category','page'=>1])); ?>"
                                   class="text-base">
                                    <?php echo e(ucwords(\App\Utils\CategoryManager::get_category_name($product->sub_sub_category_id))); ?>

                                </a>
                            <?php endif; ?>
                        </div>
                        <hr>
                        <div class="price">
                            <h4><?php echo getPriceRangeWithDiscount(product: $product); ?>

                                <?php if($product->discount > 0): ?>
                                    <?php if($product->discount_type === "percent"): ?>
                                        <span class="badge bg-base">-<?php echo e($product->discount); ?>%</span>
                                    <?php else: ?>
                                        <span class="badge bg-base">
                                            <?php echo e(translate('save')); ?> <?php echo e(webCurrencyConverter(amount: $product->discount)); ?>

                                        </span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </h4>
                        </div>

                        <?php if(count(json_decode($product->colors)) > 0): ?>
                            <div>
                                <label class="form-label"><?php echo e(translate('color')); ?></label>
                                <div class="check-color-group justify-content-start align-items-center">
                                    <?php $__currentLoopData = json_decode($product->colors); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <label>
                                            <input type="radio" name="color"
                                                   value="<?php echo e($color); ?>" <?php echo e($key == 0 ? 'checked' : ''); ?>>
                                            <span style="--base:<?php echo e($color); ?>" class="focus_preview_image_by_color"
                                                  data-colorid="preview-box-<?php echo e(str_replace('#','',$color)); ?>"
                                                  id="color_variants_preview-box-<?php echo e(str_replace('#','',$color)); ?>">
                                        <i class="bi bi-check"></i>
                                    </span>
                                        </label>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <span class="color_name"></span>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php $__currentLoopData = json_decode($product->choice_options); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mt-20px">
                                <label class="form-label"><?php echo e(translate($choice->title)); ?></label>
                                <div class="d-flex flex-wrap gap-2">
                                    <?php $__currentLoopData = $choice->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <label class="form-check-size">
                                            <input type="radio" name="<?php echo e($choice->name); ?>" value="<?php echo e($option); ?>"
                                                <?php echo e($key == 0 ? 'checked' : ''); ?> >
                                            <span class="form-check-label"><?php echo e($option); ?></span>
                                        </label>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <div class="d-flex align-items-center row-gap-2 column-gap-4 mt-20px">
                            <span><?php echo e(translate('quantity')); ?> :</span>
                            <div class="inc-inputs">
                                <input type="number" name="quantity" value="<?php echo e($product->minimum_order_qty ?? 1); ?>"
                                       class="form-control product_quantity__qty product_qty"
                                       min="<?php echo e($product->minimum_order_qty ?? 1); ?>"
                                       max="<?php echo e($product['product_type'] == 'physical' ? $product->current_stock : 100); ?>">
                            </div>
                        </div>
                        <div class="btn-grp">
                            <?php if(($product->added_by == 'seller' && ($sellerTemporaryClose || (isset($product->seller->shop) && $product->seller->shop->vacation_status && $currentDate >= $sellerVacationStartDate && $currentDate <= $sellerVacationEndDate))) ||
                            (   $product->added_by == 'admin' && ($inHouseTemporaryClose || ($inHouseVacationStatus && $currentDate >= $inHouseVacationStartDate && $currentDate <= $inHouseVacationEndDate)))): ?>
                                <button type="button" class="btn btn-base text-capitalize font-medium" disabled>
                                    <?php echo $__env->make('theme-views.partials.icons._cart-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo e(translate('add_to_cart')); ?></button>
                                <button type="button"
                                        class="buy_now_button btn btn-base __btn-outline-warning secondary-color fs-16 text-capitalize"
                                        disabled>
                                    <?php echo $__env->make('theme-views.partials.icons._buy-now', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo e(translate('buy_now')); ?></span></button>

                            <?php else: ?>
                                <a href="javascript:"
                                   class="btn btn-base text-capitalize font-medium add_to_cart_button"
                                   data-form-id="add-to-cart-form">
                                    <?php echo $__env->make('theme-views.partials.icons._cart-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo e(translate('add_to_cart')); ?>

                                </a>
                                <?php ($guestCheckout = getWebConfig(name: 'guest_checkout')); ?>
                                <a href="javascript:"
                                   class="btn btn-base btn-md __btn-outline-warning secondary-color text-capitalize buy_now_function"
                                   data-formid="add-to-cart-form"
                                   data-authstatus="<?php echo e(($guestCheckout==1 || Auth::guard('customer')->check()?'true':'false')); ?>"
                                   data-route="<?php echo e(route('shop-cart')); ?>"
                                >
                                    <?php echo $__env->make('theme-views.partials.icons._buy-now', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo e(translate('buy_now')); ?></a>
                            <?php endif; ?>

                            <a href="javascript:"
                               class="btn btn-base btn-sm __btn-outline addWishlist_function_view_page"
                               data-id="<?php echo e($product['id']); ?>">
                                <i class="wishlist_<?php echo e($product['id']); ?> bi <?php echo e(($wishlistStatus == 1?'bi-heart-fill text-danger':'bi-heart')); ?> font--lg"></i>
                                <span
                                    class="product_wishlist_count_status"><?php echo e(\App\Utils\format_biginteger($countWishlist)); ?></span>
                            </a>

                            <?php ($compareList = count($product->compareList)>0 ? 1 : 0); ?>
                            <a href="javascript:"
                               class="addCompareList_view_page btn btn-base btn-sm __btn-outline text-base compare_list-<?php echo e($product['id']); ?> <?php echo e(($compareList == 1?'compare_list_icon_active':'')); ?>"
                               data-id="<?php echo e($product['id']); ?>">
                                <?php echo $__env->make('theme-views.partials.icons._compare', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </a>
                        </div>

                        <?php if(($product->added_by == 'seller' && ($sellerTemporaryClose || (isset($product->seller->shop) && $product->seller->shop->vacation_status && $currentDate >= $sellerVacationStartDate && $currentDate <= $sellerVacationEndDate))) ||
                        ($product->added_by == 'admin' && ($inHouseTemporaryClose || ($inHouseVacationStatus && $currentDate >= $inHouseVacationStartDate && $currentDate <= $inHouseVacationEndDate)))): ?>
                            <div class="alert alert-danger mt-3" role="alert">
                                <?php echo e(translate('this_shop_is_temporary_closed_or_on_vacation')); ?>

                                .
                                <?php echo e(translate('you_cannot_add_product_to_cart_from_this_shop_for_now')); ?>

                            </div>
                        <?php endif; ?>
                    </form>
                </div>

                <div class="product-single-pricing">
                    <div class="product-single-pricing-inner text-capitalize">
                        <h6 class="subtitle"><?php echo e(translate('total_price_for_this_product')); ?> :</h6>
                        <h3 class="price"><span
                                class="total_price"><?php echo e(\App\Utils\Helpers::currency_converter($product->unit_price)); ?></span>
                            <sub>( <?php echo e(translate('vat')); ?> <span
                                    class="tax_status"><?php echo e($product->tax_model == 'include' ? 'incl.' : \App\Utils\Helpers::currency_converter($product->tax)); ?></span>
                                )</sub></h3>

                        <div class="delivery-information mt-3">
                            <ul>
                                <?php if( isset($product['product_type']) && $product['product_type']== 'physical'&& $deliveryInfo['shipping_type'] && $deliveryInfo['shipping_type'] != "order_wise"): ?>
                                    <li>
                                        <img loading="lazy"
                                             src="<?php echo e(theme_asset('assets/img/products/icons/delivery-charge.png')); ?>"
                                             class="icons"
                                             alt="<?php echo e(translate('product')); ?>">
                                        <div class="cont">
                                            <div class="t-txt"><?php echo e(translate('delivery_charge')); ?> -</div>
                                            <span class="mt-1"> <?php echo e(translate('start_from')); ?> <span
                                                    class="text-base product_delivery_cost"
                                                    id="product_delivery_cost"><?php echo e(\App\Utils\Helpers::currency_converter($deliveryInfo['delivery_cost'])); ?></span></span>
                                        </div>
                                    </li>
                                <?php elseif(isset($product['product_type']) && $product['product_type']== 'physical' && $deliveryInfo['shipping_type'] == "order_wise"): ?>
                                    <li>
                                        <img loading="lazy"
                                             src="<?php echo e(theme_asset('assets/img/products/icons/delivery-charge.png')); ?>"
                                             class="icons"
                                             alt="<?php echo e(translate('product')); ?>">
                                        <div class="cont">
                                            <div class="t-txt"><?php echo e(translate('delivery_charge')); ?> -</div>
                                            <span class="mt-1"> <?php echo e(translate('start_from')); ?>

                                            <span class="text-base">
                                                <?php if($deliveryInfo['delivery_cost_max'] == $deliveryInfo['delivery_cost_min'] || $deliveryInfo['delivery_cost_max'] == 0): ?>
                                                    <?php echo e(\App\Utils\Helpers::currency_converter($deliveryInfo['delivery_cost_min'])); ?>

                                                <?php elseif($deliveryInfo['delivery_cost_min'] == 0): ?>
                                                    <?php echo e(\App\Utils\Helpers::currency_converter($deliveryInfo['delivery_cost_max'])); ?>

                                                <?php else: ?>
                                                    <?php echo e(\App\Utils\Helpers::currency_converter($deliveryInfo['delivery_cost_min'])); ?>

                                                    - <?php echo e(\App\Utils\Helpers::currency_converter($deliveryInfo['delivery_cost_max'])); ?>

                                                <?php endif; ?>
                                            </span>
                                        </span>
                                        </div>
                                    </li>
                                <?php endif; ?>
                                <?php ($refundDayLimit = getWebConfig(name: 'refund_day_limit')); ?>
                                <?php if(isset($web_config['refund_policy']['status']) && $web_config['refund_policy']['status'] == 1 && $refundDayLimit > 0): ?>
                                    <li>
                                        <img loading="lazy"
                                             src="<?php echo e(theme_asset('assets/img/products/icons/warranty.png')); ?>"
                                             class="icons" alt="<?php echo e(translate('product')); ?>">
                                        <div class="cont">
                                            <div class="t-txt"><?php echo e(translate('refund_policy')); ?>-</div>
                                            <span class="mt-1"><?php echo e($refundDayLimit); ?> <?php echo e(translate('days')); ?> <span
                                                    class="text-base mx-1"><a href="<?php echo e(route('terms')); ?>"
                                                                              target="_blank"><u><?php echo e(translate('refund_policy')); ?></u></a></span></span>
                                        </div>
                                    </li>
                                <?php endif; ?>
                                <?php if($product->added_by != "admin"): ?>
                                    <li>
                                        <div class="cont">
                                            <div class="d-flex gap-2">
                                                <?php if(auth('customer')->id() == ''): ?>
                                                    <a href="javascript:"
                                                       class="btn w-100 d-flex align-items-center gap-4px py-3 justify-content-center rounded btn-soft-base btn-sm customer_login_register_modal">
                                                        <img loading="lazy"
                                                             src="<?php echo e(theme_asset('assets/img/products/icons/ask-about.png')); ?>"
                                                             class="icons" alt="<?php echo e(translate('product')); ?>">
                                                        <div
                                                            class="t-txt"><?php echo e(translate('ask_about_this_product')); ?></div>
                                                    </a>
                                                <?php else: ?>
                                                    <a href="javascript:"
                                                       class="btn w-100 d-flex align-items-center gap-4px py-3 justify-content-center rounded btn-soft-base btn-sm"
                                                       data-bs-toggle="modal"
                                                       data-bs-target="#contact_sellerModal">
                                                        <img loading="lazy"
                                                             src="<?php echo e(theme_asset('assets/img/products/icons/ask-about.png')); ?>"
                                                             class="icons" alt="<?php echo e(translate('product')); ?>">
                                                        <div
                                                            class="t-txt"><?php echo e(translate('ask_about_this_product')); ?></div>
                                                    </a>
                                                <?php endif; ?>

                                            </div>
                                        </div>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <?php if($product->reviews_count >0): ?>
                <div class="details-review row-gap-4 mt-32px">
                    <div class="details-review-item">
                        <h2 class="title"><?php echo e($overallRating[0]); ?></h2>
                        <div class="text-star">
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <?php if($i <= (int)$overallRating[0]): ?>
                                    <i class="bi bi-star-fill"></i>
                                <?php elseif($overallRating[0] != 0 && $i <= (int)$overallRating[0] + 1.1 && $overallRating[0] > ((int)$overallRating[0])): ?>
                                    <i class="bi bi-star-half"></i>
                                <?php else: ?>
                                    <i class="bi bi-star"></i>
                                <?php endif; ?>
                            <?php endfor; ?>
                        </div>
                        <span><?php echo e($product->reviews_count); ?> <?php echo e(translate('reviews')); ?></span>
                    </div>
                    <div class="details-review-item">
                        <h2 class="title font-regular"><?php echo e(round($rattingStatus['positive'])); ?>%</h2>
                        <span class="text-capitalize"><?php echo e(translate('positive_review')); ?></span>
                    </div>
                    <div class="details-review-item details-review-info">
                        <div class="item">
                            <div class="form-label mb-3 d-flex justify-content-between">
                                <span><?php echo e(translate('positive')); ?></span>
                                <span><?php echo e(round($rattingStatus['positive'])); ?>%</span>
                            </div>
                            <div class="progress">
                                <div class="progress-fill"
                                     style="--fill:<?php echo e(round($rattingStatus['positive'])); ?>%"></div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="form-label mb-3 d-flex justify-content-between">
                                <span><?php echo e(translate('good')); ?></span>
                                <span><?php echo e(round($rattingStatus['good'])); ?>%</span>
                            </div>
                            <div class="progress">
                                <div class="progress-fill" style="--fill:<?php echo e(round($rattingStatus['good'])); ?>%"></div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="form-label mb-3 d-flex justify-content-between">
                                <span><?php echo e(translate('neutral')); ?></span>
                                <span><?php echo e(round($rattingStatus['neutral'])); ?>%</span>
                            </div>
                            <div class="progress">
                                <div class="progress-fill"
                                     style="--fill:<?php echo e(round($rattingStatus['neutral'])); ?>%"></div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="form-label mb-3 d-flex justify-content-between">
                                <span><?php echo e(translate('negative')); ?></span>
                                <span><?php echo e(round($rattingStatus['negative'])); ?>%</span>
                            </div>
                            <div class="progress">
                                <div class="progress-fill"
                                     style="--fill:<?php echo e(round($rattingStatus['negative'])); ?>%"></div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($product->details != null || count($product->reviews) != 0): ?>
                <div class="row g-2 mt-4">
                    <div class="col-xl-8 col-lg-7">
                        <div class="product-information">
                            <div class="product-information-inner">
                                <ul class="nav nav-tabs nav--tabs-2 justify-content-center">

                                    <li class="nav-item nav-item-ative">
                                        <a href="#general-info" class="nav-link active"
                                           data-bs-toggle="tab"><?php echo e(translate('general_info')); ?></a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="#comments" class="nav-link"
                                           data-bs-toggle="tab"><?php echo e(translate('comment')); ?>

                                            <sup><?php echo e($product->reviews_count); ?></sup></a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <?php if($product->details != null): ?>
                                        <div class="tab-pane fade show active" id="general-info">
                                            <div class="general-information">
                                                <?php echo $product->details; ?>

                                            </div>
                                            <a href="javascript:" class="product-information-view-more"
                                               data-view-more="<?php echo e(translate('view_more')); ?>"
                                               data-view-less="<?php echo e(translate('view_less')); ?>">
                                                <?php echo e(translate('view_more')); ?>

                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <div class="tab-pane fade show active" id="general-info">
                                            <div class="general-information">
                                                <?php echo e(translate('No_data_found')); ?>

                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <div class="tab-pane fade" id="comments">
                                        <?php if(count($product->reviews) > 0): ?>
                                            <div class="comments-information">
                                                <ul id="product-review-list">
                                                    <?php echo $__env->make('theme-views.layouts.partials._product-reviews',['productReviews'=>$productReviews], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </ul>
                                            </div>
                                            <?php if(count($product->reviews) > 2): ?>
                                                <a href="javascript:" id="load_review_function"
                                                   class="product-information-view-more-custom see-more-details-review view_text"
                                                   data-productid="<?php echo e($product->id); ?>"
                                                   data-routename="<?php echo e(route('review-list-product')); ?>"
                                                   data-afterextend="<?php echo e(translate('see_less')); ?>"
                                                   data-seemore="<?php echo e(translate('see_more')); ?>"
                                                   data-onerror="<?php echo e(translate('no_more_review_remain_to_load')); ?>"><?php echo e(translate('see_more')); ?></a>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <div class="text-center w-100">
                                                <div class="text-center pt-5 mb-5">
                                                    <img loading="lazy"
                                                         src="<?php echo e(theme_asset('assets/img/icons/review.svg')); ?>"
                                                         alt="<?php echo e(translate('review')); ?>">
                                                    <h5 class="my-3 pt-2 text-muted"><?php echo e(translate('not_reviewed_yet')); ?>

                                                        !</h5>
                                                    <p class="text-center text-muted"><?php echo e(translate('sorry_no_review_found_to_show_you')); ?></p>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if($productsThisStoreTopRated->count() > 0): ?>
                        <div class="col-xl-4 col-lg-5">
                            <div
                                class="border top-rated-product-from-store-wrapper p-3 p-md-18 d-flex flex-column justify-content-center border-light-base shadow-light-base">
                                <div class="section-title mb-4 pb-lg-1">
                                    <div
                                        class="d-flex justify-content-between row-gap-2 column-gap-4 align-items-center">
                                        <h4 class="mb-0 me-auto text-capitalize"><?php echo e(translate('top_rated_product_from_this_store')); ?></h4>
                                    </div>
                                </div>
                                <div class="overflow-hidden">
                                    <div class="side-column-slider">
                                        <div class="owl-theme owl-carousel slider">
                                            <?php $__currentLoopData = $productsThisStoreTopRated; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo $__env->make('theme-views.partials._similar-product-large-card', ['product'=>$relatedProduct], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <?php if($productsThisStoreTopRated->count() > 0): ?>
                    <div class="mt-3">
                        <div
                            class="border h-100 p-3 p-md-18 d-flex flex-column justify-content-center border-light-base shadow-light-base">
                            <div class="section-title mb-4 pb-lg-1">
                                <div class="d-flex justify-content-between row-gap-2 column-gap-4 align-items-center">
                                    <h4 class="mb-0 me-auto text-capitalize"><?php echo e(translate('top_rated_product_from_this_store')); ?></h4>
                                    <div
                                        class="d-flex align-items-center column-gap-4 justify-content-end ms-auto ms-md-0">
                                        <div class="owl-prev top-rated-product-from-store-prev"><i
                                                class="bi bi-chevron-left"></i>
                                        </div>
                                        <div class="owl-next top-rated-product-from-store-next"><i
                                                class="bi bi-chevron-right"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="overflow-hidden">
                                <div class="side-column-slider">
                                    <div class="owl-theme owl-carousel top-rated-product-from-store-slider">
                                        <?php $__currentLoopData = $productsThisStoreTopRated; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo $__env->make('theme-views.partials._similar-product-large-card', ['product'=>$relatedProduct], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <?php if($web_config['business_mode'] == 'multi'): ?>
                <div class="mt-4">
                    <div class="similler-product-slider-wrapper">
                        <div class="row g-0">
                            <div class="col-md-5 col-lg-4 col-xl-3">
                                <div class="p-3 ps-xl-4">
                                    <?php if($product->added_by == 'seller'): ?>
                                        <?php if(isset($product->seller->shop)): ?>
                                            <div class="others-store-card bg-white p-0">
                                                <div class="p-3 pt-4">
                                                    <div class="name-area">
                                                        <div class="position-relative ">
                                                            <div>
                                                                <img loading="lazy" class="rounded-full other-store-logo"
                                                                     src="<?php echo e(getValidImage(path: 'storage/app/public/shop/'.$product->seller->shop->image, type:'shop')); ?>"
                                                                     alt="<?php echo e(translate('others_store')); ?>">
                                                            </div>
                                                            <?php if($product->seller->shop->temporary_close || ($product->seller->shop->vacation_status && ($currentDate >= $product->seller->shop->vacation_start_date) && ($currentDate <= $product->seller->shop->vacation_end_date))): ?>
                                                                <span
                                                                    class="temporary-closed position-absolute text-center h6 rounded-full">
                                                            <span><?php echo e(translate('closed_now')); ?></span>
                                                        </span>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="info">
                                                            <h6 class="name"><?php echo e($product->seller->shop->name); ?></h6>
                                                            <span
                                                                class="offer-badge"><?php echo e(round($ratingPercentage)); ?>% <?php echo e(translate('positive_review')); ?></span>
                                                        </div>
                                                    </div>
                                                    <div class="info-area mb-2">
                                                        <div class="info-item">
                                                            <h6><?php echo e($totalReviews); ?></h6>
                                                            <span><?php echo e(translate('reviews')); ?></span>
                                                        </div>
                                                        <div class="info-item">
                                                            <h6><?php echo e($productsCount); ?></h6>
                                                            <span><?php echo e(translate('products')); ?></span>
                                                        </div>
                                                        <div class="info-item">
                                                            <h6><?php echo e(number_format($avgRating, 2)); ?></h6>
                                                            <i class="bi bi-star-fill"></i>
                                                            <span><?php echo e(translate('rating')); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="btn-grp d-flex jusitfy-content-center bg-E2F0FF gap-2 p-3">
                                                    <a href="<?php echo e(route('shopView',[$product->seller->id])); ?>"
                                                       class="btn bg-white __btn-outline">
                                                        <i class="bi bi-shop"></i> <?php echo e(translate('visit_shop')); ?>

                                                    </a>
                                                    <?php if(auth('customer')->id() == ''): ?>
                                                        <a href="javascript:"
                                                           class="btn bg-white __btn-outline customer_login_register_modal">
                                                            <i class="bi bi-chat-dots"></i> <?php echo e(translate('chat')); ?>

                                                        </a>
                                                    <?php else: ?>
                                                        <a href="javascript:" class="btn bg-white __btn-outline"
                                                           data-bs-toggle="modal"
                                                           data-bs-target="#contact_sellerModal">
                                                            <i class="bi bi-chat-dots"></i> <?php echo e(translate('chat')); ?>

                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                                <?php if(auth('customer')->id() != ''): ?>
                                                    <?php echo $__env->make('theme-views.layouts.partials.modal._chat-with-seller',['sellerId'=>$product->seller->id,'shopId'=>$product->seller->shop->id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <div class="others-store-card bg-white p-0">
                                            <div class="p-3 pt-4">
                                                <div class="name-area">
                                                    <img loading="lazy" alt="<?php echo e(translate('logo')); ?>"
                                                         src="<?php echo e(getValidImage(path: "storage/app/public/company/".$web_config['fav_icon']->value, type:'logo')); ?>">
                                                    <div class="info">
                                                        <h6 class="name"><?php echo e($web_config['name']->value); ?></h6>
                                                        <span class="offer-badge">
                                                        <?php echo e(round($ratingPercentage)); ?>% <?php echo e(translate('positive_review')); ?>

                                                    </span>
                                                    </div>
                                                </div>
                                                <div class="info-area mb-2">
                                                    <div class="info-item">
                                                        <h6><?php echo e($totalReviews); ?></h6>
                                                        <span><?php echo e(translate('reviews')); ?></span>
                                                    </div>
                                                    <div class="info-item">
                                                        <h6><?php echo e($productsCount); ?></h6>
                                                        <span><?php echo e(translate('products')); ?></span>
                                                    </div>
                                                    <div class="info-item">
                                                        <h6><?php echo e(number_format($avgRating, 2)); ?></h6>
                                                        <i class="bi bi-star-fill"></i>
                                                        <span><?php echo e(translate('rating')); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="btn-grp d-flex jusitfy-content-center bg-E2F0FF gap-2 p-3">
                                                <a href="<?php echo e(route('shopView',[0])); ?>" class="btn bg-white __btn-outline">
                                                    <i class="bi bi-shop"></i> <?php echo e(translate('visit_shop')); ?>

                                                </a>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>


                            <div class="col-md-7 col-lg-8 col-xl-9">
                                <div class="py-3 ps-3">
                                    <div class="section-title mb-4 pb-lg-1 pe-3">
                                        <div
                                            class="d-flex flex-wrap justify-content-between row-gap-2 column-gap-4 align-items-center text-capitalzie">
                                            <h6 class="mb-0 me-auto font-bold "><?php echo e(translate('similar_product_from_this_store')); ?>

                                                <small
                                                    class="font-regular text-text-2">(<?php echo e(count($moreProductFromSeller)); ?> <?php echo e(translate('product')); ?>

                                                    )</small>
                                            </h6>
                                            <?php if($product->added_by=='seller'): ?>
                                                <?php if(isset($product->seller->shop)): ?>
                                                    <a href="<?php echo e(route('shopView',[$product->seller->id])); ?>"
                                                       class="see-all"><?php echo e(translate('see_all')); ?></a>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <a href="<?php echo e(route('shopView',[0])); ?>"
                                                   class="see-all"><?php echo e(translate('see_all')); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="overflow-hidden">
                                        <?php if($moreProductFromSeller->count() > 0): ?>
                                            <div class="similler-product-slider-area">
                                                <div class="similler-product-slider owl-theme owl-carousel">
                                                    <?php $__currentLoopData = $moreProductFromSeller; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php echo $__env->make('theme-views.partials._product-small-card', ['product'=>$product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <div class="d-flex">
                                                <div class="card">
                                                    <div class="card-body">
                                                        <h6><?php echo e(translate('similar_product_not_available')); ?></h6>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

        </div>
    </section>

    <section class="recommended-product-section section-gap pb-0">
        <div class="container">
            <div class="section-title mb-4 pb-lg-1">
                <div
                    class="d-flex flex-column flex-md-row justify-content-md-between row-gap-2 column-gap-4 align-items-md-center single_section_dual_tabs text-capitalize">
                    <h2 class="title mb-0 me-auto text-capitalize"><?php echo e(translate('you_may_also_like')); ?></h2>
                    <div class="d-flex column-gap-4 align-items-center justify-content-between">
                        <ul class="nav nav-tabs nav--tabs single_section_dual_btn text-capit">
                            <li data-targetbtn="0" role="tab">
                                <a href="#latest" class="active"
                                   data-bs-toggle="tab"><?php echo e(translate('latest_product')); ?></a>
                            </li>
                            <li data-targetbtn="1" role="tab">
                                <a href="#top-rated-product" data-bs-toggle="tab"><?php echo e(translate('top_rated')); ?></a>
                            </li>
                        </ul>
                        <div
                            class="d-flex align-items-center column-gap-3 column-gap-md-4 justify-content-end ms-auto ms-md-0">
                            <div class="owl-prev recommended-prev">
                                <i class="bi bi-chevron-left"></i>
                            </div>
                            <div class="owl-next recommended-nex">
                                <i class="bi bi-chevron-right"></i>
                            </div>
                            <div class="single_section_dual_target">
                                <a href="<?php echo e(route('products',['data_from'=>'latest','page'=>1])); ?>"
                                   class="see-all text-nowrap"><?php echo e(translate('see_all')); ?></a>
                                <a href="<?php echo e(route('products',['data_from'=>'top-rated','page'=>1])); ?>"
                                   class="see-all d-none"><?php echo e(translate('see_all')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="overflow-hidden">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="latest">
                        <div class="recommended-slider-wrapper">
                            <div class="recommended-slider owl-theme owl-carousel">
                                <?php $__currentLoopData = $productsLatest; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singleProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo $__env->make('theme-views.partials._product-medium-card', ['product'=>$singleProduct], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="top-rated-product">
                        <div class="recommended-slider-wrapper">
                            <div class="recommended-slider owl-theme owl-carousel">
                                <?php $__currentLoopData = $productsTopRated; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singleProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo $__env->make('theme-views.partials._product-medium-card', ['product'=>$singleProduct], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <?php if($web_config['business_mode'] == 'multi'): ?>
        <?php echo $__env->make('theme-views.partials._other-stores', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <?php echo $__env->make('theme-views.partials._how-to-section', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(theme_asset('assets/js/product-details.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('theme-views.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesignbd/ecommerce10.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/product/details.blade.php ENDPATH**/ ?>