<?php ($overallRating = getOverallRating($product->reviews)); ?>

<div class="product-card product-card-row">

    <div class="product-card-inner d-">

        <div class="img">
            <a href="<?php echo e(route('product',$product->slug)); ?>" class="d-block h-100">
                <img loading="lazy" class="w-100" alt="<?php echo e(translate('product')); ?>"
                     src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.$product->thumbnail, type:'product')); ?>">
            </a>
            <?php ($wishlist = count($product->wishList)>0 ? 1 : 0); ?>
            <a href="javascript:" class="d-inline-flex wish-icon addWishlist_function_view_page"
               data-id="<?php echo e($product->id); ?>">
                <i class="wishlist_<?php echo e($product->id); ?> bi <?php echo e(($wishlist == 1?'bi-heart-fill text-danger':'bi-heart')); ?>"></i>
            </a>
        </div>
        <div class="cont">
            <h6 class="title">
                <a href="<?php echo e(route('product',$product->slug)); ?>"><?php echo e(Str::limit($product['name'], 25)); ?></a>
            </h6>
            <div class="rating">
                <?php for($i = 1; $i <= 5; $i++): ?>
                    <?php if($i <= (int)$overallRating[0]): ?>
                        <i class="bi bi-star-fill filled"></i>
                    <?php elseif($overallRating[0] != 0 && $i <= (int)$overallRating[0] + 1.1 && $overallRating[0] > ((int)$overallRating[0])): ?>
                        <i class="bi bi-star-half filled"></i>
                    <?php else: ?>
                        <i class="bi bi-star-fill"></i>
                    <?php endif; ?>
                <?php endfor; ?>
            </div>
            <div
                class="d-flex align-items-center justify-content-between column-gap-2 my-2 my-md-3">
                <h4 class="price">
                    <span><?php echo e(\App\Utils\Helpers::currency_converter($product->unit_price-\App\Utils\Helpers::get_product_discount($product,$product->unit_price))); ?></span>
                    <?php if($product->discount > 0): ?>
                        <del><?php echo e(\App\Utils\Helpers::currency_converter($product->unit_price)); ?></del>
                    <?php endif; ?>
                </h4>
            </div>
            <?php if($product->order_details_sum_qty > 0): ?>
                <?php if($product['product_type'] == 'physical'): ?>
                    <div class="sold-info d-flex">
                        <span>
                            <?php echo e($product->order_details_sum_qty); ?> <?php echo e(translate('sold')); ?>

                        </span>
                        <span> / </span>
                        <span>
                            <?php echo e($product->order_details_sum_qty + $product->current_stock); ?> <?php echo e(translate('item')); ?>

                        </span>
                    </div>
                <?php else: ?>
                    <div class="sold-info">
                        <?php echo e($product->order_details_sum_qty); ?> <?php echo e(translate('sold')); ?>

                    </div>
                <?php endif; ?>
            <?php endif; ?>
            <div class="sold-info my-2 my-md-3"><?php echo e(translate('category')); ?>:
                <span><?php echo e(\Illuminate\Support\Str::limit(isset($product->category) ? $product->category->name:'', 15)); ?></span>
            </div>
            <div class="d-flex flex-wrap gap-2">
                <?php if(json_decode($product->variation) != null): ?>
                    <a href="javascript:" data-id="<?php echo e($product['id']); ?>"
                       class="btn btn-base flex-grow-1 justify-content-center __btn-outline quickView_action">
                        <i class="bi bi-cart"></i>
                        <?php echo e(translate('add_to_cart')); ?>

                    </a>
                <?php else: ?>
                    <form class="cart d-none" action="<?php echo e(route('cart.add')); ?>" id="add-to-cart-form-<?php echo e($product['id']); ?>"
                          data-errormessage="<?php echo e(translate('please_choose_all_the_options')); ?>"
                          data-outofstock="<?php echo e(translate('sorry').', '.translate('out_of_stock')); ?>.">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($product->id); ?>">
                        <input type="number" name="quantity" value="<?php echo e($product->minimum_order_qty ?? 1); ?>"
                               class="form-control product_quantity__qty" hidden>
                    </form>
                    <a href="javascript:" class="add_to_cart_button"
                       data-form-id="<?php echo e('add-to-cart-form-'.$product['id']); ?>"
                       class="btn btn-base flex-grow-1 justify-content-center __btn-outline">
                        <i class="bi bi-cart"></i>
                        <?php echo e(translate('add_to_cart')); ?>

                    </a>
                <?php endif; ?>
                <?php ($compareList = count($product->compareList)>0 ? 1 : 0); ?>
                <a href="javascript:"
                   class="btn btn-base flex-grow-1 justify-content-center __btn-outline addCompareList_view_page"
                   data-id="<?php echo e($product['id']); ?>"><i
                        class="bi bi-shuffle compare_list_icon-<?php echo e($product['id']); ?> <?php echo e(($compareList == 1?'text-base':'')); ?>"></i></a>
            </div>
        </div>
    </div>
</div>


<?php /**PATH /home/youngerlifestyle/public_html/resources/themes/theme_fashion/theme-views/partials/_similar-product-large-card.blade.php ENDPATH**/ ?>