<?php $__env->startSection('title', translate('shopping_details').' | '.$web_config['name']->value.' '.translate('ecommerce')); ?>

<?php $__env->startSection('content'); ?>

<section class="breadcrumb-section pt-20px">
    <div class="container">
        <div class="section-title mb-4">
            <div
                class="d-flex flex-wrap justify-content-between row-gap-3 column-gap-2 align-items-center search-page-title">
                <ul class="breadcrumb">
                    <li>
                        <a href="<?php echo e(route('home')); ?>"><?php echo e(translate('home')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('shop-cart')); ?>"><?php echo e(translate('cart')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(url()->current()); ?>" class="text-base custom-text-link"><?php echo e(translate('checkout')); ?></a>
                    </li>
                </ul>
                <div class="ms-auto ms-md-0">
                    <a href="<?php echo e(route('shop-cart')); ?>" class="text-base custom-text-link"><?php echo e(translate('check_All_CartList')); ?></a>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="checkout-section pt-4 section-gap">
    <div class="container">
        <h3 class="mb-3 mb-lg-4 d-flex justify-content-center justify-content-sm-start"><?php echo e(translate('checkout')); ?></h3>
        <div class="row g-4">
            <div class="col-lg-7">
                <ul class="checkout-flow">
                    <li class="checkout-flow-item active">
                        <a href="javascript:">
                            <span class="serial"><?php echo e(translate('1')); ?></span>
                            <span class="icon">
                                <i class="bi bi-check"></i>
                            </span>
                            <span class="text thisIsALinkElement" data-linkpath="<?php echo e(route('shop-cart')); ?>"><?php echo e(translate('cart')); ?></span>
                        </a>
                    </li>
                    <li class="line"></li>
                    <li class="checkout-flow-item active current">
                        <a href="javascript:">
                            <span class="serial"><?php echo e(translate('2')); ?></span>
                            <span class="icon">
                                <i class="bi bi-check"></i>
                            </span>
                            <span class="text text-capitalize"><?php echo e(translate('shipping_details')); ?></span>
                        </a>
                    </li>
                    <li class="line"></li>
                    <li class="checkout-flow-item">
                        <a href="javascript:">
                            <span class="serial"><?php echo e(translate('3')); ?></span>
                            <span class="icon">
                                <i class="bi bi-check"></i>
                            </span>
                            <span class="text"><?php echo e(translate('payment')); ?></span>
                        </a>
                    </li>
                </ul>
                <input type="hidden" id="physical_product" name="physical_product" value="<?php echo e($physical_product_view ? 'yes':'no'); ?>">
                <input type="hidden" id="billing_input_enable" name="billing_input_enable" value="<?php echo e($billing_input_by_customer); ?>">
                <div class="delivery-information">
                    <h6 class="font-bold letter-spacing-0 title text-capitalize mb-20px">
                        <?php echo e(translate('delivery_information_details')); ?>

                    </h6>
                </div>


                <?php if($physical_product_view): ?>
                    <form method="post" id="address-form">
                        <div class="delivery-information mt-32px">
                            <div class="d-flex flex-wrap row-gap-3 column-gap-4 mb-20px align-items-end">
                                <h6 class="font-bold letter-spacing-0 title m-0 text-capitalize"><?php echo e(translate('delivery_address')); ?></h6>
                                <?php if(auth('customer')->check()): ?>
                                    <div class="ms-auto text-base text-capitalize" type="button" data-bs-target="#shipping_addresses" data-bs-toggle="modal">
                                        <?php echo e(translate('select_from_saved')); ?>

                                    </div>
                                <?php endif; ?>

                                <div class="<?php if(!auth('customer')->check()): ?> ms-auto <?php endif; ?> text-base text-capitalize" type="button" data-bs-target="#set_shipping_address" data-bs-toggle="modal">
                                    <?php echo e(translate('set_from_map')); ?> <i class="bi bi-geo-alt-fill"></i>
                                </div>

                                <div class="modal fade" id="set_shipping_address">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title text-capitalize"><?php echo e(translate('set_delivery_address')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="modal-body">
                                                    <div class="product-quickview">

                                                        <input id="pac-input" class="controls rounded __map-input mt-1" title="<?php echo e(translate('search_your_location_here')); ?>" type="text" placeholder="<?php echo e(translate('search_here')); ?>"/>
                                                        <div class="dark-support rounded w-100 __h-14rem" id="location_map_canvas"></div>
                                                        <input type="hidden" id="latitude" name="latitude" class="form-control d-inline"
                                                             value="<?php echo e($default_location?$default_location['lat']:0); ?>" required>
                                                        <input type="hidden" name="longitude" class="form-control"
                                                            id="longitude" value="<?php echo e($default_location?$default_location['lng']:0); ?>" required >
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer p-3">
                                                <button type="button" class="btn rounded btn-base secondary-color" data-bs-dismiss="modal"><?php echo e(translate('close')); ?></button>
                                                <button type="button" data-bs-dismiss="modal" class="btn rounded btn-base"><?php echo e(translate('update')); ?></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-4">
                                <div class="col-sm-<?php if(auth('customer')->check()): ?> '6' <?php else: ?> '12' <?php endif; ?>">
                                    <input type="text" placeholder="<?php echo e(translate('contact_person_name')); ?>" id="name" name="contact_person_name" class="form-control" <?php echo e($shipping_addresses->count()==0?'required':''); ?>>
                                </div>
                                <div class="col-sm-6">
                                    <input type="tel" placeholder="<?php echo e(translate('phone')); ?>" name="phone" id="phone_number" class="form-control" <?php echo e($shipping_addresses->count()==0?'required':''); ?>>
                                </div>
                                <?php if(!auth('customer')->check()): ?>
                                    <div class="col-sm-6">
                                        <input type="email" name="email" id="email" class="form-control" placeholder="<?php echo e(translate('email')); ?>" required>
                                    </div>
                                <?php endif; ?>
                                <div class="col-sm-6">
                                    <select name="country" id="country" class="form-control select2-init">
                                        <option value=""><?php echo e(translate('select_country')); ?></option>
                                        <?php $__empty_1 = true; $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <option value="<?php echo e($country['name']); ?>"><?php echo e($country['name']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <option value=""><?php echo e(translate('no_country_to_deliver')); ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="col-sm-6 col-md-3">
                                    <input type="text" name="city" id="city" placeholder="<?php echo e(translate('city')); ?>" class="form-control"  <?php echo e($shipping_addresses->count()==0?'required':''); ?>>
                                </div>
                                <div class="col-sm-6 col-md-3">
                                    <?php if($zip_restrict_status == 1): ?>
                                    <select name="zip" id="zip" class="form-control select2-init" data-live-search="true" required>
                                        <?php $__empty_1 = true; $__currentLoopData = $zip_codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <option value="<?php echo e($code->zipcode); ?>"><?php echo e($code->zipcode); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <option value=""><?php echo e(translate('no_zip_to_deliver')); ?></option>
                                        <?php endif; ?>
                                    </select>
                                    <?php else: ?>
                                        <input type="text" class="form-control" name="zip" id="zip" placeholder="<?php echo e(translate('zip_Code')); ?>" <?php echo e($shipping_addresses->count()==0?'required':''); ?>>
                                    <?php endif; ?>
                                </div>

                                <div class="col-sm-12">
                                    <select name="address_type" id="address_type" class="form-select form-control ">
                                        <option value="permanent"><?php echo e(translate('permanent')); ?></option>
                                        <option value="home"><?php echo e(translate('home')); ?></option>
                                        <option value="others"><?php echo e(translate('others')); ?></option>
                                    </select>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-control p-0 rounded d-flex align-items-center force-border-input">
                                        <input type="text" name="address" id="address" placeholder="<?php echo e(translate('address')); ?>" class="form-control border-0 bg-transparent p-3 outline-custom-remove" <?php echo e($shipping_addresses->count()==0?'required':''); ?> autocomplete="off">
                                        <div class="border-start p-3" data-bs-toggle="modal" data-bs-target="#set_shipping_address">
                                            <i class="bi bi-compass-fill cursor-pointer"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12" >
                                    <label class="form-check m-0" id="save_address_label">
                                        <input type="hidden" name="shipping_method_id" id="shipping_method_id" value="0">
                                        <?php if(auth('customer')->check()): ?>
                                            <input type="checkbox" name="save_address" id="save_address" class="form-check-input dark-form-check-input">
                                            <span class="form-check-label"><?php echo e(translate('save_this_address')); ?></span>
                                        <?php endif; ?>
                                    </label>

                                </div>
                            </div>
                        </div>
                    </form>
                <?php endif; ?>

                <?php if($billing_input_by_customer): ?>
                    <div class="delivery-information mt-32px <?php echo e($billing_input_by_customer ? '':'d-none'); ?>">

                        <div class="col-md-12 g-4">
                            <div class="--bg-4 rounded p-3 d-flex row-gap-2 column-gap-3 align-items-center justify-content-between">
                                <h6 class="font-bold letter-spacing-0 title m-0 text-capitalize"><?php echo e(translate('billing_address')); ?></h6>

                                <?php if($physical_product_view): ?>
                                <label class="form-check flow-reverse m-0">
                                    <span class="form-check-label text-capitalize"><?php echo e(translate('same_as_delivery_address')); ?></span>
                                    <input type="checkbox" name="same_as_shipping_address" id="same_as_shipping_address" class="form-check-input  dark-form-check-input" <?php echo e($billing_input_by_customer==1?'':'checked'); ?>>
                                </label>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div id="billing-address" class="mt-20px">
                            <form method="post" id="billing-address-form">
                                <div class="delivery-information mt-32px" id="hide_billing_address">
                                    <div class="d-flex flex-wrap row-gap-3 column-gap-4 mb-20px align-items-end">
                                        <?php if(auth('customer')->check()): ?>
                                            <div class="ms-auto text-base" type="button" data-bs-target="#billing_addresses" data-bs-toggle="modal">
                                                <?php echo e(translate('select_from_saved')); ?>

                                            </div>
                                        <?php endif; ?>

                                        <div class="text-base" type="button" data-bs-target="#set_billing_addresses" data-bs-toggle="modal">
                                            <?php echo e(translate('set_from_map')); ?> <i class="bi bi-geo-alt-fill"></i>
                                        </div>

                                        <div class="modal fade" id="set_billing_addresses">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title text-capitalize"><?php echo e(translate('set_delivery_address')); ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="modal-body">
                                                            <div class="product-quickview">

                                                                <input id="pac-input-billing" class="controls rounded __map-input mt-1" title="<?php echo e(translate('search_your_location_here')); ?>" type="text" placeholder="<?php echo e(translate('search_here')); ?>"/>
                                                                <div class="dark-support rounded w-100 __h-14rem" id="billing_location_map_canvas"></div>
                                                                <input type="hidden" id="billing_latitude" name="billing_latitude" class="form-control d-inline"
                                                                    value="<?php echo e($default_location?$default_location['lat']:0); ?>" required readonly>
                                                                <input type="hidden" name="billing_longitude" class="form-control"
                                                                    id="billing_longitude" value="<?php echo e($default_location?$default_location['lng']:0); ?>" required >
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer p-3">
                                                        <button type="button" class="btn btn-base secondary-color"
                                                            data-bs-dismiss="modal"><?php echo e(translate('close')); ?></button>
                                                        <button type="button" data-bs-dismiss="modal" class="btn rounded btn-base"><?php echo e(translate('Update')); ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-4">
                                        <div class="col-sm-<?php if(auth('customer')->check()): ?> '6' <?php else: ?> '12' <?php endif; ?>">
                                            <input type="text" placeholder="<?php echo e(translate('contact_Person_Name')); ?>" id="billing_contact_person_name" name="billing_contact_person_name" class="form-control" <?php echo e($shipping_addresses->count()==0?'required':''); ?>>
                                        </div>
                                        <div class="col-sm-6">
                                            <input type="tel" placeholder="<?php echo e(translate('phone')); ?>" name="billing_phone" id="billing_phone" class="form-control" <?php echo e($shipping_addresses->count()==0?'required':''); ?>>
                                        </div>
                                        <?php if(!auth('customer')->check()): ?>
                                            <div class="col-sm-6">
                                                <input type="text" name="billing_contact_email" id="billing_contact_email" class="form-control" placeholder="<?php echo e(translate('email')); ?>" required>
                                            </div>
                                        <?php endif; ?>
                                        <div class="col-sm-6">
                                            <select name="billing_country" id="billing_country" class="form-control select2-init">
                                                <option value=""><?php echo e(translate('select_country')); ?></option>
                                                <?php $__empty_1 = true; $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <option value="<?php echo e($country['name']); ?>"><?php echo e($country['name']); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <option value=""><?php echo e(translate('no_country_to_deliver')); ?></option>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <div class="col-sm-6 col-md-3">
                                            <input type="text" name="billing_city" id="billing_city" placeholder="<?php echo e(translate('city')); ?>" class="form-control"  <?php echo e($shipping_addresses->count()==0?'required':''); ?>>
                                        </div>
                                        <div class="col-sm-6 col-md-3">
                                            <?php if($zip_restrict_status == 1): ?>
                                            <select name="billing_zip" id="billing_zip" class="form-control select2-init" data-live-search="true" required>
                                                <?php $__empty_1 = true; $__currentLoopData = $zip_codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <option value="<?php echo e($code->zipcode); ?>"><?php echo e($code->zipcode); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <option value=""><?php echo e(translate('no_zip_to_deliver')); ?></option>
                                                <?php endif; ?>
                                            </select>
                                            <?php else: ?>
                                                <input type="text" class="form-control" name="billing_zip" id="billing_zip" placeholder="<?php echo e(translate('zip_Code')); ?>" <?php echo e($shipping_addresses->count()==0?'required':''); ?>>
                                            <?php endif; ?>
                                        </div>

                                        <div class="col-sm-12">
                                            <select name="billing_address_type" id="billing_address_type" class="form-select form-control ">
                                                <option value="permanent"><?php echo e(translate('permanent')); ?></option>
                                                <option value="home"><?php echo e(translate('home')); ?></option>
                                                <option value="others"><?php echo e(translate('others')); ?></option>
                                            </select>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-control p-0 rounded d-flex align-items-center force-border-input">
                                                <input type="text" id="billing_address" name="billing_address" placeholder="<?php echo e(translate('Address')); ?>" class="border-0 bg-transparent p-3 outline-custom-remove form-control" autocomplete="off">
                                                <div class="border-start p-3" data-bs-toggle="modal" data-bs-target="#set_billing_addresses">
                                                    <i class="bi bi-compass-fill cursor-pointer"></i>
                                                </div>
                                            </div>
                                        </div>

                                        <input type="hidden" name="billing_method_id" id="billing_method_id" value="0">
                                        <?php if(auth('customer')->check()): ?>
                                            <div class="col-sm-12" >
                                                <label class="form-check m-0" id="save-billing-address-label">
                                                    <input type="checkbox" name="save_address_billing" id="save_address_billing" class="form-check-input dark-form-check-input">
                                                    <span class="form-check-label"><?php echo e(translate('save_this_Address')); ?></span>
                                                </label>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-lg-5">
                <?php echo $__env->make('theme-views.partials._order-summery', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

        </div>
    </div>
</section>

<div class="modal fade" id="shipping_addresses">
    <div class="modal-dialog modal-dialog-centered ">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(translate('Saved_Addresses')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mapouter">
                    <div class="row ">
                        <?php if(auth('customer')->check() && $shipping_addresses->count()>0): ?>
                            <?php $__currentLoopData = $shipping_addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-12">
                                    <div class="address-card mb-20px ">
                                        <div class="address-card-header bg-transparent d-flex justify-content-between align-items-center">
                                            <label class="d-flex align-items-start gap-3 cursor-pointer mb-0 w-100">
                                                <input class="s-16px form-check-input mt-1" type="radio" name="shipping_method_id" value="<?php echo e($address['id']); ?>" <?php echo e($key==0?'checked':''); ?>>
                                                <div class="__border-base"></div>
                                                <div class="w-0 flex-grow-1">
                                                    <div class="d-flex justify-content-between align-items-center column-gap-4">
                                                        <h6 class="text-capitalize"><?php echo e($address['address_type']); ?></h6>
                                                        <a href="<?php echo e(route('address-edit',$address->id)); ?>" >
                                                            <img loading="lazy" src="<?php echo e(theme_asset('assets/img/icons/edit.png')); ?>" alt="<?php echo e(translate('edit')); ?>">
                                                        </a>
                                                    </div>
                                                    <div class="address-card-body pb-0 px-0 text-start">
                                                        <ul>
                                                            <li>
                                                                <span class="form--label w-70px"><?php echo e(translate('name')); ?></span>
                                                                <span class="info ps-2 shipping-contact-person"><?php echo e($address['contact_person_name']); ?></span>
                                                            </li>
                                                            <li>
                                                                <span class="form--label w-70px"><?php echo e(translate('phone')); ?></span>
                                                                <span class="info ps-2 shipping-contact-phone"><?php echo e($address['phone']); ?></span>
                                                            </li>
                                                            <li>
                                                                <span class="form--label w-70px"><?php echo e(translate('address')); ?></span>
                                                                <span class="info ps-2 shipping-contact-address"><?php echo e($address['address']); ?></span>
                                                            </li>
                                                            <span class="shipping-contact-address d-none"><?php echo e($address['address']); ?></span>
                                                            <span class="shipping-contact-city d-none"><?php echo e($address['city']); ?></span>
                                                            <span class="shipping-contact-zip d-none"><?php echo e($address['zip']); ?></span>
                                                            <span class="shipping-contact-country d-none"><?php echo e($address['country']); ?></span>
                                                            <span class="shipping-contact-address_type d-none"><?php echo e($address['address_type']); ?></span>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="text-center">
                                <img loading="lazy" src="<?php echo e(theme_asset('assets/img/icons/address.svg')); ?>" alt="<?php echo e(translate('address')); ?>" class="w-25">
                                <h5 class="my-3 pt-1 text-muted">
                                    <?php echo e(translate('no_address_is_saved')); ?>!
                                </h5>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer p-3">
                <button type="button" class="btn rounded btn-reset text-title"
                    data-bs-dismiss="modal"><?php echo e(translate('close')); ?></button>
                <button type="button" data-bs-dismiss="modal" class="btn rounded btn-base"><?php echo e(translate('select')); ?></button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="billing_addresses">
    <div class="modal-dialog modal-dialog-centered ">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-capitalize"><?php echo e(translate('saved_addresses')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mapouter">
                    <div class="row ">
                        <?php if(auth('customer')->check() && $billing_addresses->count()>0): ?>
                         <?php $__currentLoopData = $billing_addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-12">
                                <div class="address-card mb-20px ">
                                    <div class="address-card-header bg-transparent d-flex justify-content-between align-items-center">
                                        <label class="d-flex align-items-start gap-3 cursor-pointer mb-0 w-100">
                                            <input class="s-16px form-check-input mt-1" type="radio" name="billing_method_id" <?php echo e($key==0?'checked':''); ?> value="<?php echo e($address['id']); ?>" >
                                            <div class="__border-base"></div>
                                            <div class="w-0 flex-grow-1">
                                                <div class="d-flex justify-content-between align-items-center column-gap-4">
                                                    <h6 class="text-capitalize"><?php echo e($address['address_type']); ?></h6>
                                                    <a href="<?php echo e(route('address-edit',$address->id)); ?>" >
                                                        <img loading="lazy" src="<?php echo e(theme_asset('assets/img/icons/edit.png')); ?>" alt="<?php echo e(translate('edit')); ?>">
                                                    </a>
                                                </div>
                                                <div class="address-card-body pb-0 px-0 text-start">
                                                    <ul>
                                                        <li>
                                                            <span class="form--label w-70px"><?php echo e(translate('name')); ?></span>
                                                            <span class="info ps-2 billing-contact-name"><?php echo e($address['contact_person_name']); ?></span>
                                                        </li>
                                                        <li>
                                                            <span class="form--label w-70px"><?php echo e(translate('phone')); ?></span>
                                                            <span class="info ps-2 billing-contact-phone"><?php echo e($address['phone']); ?></span>
                                                        </li>
                                                        <li>
                                                            <span class="form--label w-70px"><?php echo e(translate('address')); ?></span>
                                                            <span class="info ps-2 billing-contact-address"><?php echo e($address['address']); ?></span>
                                                        </li>
                                                        <span class="billing-contact-city d-none"><?php echo e($address['city']); ?></span>
                                                        <span class="billing-contact-zip d-none"><?php echo e($address['zip']); ?></span>
                                                        <span class="billing-contact-country d-none"><?php echo e($address['country']); ?></span>
                                                        <span class="billing-contact-address_type d-none"><?php echo e($address['address_type']); ?></span>
                                                    </ul>
                                                </div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="text-center">
                                <img loading="lazy" src="<?php echo e(theme_asset('assets/img/icons/address.svg')); ?>" alt="<?php echo e(translate('address')); ?>" class="w-25">
                                <h5 class="my-3 pt-1 text-muted">
                                        <?php echo e(translate('no_address_is_saved')); ?>!
                                </h5>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer p-3">
                <button type="button" class="btn rounded btn-reset text-title"
                    data-bs-dismiss="modal"><?php echo e(translate('close')); ?></button>
                <button type="button" data-bs-dismiss="modal" class="btn rounded btn-base"><?php echo e(translate('select')); ?></button>
            </div>
        </div>
    </div>
</div>


<span id="shippingaddress-storage"
    data-latitude="<?php echo e($default_location ? $default_location['lat'] : ''); ?>"
    data-longitude="<?php echo e($default_location ? $default_location['lng'] : ''); ?>">
</span>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(getWebConfig(name: 'map_api_key')); ?>&callback=mapsShopping&libraries=places&v=3.49" defer></script>
    <script src="<?php echo e(theme_asset('assets/js/shipping-page.js')); ?>"></script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('theme-views.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/youngerlifestyle/public_html/resources/themes/theme_fashion/theme-views/checkout/shipping.blade.php ENDPATH**/ ?>