<?php
    use App\Models\Product;
    use App\Utils\CartManager;
    use App\Utils\Helpers;
    use App\Utils\ProductManager;
?>
<div class="dropdown">
    <a href="<?php echo e(route('shop-cart')); ?>" class="position-relative" data-bs-toggle="dropdown" data-bs-auto-close="outside"
       aria-expanded="false">
        <?php ($cart=CartManager::get_cart()); ?>
        <i class="bi bi-bag fs-18"></i>
        <span class="count"><?php echo e($cart->count()); ?></span>
    </a>
    <ul class="dropdown-menu dropdown-menu-end scrollY-60 bs-dropdown-min-width--22-5rem">
        <?php if($cart->count() > 0): ?>
            <?php ($sub_total=0); ?>
            <?php ($total_tax=0); ?>
            <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php ($product=Product::find($cartItem['product_id'])); ?>
                <li>
                    <div class="media gap-3">
                        <div class="avatar avatar-xxl position-relative overflow-hidden rounded">
                            <img loading="lazy" alt="Product"
                                src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.$cartItem['thumbnail'], type: 'product')); ?>"
                                class="img-fit dark-support rounded img-fluid overflow-hidden <?php echo e($product && $product->status == 0?'blur-section':''); ?>">
                            <?php if($product && $product->status == 0): ?>
                                <span class="temporary-closed position-absolute text-center p-2">
                                    <span class="text-capitalize"><?php echo e(translate('not_available')); ?></span>
                                </span>
                            <?php endif; ?>
                        </div>
                        <div class="media-body">
                            <h6 class="mb-2 <?php echo e($product && $product->status == 0 ? 'blur-section':''); ?>">
                                <a href="<?php echo e($product && $product->status == 1 ? route('product',$cartItem['slug']) : 'javascript:'); ?>"><?php echo e(Str::limit($cartItem['name'],30)); ?></a>
                            </h6>
                            <div class="d-flex gap-3 justify-content-between align-items-end">
                                <div class="d-flex flex-column gap-1 <?php echo e($product && $product->status == 0?'blur-section':''); ?>">
                                    <div class="fs-12"><span
                                            class="cart_quantity_<?php echo e($cartItem['id']); ?>"><?php echo e($cartItem['quantity']); ?></span>
                                        <?php echo e('×'.Helpers::currency_converter(($cartItem['price']-$cartItem['discount']))); ?>

                                    </div>
                                    <div class="product__price d-flex flex-wrap gap-2">
                                        <?php if($cartItem['discount'] >0): ?>
                                            <del class="product__old-price quantity_price_of_<?php echo e($cartItem['id']); ?>"><?php echo e(Helpers::currency_converter($cartItem['price']*$cartItem['quantity'])); ?></del>
                                        <?php endif; ?>
                                        <ins class="product__new-price discount_price_of_<?php echo e($cartItem['id']); ?>"><?php echo e(Helpers::currency_converter(($cartItem['price']-$cartItem['discount'])*(int)$cartItem['quantity'])); ?></ins>
                                    </div>
                                </div>
                                <div class="quantity">
                                    <?php if($product && $product->status == 1): ?>
                                        <span
                                            class="quantity__minus cart-quantity-update cart_quantity__minus<?php echo e($cartItem['id']); ?>"
                                            data-cart-id="<?php echo e($cartItem['id']); ?>"
                                            data-product-id="<?php echo e($cartItem['product_id']); ?>"
                                            data-value=-1
                                            data-event="minus"
                                            data-prevent="true">
                                            <i class="<?php echo e($cartItem['quantity'] == ($product ? $product->minimum_order_qty : 1) ? 'bi bi-trash3-fill text-danger fs-10' : 'bi bi-dash'); ?>"></i>
                                        </span>
                                        <input type="text"
                                               class="quantity__qty cart-quantity-update-input cart_quantity_of_<?php echo e($cartItem['id']); ?>"
                                               data-min="<?php echo e($product?->minimum_order_qty ?? 1); ?>"
                                               value="<?php echo e($cartItem['quantity']); ?>"
                                               data-cart-id="<?php echo e($cartItem['id']); ?>"
                                               data-product-id="<?php echo e($cartItem['product_id']); ?>"
                                               data-value=0
                                               data-prevent="true">
                                        <span class="quantity__plus cart-quantity-update"
                                              data-cart-id="<?php echo e($cartItem['id']); ?>"
                                              data-product-id="<?php echo e($cartItem['product_id']); ?>"
                                              data-value=1
                                              data-event="plus"
                                              data-prevent="true">
                                            <i class="bi bi-plus"></i>
                                        </span>
                                    <?php else: ?>
                                        <span
                                            class="quantity__minus cart-quantity-update cart_quantity__minus<?php echo e($cartItem['id']); ?>"
                                            data-cart-id="<?php echo e($cartItem['id']); ?>"
                                            data-product-id="<?php echo e($cartItem['product_id']); ?>"
                                            data-value="-<?php echo e($cartItem['quantity']); ?>"
                                            data-event="minus" data-prevent="true">
                                            <i class="bi bi-trash3-fill text-danger fs-10"></i>
                                        </span>
                                        <input type="text"
                                               class="quantity__qty cart-quantity-update-input cart_quantity_of_<?php echo e($cartItem['id']); ?>"
                                               data-min="<?php echo e($product?->minimum_order_qty ?? 1); ?>" value="0"
                                               data-cart-id="<?php echo e($cartItem['id']); ?>"
                                               data-product-id="<?php echo e($cartItem['product_id']); ?>"
                                               data-value=0
                                               data-prevent="true">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </li>
                <?php ($sub_total+=($cartItem['price']-$cartItem['discount'])*(int)$cartItem['quantity']); ?>
                <?php ($total_tax+=$cartItem['tax']*(int)$cartItem['quantity']); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <li>
                <div class="flex-between-gap-3 pt-2 pb-4">
                    <h6><?php echo e(translate('total')); ?></h6>
                    <h3 class="text-primary cart_total_amount"><?php echo e(Helpers::currency_converter($sub_total)); ?></h3>
                </div>
                <div class="d-flex gap-3">
                    <?php if($web_config['guest_checkout_status'] || auth('customer')->check()): ?>
                        <a href="<?php echo e(route('shop-cart')); ?>"
                           class="btn btn-outline-primary btn-block"><?php echo e(translate('view_cart')); ?></a>
                        <a href="<?php echo e(route('checkout-details')); ?>"
                           class="btn btn-primary btn-block"><?php echo e(translate('go_to_checkout')); ?></a>
                    <?php else: ?>
                        <button class="btn btn-outline-primary btn-block" data-bs-toggle="modal"
                                data-bs-target="#loginModal"><?php echo e(translate('view_cart')); ?></button>
                        <button class="btn btn-primary btn-block" data-bs-toggle="modal"
                                data-bs-target="#loginModal"><?php echo e(translate('go_to_checkout')); ?></button>
                    <?php endif; ?>
                </div>
            </li>
        <?php else: ?>
            <div class="widget-cart-item">
                <h6 class="text-danger text-center m-0 p-2"><i
                        class="fa fa-cart-arrow-down text-capitalize"></i> <?php echo e(translate('empty_cart')); ?>

                </h6>
            </div>
        <?php endif; ?>
    </ul>
</div>
<?php /**PATH /home/youngerlifestyle/public_html/resources/themes/theme_aster/theme-views/layouts/partials/_cart.blade.php ENDPATH**/ ?>