<?php if($deal_of_the_day): ?>
    <section class="deal-of-the-day section-gap pb-0">
        <div class="container">
            <div class="deal-of-the-day-wrapper">
                <img loading="lazy" src="<?php echo e(asset('/resources/themes/theme_fashion/public/assets/img/deal/dd-1.png')); ?>"
                     alt="<?php echo e(translate('deal_of_the_day')); ?>" class="d-shape-1">
                <img loading="lazy" src="<?php echo e(asset('/resources/themes/theme_fashion/public/assets/img/deal/dd-2.png')); ?>"
                     alt="<?php echo e(translate('deal_of_the_day')); ?>" class="d-shape-2">
                <img loading="lazy" src="<?php echo e(asset('/resources/themes/theme_fashion/public/assets/img/deal/dd-3.png')); ?>"
                     alt="<?php echo e(translate('deal_of_the_day')); ?>" class="d-shape-3">
                <div class="deal-left">
                    <h6 class="subtitle text-capitalize"><?php echo e(translate("don't_miss_todays_deal")); ?>!</h6>
                    <h3 class="title"><?php echo e(translate('Today’s_Best_Deal')); ?></h3>
                    <?php if(isset($deal_of_the_day->product) && $deal_of_the_day->product->discount > 0): ?>
                        <span class="deal-badge bg-base secondary-color">
                            <?php if($deal_of_the_day->product->discount_type == 'percent'): ?>
                                <?php echo e(round($deal_of_the_day->product->discount, $web_config['decimal_point_settings'])); ?>%
                            <?php elseif($deal_of_the_day->product->discount_type =='flat'): ?>
                                <?php echo e(\App\Utils\Helpers::currency_converter($deal_of_the_day->product->discount)); ?>

                            <?php endif; ?>
                            <?php echo e(('off')); ?>

                        </span>
                    <?php elseif(isset($random_product->discount_type) && $random_product->discount > 0): ?>
                        <span class="deal-badge bg-base secondary-color">
                            <?php if($random_product->discount_type == 'percent'): ?>
                                <?php echo e(round($random_product->discount, $web_config['decimal_point_settings'])); ?>%
                            <?php elseif($random_product->discount_type =='flat'): ?>
                                <?php echo e(\App\Utils\Helpers::currency_converter($random_product->discount)); ?>

                            <?php endif; ?>
                            <?php echo e(('off')); ?>

                        </span>
                    <?php endif; ?>
                </div>

                <?php if(isset($deal_of_the_day->product) && $deal_of_the_day->product->discount > 0): ?>
                    <div class="deal-right">
                        <div class="deal-img">
                            <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                 src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.($deal_of_the_day->product['thumbnail']), type: 'product')); ?>">
                        </div>
                        <div class="deal-content">
                            <div class="product-single-content">
                                <div class="d-flex flex-wrap align-items-center column-gap-4 mb-3">
                                    <div class=" review position-relative">
                                        <div class="stars">
                                            <?php ($overall_rating = getOverallRating($deal_of_the_day->product->reviews)); ?>
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= $overall_rating[0]): ?>
                                                    <i class="bi bi-star-fill"></i>
                                                <?php elseif($overall_rating[0] != 0 && $i <= $overall_rating[0] + 1.1): ?>
                                                    <i class="bi bi-star-half"></i>
                                                <?php else: ?>
                                                    <i class="bi bi-star"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                    </div>
                                    <span
                                            class="badge badge-soft-<?php echo e($deal_of_the_day->product->current_stock>0 ? 'success':'danger'); ?>">
                                        <?php echo e(translate($deal_of_the_day->product->current_stock>0 ? 'stock_available':'out_of_stock')); ?>


                                    </span>
                                </div>
                                <h3 class="title"><?php echo e(\Illuminate\Support\Str::limit($deal_of_the_day->product->name,60)); ?></h3>
                                <div class="categories">
                                    <span class="text-base"><i class="bi bi-shop"></i></span> <span class="text-base">
                                        <?php if($deal_of_the_day->product->added_by == 'admin'): ?>
                                            <?php echo e($web_config['name']->value); ?>

                                        <?php else: ?>
                                            <?php echo e(isset($deal_of_the_day->product->seller->shop) ? $deal_of_the_day->product->seller->shop->name : ''); ?>

                                        <?php endif; ?>

                                    </span>
                                </div>
                                <br>
                                <div class="price">
                                    <h4>
                                        <?php echo getPriceRangeWithDiscount(product: $deal_of_the_day->product); ?>


                                        <?php if($deal_of_the_day->product->discount > 0): ?>
                                            <span class="badge bg-base secondary-color">
                                                <?php if($deal_of_the_day->product->discount_type === "percent"): ?>
                                                    -<?php echo e($deal_of_the_day->product->discount); ?>%
                                                <?php else: ?>
                                                    <?php echo e(translate('save')); ?> <?php echo e(webCurrencyConverter(amount: $deal_of_the_day->product->discount)); ?>

                                                <?php endif; ?>
                                            </span>
                                        <?php endif; ?>

                                    </h4>

                                </div>
                                <div class="btn-grp">
                                    <a href="<?php echo e(route('product',$deal_of_the_day->product->slug)); ?>"
                                       class="btn btn-base text-capitalize hover">
                                        <?php echo e(translate('shop_now')); ?><i class="bi bi-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php elseif(isset($random_product->discount_type)): ?>
                    <div class="deal-right">
                        <div class="deal-img">
                            <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                 src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.$random_product['thumbnail'], type: 'product')); ?>">
                        </div>
                        <div class="deal-content">
                            <div class="product-single-content">
                                <div class="d-flex flex-wrap align-items-center column-gap-4 mb-3">
                                    <div class=" review position-relative">
                                        <div class="stars">
                                            <?php ($overall_rating = getOverallRating($random_product->reviews)); ?>
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= $overall_rating[0]): ?>
                                                    <i class="bi bi-star-fill"></i>
                                                <?php elseif($overall_rating[0] != 0 && $i <= $overall_rating[0] + 1.1): ?>
                                                    <i class="bi bi-star-half"></i>
                                                <?php else: ?>
                                                    <i class="bi bi-star"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                    </div>
                                    <span
                                            class="badge badge-soft-<?php echo e($random_product->current_stock>0 ? 'success':'danger'); ?>">
                                        <?php echo e(translate($random_product->current_stock>0 ? 'stock_available':'out_of_stock')); ?>


                                    </span>
                                </div>
                                <h3 class="title"><?php echo e(\Illuminate\Support\Str::limit($random_product->name,60)); ?></h3>
                                <div class="categories">
                                    <span class="text-base"><i class="bi bi-shop"></i></span> <span class="text-base">
                                        <?php if($random_product->added_by == 'admin'): ?>
                                            <?php echo e($web_config['name']->value); ?>

                                        <?php else: ?>
                                            <?php echo e(isset($random_product->seller->shop) ? $random_product->seller->shop->name : ''); ?>

                                        <?php endif; ?>

                                    </span>
                                </div>
                                <br>
                                <div class="price">
                                    <h4>
                                        <?php echo getPriceRangeWithDiscount(product: $random_product); ?>

                                        <?php if($random_product->discount > 0): ?>
                                            <span class="badge bg-base secondary-color">
                                                <?php if($random_product->discount_type === "percent"): ?>
                                                    -<?php echo e($random_product->discount); ?>%
                                                <?php else: ?>
                                                    <?php echo e(translate('save')); ?> <?php echo e(webCurrencyConverter(amount: $random_product->discount)); ?>

                                                <?php endif; ?>
                                            </span>
                                        <?php endif; ?>
                                    </h4>
                                </div>
                                <div class="btn-grp">
                                    <a href="<?php echo e(route('product',$random_product->slug)); ?>"
                                       class="btn btn-base text-capitalize hover"><?php echo e(translate('shop_now')); ?><i
                                                class="bi bi-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/elitede1/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/partials/_deal-of-the-day.blade.php ENDPATH**/ ?>