<ul class="list-unstyled d-flex justify-content-around gap-3 mb-0 position-relative">
    <li>
        <a href="<?php echo e(route('home')); ?>"
           class="d-flex align-items-center <?php echo e((Request::is('/') || Request::is('home')) ? 'active':''); ?> flex-column gap-1 py-3">
            <i class="bi bi-house-door fs-18"></i>
            <span><?php echo e(translate('home')); ?></span>
        </a>
    </li>
    <?php if(auth('customer')->check()): ?>
        <li>
            <a href="<?php echo e(route('wishlists')); ?>"
               class="d-flex align-items-center <?php echo e(Request::is('wishlists') ? 'active' : ''); ?> flex-column gap-1 py-3">
                <div class="position-relative">
                    <i class="bi bi-heart fs-18"></i>
                    <span class="app-count">
                        <span class="wishlist_count_status">
                            <?php echo e(session()->has('wish_list') ? count(session('wish_list')) : 0); ?>

                        </span>
                    </span>
                </div>
                <span><?php echo e(translate('wishlist')); ?></span>
            </a>
        </li>
    <?php else: ?>
        <li>
            <a href="javascript:"
               class="d-flex align-items-center flex-column gap-1 py-3 customer_login_register_modal">
                <div class="position-relative">
                    <i class="bi bi-heart fs-18"></i>
                    <span class="app-count"><?php echo e('0'); ?></span>
                </div>
                <span><?php echo e(translate('wishlist')); ?></span>
            </a>
        </li>
    <?php endif; ?>

    <li>
        <?php ($cart=\App\Utils\CartManager::get_cart()); ?>
        <?php if($cart->count() > 0): ?>
            <?php ($sub_total=0); ?>
            <?php ($total_tax=0); ?>
            <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php ($sub_total+=($cartItem['price']-$cartItem['discount'])*(int)$cartItem['quantity']); ?>
                <?php ($total_tax+=$cartItem['tax']*(int)$cartItem['quantity']); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <div class="dropup position-static d-xl-none">
            <a href="javascript:" class="d-flex align-items-center flex-column gap-1 py-3" data-toggle="collapse"
               data-target="cart_dropdown">
                <div class="position-relative">
                    <i class="bi bi-bag fs-18"></i>
                    <span class="btn-status app-count"><?php echo e($cart->count()); ?></span>
                </div>
                <span><?php echo e(translate('cart')); ?></span>
            </a>

            <ul class="dropdown-menu scrollY-60 p-3 min-vw-100" id="cart_dropdown">
                <?php if($cart->count() > 0): ?>
                    <?php echo $__env->make('theme-views.layouts.partials._cart-data',['cart'=>$cart], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <li>
                        <div class="app-cart-subtotal">
                            <span class="text-base"><?php echo e(translate('subtotal')); ?></span>
                            <span class="cart_total_amount"><?php echo e(\App\Utils\Helpers::currency_converter($sub_total)); ?></span>
                        </div>

                        <div class="d-flex gap-3 mt-3">
                            <?php if($web_config['guest_checkout_status'] || auth('customer')->check()): ?>
                                <a href="<?php echo e(route('shop-cart')); ?>"
                                   class="btn btn-outline-base flex-grow-1"><?php echo e(translate('view_all_cart_items')); ?></a>
                                <a href="<?php echo e(route('checkout-details')); ?>"
                                   class="btn btn-base flex-grow-1"><?php echo e(translate('go_to_checkout')); ?></a>
                            <?php else: ?>
                                <a href="javascript:"
                                   class="btn btn-outline-base flex-grow-1 customer_login_register_modal"><?php echo e(translate('view_all_cart_items')); ?></a>
                                <a href="javascript:"
                                   class="btn btn-base flex-grow-1 customer_login_register_modal"><?php echo e(translate('go_to_checkout')); ?></a>
                            <?php endif; ?>
                        </div>
                    </li>
                <?php else: ?>
                    <div class="widget-cart-item">
                        <h6 class="text-danger text-center m-0 p-2">
                            <i class="fa fa-cart-arrow-down"></i> <?php echo e(translate('empty_Cart')); ?>

                        </h6>
                    </div>
                <?php endif; ?>
            </ul>
        </div>
    </li>

    <?php if(auth('customer')->check()): ?>
        <li>
            <a href="<?php echo e(route('product-compare.index')); ?>"
               class="d-flex align-items-center <?php echo e(Request::is('compare-list') ? 'active' : ''); ?> flex-column gap-1 py-3">
                <div class="position-relative">
                    <i class="bi bi-repeat fs-18"></i>
                    <span class="app-count compare_list_count_status top-0">
                        <?php echo e(session()->has('compare_list') ? count(session('compare_list')) : 0); ?>

                    </span>
                </div>
                <span><?php echo e(translate('compare')); ?></span>
            </a>
        </li>
    <?php else: ?>
        <li>
            <a href="javascript:"
               class="d-flex align-items-center text-dark flex-column gap-1 py-3 customer_login_register_modal">
                <div class="position-relative">
                    <i class="bi bi-repeat fs-18"></i>
                </div>
                <span><?php echo e(translate('compare')); ?></span>
            </a>
        </li>
    <?php endif; ?>
</ul>
<?php /**PATH /home/elitedesignbd/ecommerce10.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/layouts/partials/_app-bar.blade.php ENDPATH**/ ?>