<section class="recommended-product-section section-gap">
    <div class="container">
        <div class="section-title mb-4 pb-lg-1 text-capitalize">
            <div class="d-flex flex-wrap justify-content-between row-gap-2 column-gap-4 align-items-center single_section_dual_tabs">
                <h2 class="title mb-0"><?php echo e(translate('recommended_for_you')); ?></h2>
                <ul class="nav nav-tabs nav--tabs single_section_dual_btn order-1 ms-auto ">
                    <li data-targetbtn="0">
                        <a href="#latest" class="active" data-bs-toggle="tab"><?php echo e(translate('latest_product')); ?></a>
                    </li>
                    <li data-targetbtn="1">
                        <a href="#most-searching" data-bs-toggle="tab"><?php echo e(translate('most_searching')); ?></a>
                    </li>
                </ul>
                <div class="d-flex align-items-center column-gap-4 justify-content-end ms-auto ms-md-0 order-0 order-sm-2">
                    <div class="d-flex align-items-center column-gap-2 column-gap-sm-4">
                        <div class="owl-prev recommended-prev">
                            <i class="bi bi-chevron-left"></i>
                        </div>
                        <div class="owl-next recommended-next">
                            <i class="bi bi-chevron-right"></i>
                        </div>
                    </div>
                    <div class="single_section_dual_target">
                        <a href="<?php echo e(route('products',['data_from'=>'latest','page'=>1])); ?>" class="see-all"><?php echo e(translate('see_all')); ?></a>
                        <a href="<?php echo e(route('products',['data_from'=>'best-selling','page'=>1])); ?>" class="see-all d-none"><?php echo e(translate('see_all')); ?></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="overflow-hidden">
            <div class="tab-content">
                <div class="tab-pane fade show active" id="latest">
                    <div class="recommended-slider-wrapper">
                        <div class="recommended-slider owl-theme owl-carousel">
                            <?php $__currentLoopData = $latest_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($product): ?>
                                    <?php echo $__env->make('theme-views.partials._product-medium-card',['product'=>$product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="most-searching">
                    <div class="recommended-slider-wrapper">
                        <div class="recommended-slider owl-theme owl-carousel">
                            <?php $__currentLoopData = $most_searching_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($product): ?>
                                    <?php echo $__env->make('theme-views.partials._product-medium-card',['product'=>$product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php /**PATH /home/elitede1/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/partials/_recommended-product.blade.php ENDPATH**/ ?>