<?php $__env->startSection('title', translate('my_profile').' | '.$web_config['name']->value.' '.translate('ecommerce')); ?>

<?php $__env->startSection('content'); ?>
<section class="user-profile-section section-gap pt-0">
    <div class="container">

        <?php echo $__env->make('theme-views.partials._profile-aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="tab-content">

            <div class="tab-pane fade show active" >
                <div class="personal-details mb-4">
                    <div class="d-flex flex-wrap justify-content-between align-items-center column-gap-4 row-gap-2 mb-4">
                        <h4 class="subtitle m-0 text-capitalize"><?php echo e(translate('personal_details')); ?></h4>
                        <a href="<?php echo e(route('user-account')); ?>" class="cmn-btn __btn-outline rounded-full text-capitalize" >
                            <?php echo e(translate('edit_profile')); ?>

                            <?php echo $__env->make('theme-views.partials.icons._profile-edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </a>
                    </div>
                    <ul class="personal-details-info">
                        <li>
                            <span class="name"><?php echo e(translate('name')); ?></span> <span class="clone">:</span> <strong><?php echo e($customer_detail['f_name']); ?> <?php echo e($customer_detail['l_name']); ?></strong>
                        </li>
                        <li class="d-md-block d-none"></li>
                        <li>
                            <span class="name"><?php echo e(translate('phone')); ?></span> <span class="clone">:</span> <strong><?php echo e($customer_detail['phone']); ?></strong>
                        </li>
                        <li class="d-md-block d-none"></li>
                        <li>
                            <span class="name"><?php echo e(translate('email')); ?></span> <span class="clone">:</span>
                            <strong><?php echo e($customer_detail['email']); ?></strong>
                        </li>
                    </ul>
                </div>
                <div class="address-details px-md-4">
                    <h4 class="subtitle mb-3 mx-2 text-capitalize"><?php echo e(translate('my_address')); ?></h4>
                    <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="address-card mb-20px">
                            <div class="address-card-header d-flex justify-content-between align-items-center">
                                <h6 class="text-capitalize"><?php echo e(translate($address['address_type'])); ?>&nbsp(<?php echo e($address['is_billing']==1 ? translate('billing_address'):translate('shipping_address')); ?>)</h6>
                                <div class="d-flex align-items-center column-gap-4">
                                    <a href="<?php echo e(route('address-edit',$address->id)); ?>" >
                                        <img loading="lazy" src="<?php echo e(theme_asset('assets/img/icons/edit.png')); ?>" alt="<?php echo e(translate('address')); ?>">
                                    </a>
                                    <a href="javascript:" class="route_alert_function"
                                     data-routename="<?php echo e(route('address-delete',['id'=>$address->id])); ?>"
                                     data-message="<?php echo e(translate('want_to_delete_this_address?')); ?>"
                                     data-typename=""
                                     >
                                        <img loading="lazy" src="<?php echo e(theme_asset('assets/img/icons/trash.png')); ?>" alt="<?php echo e(translate('trash')); ?>">
                                    </a>
                                </div>
                            </div>
                            <div class="address-card-body">
                                <div class="row">
                                    <ul class="col-sm-6">
                                        <li>
                                            <span class="name"><?php echo e(translate('name')); ?></span>
                                            <span class="info"><?php echo e($address['contact_person_name']); ?></span>
                                        </li>
                                        <li>
                                            <span class="name"><?php echo e(translate('phone')); ?></span>
                                            <span class="info"><?php echo e($address['phone']); ?></span>
                                        </li>
                                        <li>
                                            <span class="name"><?php echo e(translate('address')); ?></span>
                                            <span class="info"><?php echo e($address['address']); ?></span>
                                        </li>
                                    </ul>
                                    <ul class="col-sm-6">
                                        <li>
                                            <span class="name text-capitalize"><?php echo e(translate('zip_code')); ?></span>
                                            <span class="info"><?php echo e($address['zip']); ?></span>
                                        </li>
                                        <li>
                                            <span class="name"><?php echo e(translate('city')); ?></span>
                                            <span class="info"><?php echo e($address['city']); ?></span>
                                        </li>
                                        <li>
                                            <span class="name"><?php echo e(translate('country')); ?></span>
                                            <span class="info"><?php echo e($address['country']); ?></span>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="personal-details add-address-btn-container text-center text-md-start">
                        <a class="text-base add-address-btn text-capitalize" href="<?php echo e(route('account-address-add')); ?>">+<?php echo e(translate('add_address')); ?></a>
                    </div>

                    <?php if($addresses->count() <= 0): ?>
                    <div class="text-center pt-5 w-100">
                        <div class="text-center mb-5">
                            <img loading="lazy" src="<?php echo e(theme_asset('assets/img/icons/address.svg')); ?>" alt="<?php echo e(translate('address')); ?>">
                            <h5 class="my-3 pt-4 text-muted"><?php echo e(translate('no_Saved_Address_Found')); ?>!</h5>
                            <p class="text-center text-muted"><?php echo e(translate('please_add_your_address_for_your_better_experience')); ?></p>
                        </div>
                    </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme-views.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitede1/ecommerce11.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/users-profile/user-profile.blade.php ENDPATH**/ ?>