<div class="modal-body">
    <div class="modal-header py-0 border-0 z-999">
        <button type="button" class="btn-close position-right-top z-999" data-bs-dismiss="modal"
                aria-label="Close"></button>
    </div>
    <div class="product-single-wrapper">
        <?php if($product->images!=null && json_decode($product->images)>0): ?>
            <div class="product-single-thumb">
                <?php if(json_decode($product->colors) && $product->color_image): ?>
                    <div class="overflow-hidden rounded">
                        <div class="product-share-icons">
                            <a href="javascript:" class="share-icon" title="<?php echo e(translate('share')); ?>">
                                <i class="bi bi-share-fill"></i>
                            </a>
                            <ul>
                                <li>
                                    <a href="javascript:" class="social_share_function"
                                       data-url="<?php echo e(route('product',$product->slug)); ?>"
                                       data-social="facebook.com/sharer/sharer.php?u="
                                    >
                                        <i class="bi bi-facebook"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:" class="social_share_function"
                                       data-url="<?php echo e(route('product',$product->slug)); ?>"
                                       data-social="twitter.com/intent/tweet?text=">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                             fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                                            <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865l8.875 11.633Z"/>
                                        </svg>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:" class="social_share_function"
                                       data-url="<?php echo e(route('product',$product->slug)); ?>"
                                       data-social="linkedin.com/shareArticle?mini=true&url="
                                    >
                                        <i class="bi bi-linkedin"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:" class="social_share_function"
                                       data-url="<?php echo e(route('product',$product->slug)); ?>"
                                       data-social="api.whatsapp.com/send?text="
                                    >
                                        <i class="bi bi-whatsapp"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div id="sync1" class="owl-carousel owl-theme product-single-main-slider">
                            <?php $__currentLoopData = json_decode($product->color_image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($photo->color != null): ?>
                                    <div class="main-thumb">
                                        <div class="easyzoom easyzoom--overlay">
                                            <a href="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type: 'product')); ?>">
                                                <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                     src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type: 'product')); ?>">
                                            </a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php $__currentLoopData = json_decode($product->color_image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($photo->color == null): ?>
                                    <div class="main-thumb">
                                        <div class="easyzoom easyzoom--overlay">
                                            <a href="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type: 'product')); ?>">
                                                <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                     src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type: 'product')); ?>">
                                            </a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="overflow-hidden rounded">
                        <div class="product-share-icons">
                            <a href="javascript:" class="share-icon" title="<?php echo e(translate('share')); ?>">
                                <i class="bi bi-share-fill"></i>
                            </a>
                            <ul>
                                <li>
                                    <a href="javascript:" class="social_share_function"
                                       data-url="<?php echo e(route('product',$product->slug)); ?>"
                                       data-social="facebook.com/sharer/sharer.php?u=">
                                        <i class="bi bi-facebook"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:" class="social_share_function"
                                       data-url="<?php echo e(route('product',$product->slug)); ?>"
                                       data-social="twitter.com/intent/tweet?text=">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                             fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                                            <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865l8.875 11.633Z"/>
                                        </svg>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:" class="social_share_function"
                                       data-url="<?php echo e(route('product',$product->slug)); ?>"
                                       data-social="linkedin.com/shareArticle?mini=true&url=">
                                        <i class="bi bi-linkedin"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:" class="social_share_function"
                                       data-url="<?php echo e(route('product',$product->slug)); ?>"
                                       data-social="api.whatsapp.com/send?text=">
                                        <i class="bi bi-whatsapp"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div id="sync1" class="owl-carousel owl-theme product-single-main-slider">
                            <?php $__currentLoopData = json_decode($product->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="main-thumb">
                                    <div class="easyzoom easyzoom--overlay">
                                        <a href="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo, type:'product')); ?>">
                                            <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                 src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo, type:'product')); ?>">
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="overflow-hidden">
                    <?php if($product->images!=null && json_decode($product->images)>0): ?>
                        <div id="sync2" class="owl-carousel owl-theme product-single-thumbnails">
                            <?php if(json_decode($product->colors) && $product->color_image): ?>
                                <?php $__currentLoopData = json_decode($product->color_image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($photo->color != null): ?>
                                        <div class="thumb color_variants_preview-box-<?php echo e($photo->color); ?>">
                                            <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                 src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type:'product')); ?>">
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php $__currentLoopData = json_decode($product->color_image); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($photo->color == null): ?>
                                        <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                             src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo->image_name, type:'product')); ?>">
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <?php $__currentLoopData = json_decode($product->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="thumb color_variants_<?php echo e($key); ?>">
                                        <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                             src="<?php echo e(getValidImage(path: 'storage/app/public/product/'.$photo, type:'product')); ?>">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <div class="product-single-content">
            <form class="cart add_to_cart_form" action="<?php echo e(route('cart.add')); ?>" id="add-to-cart-form"
                  data-redirecturl="<?php echo e(route('checkout-details')); ?>"
                  data-varianturl="<?php echo e(route('cart.variant_price')); ?>"
                  data-errormessage="<?php echo e(translate('please_choose_all_the_options')); ?>"
                  data-outofstock="<?php echo e(translate('sorry').', '.translate('out_of_stock')); ?>.">
                <?php echo csrf_field(); ?>
                <h3 class="title"><?php echo e($product->name); ?></h3>
                <input type="hidden" name="id" value="<?php echo e($product->id); ?>">
                <div class="d-flex flex-wrap align-items-center column-gap-4 text-capitalize">
                    <?php if($product->reviews_count != null): ?>
                        <div class=" review position-relative">
                            <i class="bi bi-star-fill"></i>
                            <span><?php echo e(round($overallRating[0], 1)); ?> <small>(<?php echo e($product->reviews_count); ?> <?php echo e(translate('review')); ?>)</small></span>
                            <div class="review-details-popup z-3">
                                <div class="mb-4px"><?php echo e(translate('rating')); ?></div>
                                <div class="review-items d-flex flex-column row-gap-1">
                                    <div class="d-flex column-gap-2 align-items-center">
                                        <div class="stars">
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                        </div>
                                        <span class="progress">
                                            <div class="progress-fill"
                                                 style="--fill:<?php echo e(($rating[0] != 0?number_format($rating[0]*100 / array_sum($rating)):0)); ?>%"></div>
                                        </span>
                                        <span>(<?php echo e($rating[0]); ?>)</span>
                                    </div>
                                    <div class="d-flex column-gap-2 align-items-center">
                                        <div class="stars">
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                        </div>
                                        <span class="progress">
                                            <div class="progress-fill"
                                                 style="--fill:<?php echo e(($rating[1] != 0?number_format($rating[1]*100 / array_sum($rating)):0)); ?>%"></div>
                                        </span>
                                        <span>(<?php echo e($rating[1]); ?>)</span>
                                    </div>
                                    <div class="d-flex column-gap-2 align-items-center">
                                        <div class="stars">
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                        </div>
                                        <span class="progress">
                                            <div class="progress-fill"
                                                 style="--fill:<?php echo e(($rating[2] != 0?number_format($rating[2]*100 / array_sum($rating)):0)); ?>%"></div>
                                        </span>
                                        <span>(<?php echo e($rating[2]); ?>)</span>
                                    </div>
                                    <div class="d-flex column-gap-2 align-items-center">
                                        <div class="stars">
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                        </div>
                                        <span class="progress">
                                            <div class="progress-fill"
                                                 style="--fill:<?php echo e(($rating[3] != 0?number_format($rating[3]*100 / array_sum($rating)):0)); ?>%"></div>
                                        </span>
                                        <span>(<?php echo e($rating[3]); ?>)</span>
                                    </div>
                                    <div class="d-flex column-gap-2 align-items-center">
                                        <div class="stars">
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                            <i class="bi bi-star-fill"></i>
                                        </div>
                                        <span class="progress">
                                            <div class="progress-fill"
                                                 style="--fill:<?php echo e(($rating[4] != 0?number_format($rating[4]*100 / array_sum($rating)):0)); ?>%"></div>
                                        </span>
                                        <span>(<?php echo e($rating[4]); ?>)</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class=" review position-relative">
                            <i class="bi bi-star-fill"></i>
                            <span><?php echo e(round($overallRating[0], 1)); ?> <small>(<?php echo e(translate('no_review')); ?>)</small></span>
                        </div>
                    <?php endif; ?>

                    <?php if($product['product_type'] == 'physical' ): ?>
                        <span class="badge badge-soft-success stock_status">
                            <span class="in_stock_status"><?php echo e($product->current_stock); ?></span> <?php echo e(translate('stock_available')); ?>

                        </span>
                        <span class="badge badge-soft-danger d-none out_of_stock_status"><?php echo e(translate('out_of_stock')); ?></span>
                        <span class="badge badge-soft-secondary limited_status d-none">
                            <span class="in_stock_status"><?php echo e($product->current_stock); ?></span> <?php echo e(translate('limited_stock')); ?>

                        </span>
                    <?php endif; ?>

                </div>
                <div class="categories">
                    <span class="text-capitalize"><?php echo e(translate('category_tag')); ?> :</span>
                    <?php if($product->category_id): ?>
                        <a href="<?php echo e(route('products',['id'=> $product->category_id,'data_from'=>'category','page'=>1])); ?>"
                           class="text-base">
                            <?php echo e(ucwords(isset($product->category) ? $product->category->name:'')); ?>

                        </a>
                    <?php endif; ?>

                    <?php if($product->sub_category_id): ?>
                        <a href="<?php echo e(route('products',['id'=> $product->sub_category_id,'data_from'=>'category','page'=>1])); ?>"
                           class="text-base">
                            <?php echo e(ucwords(\App\Utils\CategoryManager::get_category_name($product->sub_category_id))); ?>

                        </a>
                    <?php endif; ?>

                    <?php if($product->sub_sub_category_id): ?>
                        <a href="<?php echo e(route('products',['id'=> $product->sub_sub_category_id,'data_from'=>'category','page'=>1])); ?>"
                           class="text-base">
                            <?php echo e(ucwords(\App\Utils\CategoryManager::get_category_name($product->sub_sub_category_id))); ?>

                        </a>
                    <?php endif; ?>
                </div>
                <hr>
                <div class="price">
                    <h4><?php echo \App\Utils\Helpers::get_price_range_with_discount($product); ?>

                        <?php if($product->discount > 0 && $product->discount_type === "percent"): ?>
                            <span class="badge bg-base">-<?php echo e($product->discount); ?>%</span>
                        <?php else: ?>
                            <?php if($product->discount > 0): ?>
                                <span class="badge bg-base"><?php echo e(translate('save')); ?> <?php echo e(\App\Utils\Helpers::currency_converter($product->discount)); ?></span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </h4>
                </div>

                <?php if(count(json_decode($product->colors)) > 0): ?>
                    <div>
                        <label class="form-label"><?php echo e(translate('color')); ?></label>
                        <div class="check-color-group justify-content-start">
                            <?php $__currentLoopData = json_decode($product->colors); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <label>
                                    <input type="radio" name="color"
                                           value="<?php echo e($color); ?>" <?php echo e($key == 0 ? 'checked' : ''); ?>>
                                    <span style="--base:<?php echo e($color); ?>" class="focus_preview_image_by_color"
                                          data-colorid="preview-box-<?php echo e(str_replace('#','',$color)); ?>"
                                          id="color_variants_preview-box-<?php echo e(str_replace('#','',$color)); ?>">
                                    <i class="bi bi-check"></i>
                                </span>
                                </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <span class="color_name"></span>
                        </div>
                    </div>
                <?php endif; ?>


                <?php $__currentLoopData = json_decode($product->choice_options); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mt-20px">
                        <label class="form-label"><?php echo e(translate($choice->title)); ?></label>
                        <div class="d-flex flex-wrap gap-2">
                            <?php $__currentLoopData = $choice->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <label class="form-check-size">
                                    <input type="radio" name="<?php echo e($choice->name); ?>" value="<?php echo e($option); ?>"
                                            <?php echo e($index == 0 ? 'checked' : ''); ?> >
                                    <span class="form-check-label"><?php echo e($option); ?></span>
                                </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="d-flex align-items-center row-gap-2 column-gap-4 mt-20px">
                    <span><?php echo e(translate('quantity')); ?> :</span>
                    <div class="inc-inputs">
                        <input type="number" name="quantity" value="<?php echo e($product->minimum_order_qty ?? 1); ?>"
                               class="form-control product_quantity__qty product_qty"
                               min="<?php echo e($product->minimum_order_qty ?? 1); ?>"
                               max="<?php echo e($product['product_type'] == 'physical' ? $product->current_stock : 100); ?>">
                    </div>
                </div>
                <div class="btn-grp">
                    <?php ($guest_checkout = getWebConfig(name: 'guest_checkout')); ?>

                    <?php if(($product->added_by == 'seller' && ($seller_temporary_close || (isset($product->seller->shop) && $product->seller->shop->vacation_status && $currentDate >= $seller_vacation_start_date && $currentDate <= $seller_vacation_end_date))) ||
                    ($product->added_by == 'admin' && ($inhouse_temporary_close || ($inHouseVacationStatus && $currentDate >= $inhouse_vacation_start_date && $currentDate <= $inhouse_vacation_end_date)))): ?>
                        <button type="button" class="update_cart_button btn btn-base fs-16 text-capitalize" disabled>
                            <?php echo $__env->make('theme-views.partials.icons._cart-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo e(translate('add_to_cart')); ?>

                        </button>
                        <button type="button"
                                class="buy_now_button btn btn-base __btn-outline-warning secondary-color fs-16 text-capitalize"
                                disabled>
                            <?php echo $__env->make('theme-views.partials.icons._buy-now', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php echo e(translate('buy_now')); ?>

                        </button>
                    <?php else: ?>
                        <a href="javascript:" class="btn btn-base text-capitalize addToCart_function_btn">
                            <?php echo $__env->make('theme-views.partials.icons._cart-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php echo e(translate('add_to_cart')); ?>

                        </a>
                        <a href="javascript:"
                           class="btn btn-base btn-sm __btn-outline-warning secondary-color text-capitalize buyNow_function_btn">
                            <?php echo $__env->make('theme-views.partials.icons._buy-now', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php echo e(translate('buy_now')); ?>

                        </a>
                    <?php endif; ?>

                    <a href="javascript:" class="btn btn-base btn-sm __btn-outline addWishlist_function_btn"
                    ><i class="wishlist_<?php echo e($product['id']); ?> bi <?php echo e(($wishlist_status == 1?'bi-heart-fill text-danger':'bi-heart')); ?>"></i>
                        <span class="product_wishlist_count_status"><?php echo e(\App\Utils\format_biginteger($countWishlist)); ?></span>
                    </a>

                    <?php ($compare_list = count($product->compareList)>0 ? 1 : 0); ?>
                    <a href="javascript:"
                       class="addCompareList_quick_view btn btn-base btn-sm __btn-outline compare_list-<?php echo e($product['id']); ?> <?php echo e(($compare_list == 1?'compare_list_icon_active':'')); ?>"
                       data-id="<?php echo e($product['id']); ?>" style="--base: <?php echo e($web_config['primary_color']); ?>">
                        <?php echo $__env->make('theme-views.partials.icons._compare', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </a>
                </div>

                <?php if(($product->added_by == 'seller' && ($seller_temporary_close || (isset($product->seller->shop) && $product->seller->shop->vacation_status && $currentDate >= $seller_vacation_start_date && $currentDate <= $seller_vacation_end_date))) ||
                ($product->added_by == 'admin' && ($inhouse_temporary_close || ($inHouseVacationStatus && $currentDate >= $inhouse_vacation_start_date && $currentDate <= $inhouse_vacation_end_date)))): ?>
                    <div class="alert alert-danger mt-3" role="alert">
                        <?php echo e(translate('this_shop_is_temporary_closed_or_on_vacation.')); ?>

                        <?php echo e(translate('you_cannot_add_product_to_cart_from_this_shop_for_now')); ?>

                    </div>
                <?php endif; ?>
            </form>
        </div>
    </div>
</div>
<script src="<?php echo e(theme_asset('assets/js/quick-view-data.js')); ?>"></script>
<script type="text/javascript">
    "use strict";
    $('.addWishlist_function_btn').on('click', function () {
        addWishlist_function('<?php echo e($product['id']); ?>');
    });

    $('.buyNow_function_btn').on('click', function () {
        buy_now('add-to-cart-form', <?php echo e(($guest_checkout==1 || Auth::guard('customer')->check()?'true':'false')); ?>, '<?php echo e(route('shop-cart')); ?>');
    });
</script>

<?php /**PATH /home/elitedesignbd/ecom10.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/layouts/partials/modal/_quick-view-data.blade.php ENDPATH**/ ?>