<?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php ($product=\App\Models\Product::active()->find($cartItem['product_id'])); ?>

    <li class="d-flex justify-content-between align-items-center gap-3 mb-3">
        <a href="<?php echo e(route('product',$cartItem['slug'])); ?>" class="media gap-2 w-0 flex-grow-1">
            <div class="position-relative overflow-hidden rounded">
                <?php if($product): ?>
                    <img loading="lazy" width="60" alt="<?php echo e(translate('product')); ?>"
                         src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.$cartItem['thumbnail'], type: 'product')); ?>">
                <?php else: ?>
                    <img loading="lazy" width="60" alt="<?php echo e(translate('product')); ?>"
                         src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.$cartItem['thumbnail'], type: 'product')); ?>">
                    <span class="temporary-closed position-absolute d-flex align-content-center justify-content-center">
                        <span><?php echo e(translate('N/a')); ?></span>
                    </span>
                <?php endif; ?>
            </div>

            <div class="info <?php echo e(!isset($product) ? 'blur-section':''); ?>">
                <h6 class="name text-text-2 thisIsALinkElement"
                    data-linkpath="<?php echo e(route('product',$cartItem['slug'])); ?>"><?php echo e(Str::limit($cartItem['name'],30)); ?></h6>
                <div class="text-secondary fs-12 lh-1.4"><span><?php echo e(translate('price')); ?> : <strong
                                class="discount_price_of_<?php echo e($cartItem['id']); ?>"><?php echo e(\App\Utils\Helpers::currency_converter(($cartItem['price']-$cartItem['discount'])*(int)$cartItem['quantity'])); ?></strong></span>
                    <div class="align-items-center column-gap-2">
                        <?php ($variations_index = 1); ?>
                        <?php $__currentLoopData = json_decode($cartItem['variations']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($variations_index <= 2): ?>
                                <span><?php echo e(ucfirst($key)); ?> : <?php echo e(ucfirst($item)); ?></span>
                                <?php ($variations_index += 1); ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </a>
        <?php if( isset($product->status) && $product->status == 1): ?>
            <div class="quantity quantity--style-two d-flex align-items-center">
                <div class="quantity__minus cart-qty-btn updateCartQuantity_cart_data"
                     data-cart="<?php echo e($cartItem['id']); ?>" data-product="<?php echo e($cartItem['product_id']); ?>" data-value="-1"
                     data-action="minus">
                    <i class="<?php echo e($cartItem['quantity'] == (isset($product->minimum_order_qty) ? $product->minimum_order_qty : 1) ? 'bi bi-trash3-fill text-danger fs-10' : 'bi bi-dash'); ?>"></i>
                </div>
                <input type="number"
                       class="quantity__qty cart-qty-input form-control cartQuantity<?php echo e($cartItem['id']); ?> updateCartQuantity_cart_data"
                       value="<?php echo e($cartItem['quantity']); ?>" name="quantity" id="cartQuantity<?php echo e($cartItem['id']); ?>"
                       data-cart="<?php echo e($cartItem['id']); ?>" data-product="<?php echo e($cartItem['product_id']); ?>" data-value="0"
                       data-action=""
                       data-min="<?php echo e(isset($product->minimum_order_qty) ? $product->minimum_order_qty : 1); ?>"
                       autocomplete="off" required>

                <div class="quantity__plus cart-qty-btn updateCartQuantity_cart_data"
                     data-cart="<?php echo e($cartItem['id']); ?>" data-product="<?php echo e($cartItem['product_id']); ?>" data-value="1"
                     data-action="">
                    <i class="bi bi-plus "></i>
                </div>
            </div>
        <?php else: ?>
            <div class="quantity quantity--style-two d-flex align-items-center">
                <div class="cart-qty-btn updateCartQuantity_cart_data"
                     data-cart="<?php echo e($cartItem['id']); ?>" data-product="<?php echo e($cartItem['product_id']); ?>"
                     data-value="<?php echo e($cartItem['quantity']); ?>" data-action="minus">
                    <i class="bi bi-trash3-fill text-danger fs-10"></i>
                </div>
            </div>
        <?php endif; ?>
    </li>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        updateCartQuantity_cart_data();
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/youngerlifestyle/public_html/resources/themes/theme_fashion/theme-views/layouts/partials/_cart-data.blade.php ENDPATH**/ ?>