<?php
    use App\Utils\Helpers;
    use App\Utils\ProductManager;
?>
<section>
    <div class="container">
        <?php if(auth('customer')->check() && count($order_again)>0): ?>
            <div class="bg-primary-light rounded p-3 d-sm-none mb-4">
                <h3 class="text-primary mb-3 mt-2 text-capitalize"><?php echo e(translate('order_again')); ?></h3>
                <p><?php echo e(translate('want_to_order_your_usuals')); ?>

                    ? <?php echo e(translate('just_reorder_from_your_previous_orders').'.'); ?></p>
                <div class="d-flex flex-wrap gap-3 custom-scrollbar height-26-5-rem">
                    <?php $__currentLoopData = $order_again; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card rounded-10 flex-grow-1">
                            <div class="p-3">
                                <h6 class="fs-12 text-primary mb-1">
                                    <?php if($order['order_status'] =='processing'): ?>
                                        <?php echo e(translate('packaging')); ?>

                                    <?php elseif($order['order_status'] =='failed'): ?>
                                        <?php echo e(translate('failed_to_deliver')); ?>

                                    <?php elseif($order['order_status'] == 'all'): ?>
                                        <?php echo e(translate('all')); ?>

                                    <?php else: ?>
                                        <?php echo e(translate(str_replace('_',' ',$order['order_status']))); ?>

                                    <?php endif; ?>
                                </h6>
                                <div
                                    class="fs-10"><?php echo e(translate('on')); ?> <?php echo e(date('d M Y',strtotime($order['updated_at']))); ?></div>
                                <div class="bg-light my-2 rounded-10 p-4">
                                    <div class="d-flex align-items-center justify-content-between gap-3">
                                        <?php $__currentLoopData = $order['details']->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div>
                                                <img width="42" loading="lazy" alt="" class="dark-support rounded"
                                                     src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.($detail['product']['thumbnail'] ?? ''), type: 'product')); ?>">
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php if(count($order['details']) > 3): ?>
                                            <h6 class="fw-medium fs-12 text-center">+<?php echo e(count($order['details'])-3); ?>

                                                <br>
                                                <a href="<?php echo e(route('account-order-details', ['order_id'=>$order['id']])); ?>"><?php echo e(translate('more')); ?></a>
                                            </h6>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                                    <div class="">
                                        <h6 class="fs-10 mb-2"><?php echo e(translate('Order_ID').':'. '#'); ?><?php echo e($order['id']); ?></h6>
                                        <h6><?php echo e(translate('final_total').':'); ?><?php echo e(Helpers::currency_converter($order['order_amount'])); ?></h6>
                                    </div>
                                    <a href="javascript:" data-order-id="<?php echo e($order['id']); ?>"
                                       class="btn btn-primary order-again"><?php echo e(translate('order_again')); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php else: ?>
            <div class="d-sm-none mb-4">
                <?php if($sidebar_banner): ?>
                    <a href="<?php echo e($sidebar_banner['url']); ?>">
                        <img src="<?php echo e(getValidImage(path: 'storage/app/public/banner/'.($sidebar_banner ? $sidebar_banner['photo'] : ''), type:'banner')); ?>"
                            alt="" class="dark-support rounded w-100">
                    </a>
                <?php else: ?>
                    <img src="<?php echo e(theme_asset('assets/img/top-side-banner-placeholder.png')); ?>"
                         class="dark-support rounded w-100" alt="">
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <div class="pb-3">
            <div class="">
                <div class="d-flex flex-wrap justify-content-between gap-3 mb-4">
                    <h2><?php echo e(translate('more_stores')); ?></h2>
                    <a href="<?php echo e(route('vendors')); ?>" class="btn-link"><?php echo e(translate('view_all')); ?>

                        <i class="bi bi-chevron-right text-primary"></i></a>
                </div>
                <div class="table-responsive hide-scrollbar">
                    <div class="d-flex gap-3 <?php echo e(count($more_seller) > 2 ? 'justify-content-between' : ''); ?> store-list">
                        <?php ($current_date = date('Y-m-d')); ?>
                        <?php $__currentLoopData = $more_seller; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php ($start_date = date('Y-m-d', strtotime($seller->shop['vacation_start_date']))); ?>
                            <?php ($end_date = date('Y-m-d', strtotime($seller->shop['vacation_end_date']))); ?>
                            <a href="<?php echo e(route('shopView',['id'=>$seller['id']])); ?>"
                               class="store-product d-flex flex-column gap-3 align-items-center">
                                <div class="position-relative">
                                    <div class="avatar rounded-circle">
                                        <img class="dark-support img-fit rounded-circle img-w-h-100"
                                             src="<?php echo e(getValidImage(path: 'storage/app/public/shop/'.$seller->shop->image, type:'shop')); ?>" alt=""
                                             loading="lazy">
                                    </div>
                                    <?php if($seller->shop->vacation_status && ($current_date >= $start_date) && ($current_date <= $end_date)): ?>
                                        <span class="temporary-closed position-absolute rounded-circle">
                                                <span><?php echo e(translate('closed_now')); ?></span>
                                            </span>
                                    <?php elseif($seller->shop->temporary_close): ?>
                                        <span class="temporary-closed position-absolute rounded-circle">
                                                <span><?php echo e(translate('closed_now')); ?></span>
                                            </span>
                                    <?php endif; ?>
                                </div>

                                <div class="d-flex flex-column align-items-center text-center gap-2 w-100">
                                    <h6 class="text-truncate text-center"><?php echo e($seller->shop->name); ?></h6>
                                    <div
                                        class="text-muted text-truncate product-count"><?php echo e($seller->product_count); ?> <?php echo e(translate('products')); ?></div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/youngerlifestyle/public_html/resources/themes/theme_aster/theme-views/partials/_more-stores.blade.php ENDPATH**/ ?>