<?php
    $shippingMethod = getWebConfig(name: 'shipping_method');
    $cart = \App\Models\Cart::where(['customer_id' => (auth('customer')->check() ? auth('customer')->id() : session('guest_id'))])->with(['seller','allProducts.category'])->get()->groupBy('cart_group_id');
?>

<?php if( $cart->count() > 0): ?>
    <div class="container">
        <div class="row g-4">
            <div class="col-lg-8 pe-lg-0">
                <div class="cart-title-area text-capitalize mb-2">
                    <h6 class="title"><?php echo e(translate('all_cart_product_list')); ?>

                        <span class="btn-status">(<?php echo e(count(\App\Utils\CartManager::get_cart())); ?>)</span>
                    </h6>
                    <span type="button" class="text-text-2 route_alert_function"
                          data-routename="<?php echo e(route('cart.remove-all')); ?>"
                          data-message="<?php echo e(translate('want_to_clear_all_cart?')); ?>"
                          data-typename=""><?php echo e(translate('remove_all')); ?></span>
                </div>

                <div class="table-responsive d-none d-md-block overflow-hidden">
                    <table class="table __table vertical-middle cart-list-table-custom">

                        <thead class="word-nobreak">
                        <tr>
                            <th>
                                <label class="form-check m-0">
                                    <span class="form-check-label"><?php echo e(translate('product')); ?></span>
                                </label>
                            </th>
                            <th class="text-center">
                                <?php echo e(translate('discount')); ?>

                            </th>
                            <th class="text-center">
                                <?php echo e(translate('quantity')); ?>

                            </th>
                            <th class="text-center">
                                <?php echo e(translate('total')); ?>

                            </th>
                        </tr>
                        </thead>
                    </table>
                    <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group_key=>$group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $physical_product = false;
                            $total_shipping_cost = 0;
                            foreach ($group as $row) {
                                if ($row->product_type == 'physical') {
                                    $physical_product = true;
                                }
                                if ($row->product_type == 'physical' && $row->shipping_type != "order_wise") {
                                    $total_shipping_cost += $row->shipping_cost;
                                }
                            }

                        ?>

                        <?php $__currentLoopData = $group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart_key=>$cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php if($shippingMethod=='inhouse_shipping'): ?>
                                    <?php

                                    $admin_shipping = \App\Models\ShippingType::where('seller_id', 0)->first();
                                    $shipping_type = isset($admin_shipping) == true ? $admin_shipping->shipping_type : 'order_wise';

                                    ?>
                            <?php else: ?>
                                    <?php
                                    if ($cartItem->seller_is == 'admin') {
                                        $admin_shipping = \App\Models\ShippingType::where('seller_id', 0)->first();
                                        $shipping_type = isset($admin_shipping) == true ? $admin_shipping->shipping_type : 'order_wise';
                                    } else {
                                        $seller_shipping = \App\Models\ShippingType::where('seller_id', $cartItem->seller_id)->first();
                                        $shipping_type = isset($seller_shipping) == true ? $seller_shipping->shipping_type : 'order_wise';
                                    }
                                    ?>
                            <?php endif; ?>
                            <?php if($cart_key==0): ?>
                                <div class="--bg-6 border-0 rounded py-2 px-2 px-sm-3 ">
                                    <div class="d-flex flex-wrap align-items-center justify-content-between ">

                                        <?php
                                            $verify_status = \App\Utils\OrderManager::minimum_order_amount_verify($request, $group_key);
                                        ?>

                                        <div class="min-w-180 d-flex">
                                            <?php if($cartItem->seller_is=='admin'): ?>
                                                <a href="<?php echo e(route('shopView',['id'=>0])); ?>" class="cart-shop">
                                                    <img loading="lazy" alt="<?php echo e(translate('logo')); ?>"
                                                         src="<?php echo e(getValidImage(path: "storage/app/public/company/".($web_config['fav_icon']->value), type: 'shop')); ?>">
                                                    <h6 class="text-base"><?php echo e($web_config['name']->value); ?></h6>
                                                </a>
                                            <?php else: ?>
                                                <a href="<?php echo e(route('shopView',['id'=>$cartItem->seller_id])); ?>"
                                                   class="cart-shop">
                                                    <img loading="lazy" alt="<?php echo e(translate('shop')); ?>"
                                                         src="<?php echo e(getValidImage(path: 'storage/app/public/shop/'.($cartItem->seller->shop->image ?? ''), type: 'shop')); ?>">
                                                    <h6 class="text-base"><?php echo e($cartItem->seller->shop->name); ?></h6>
                                                </a>
                                            <?php endif; ?>

                                            <?php if($verify_status['minimum_order_amount'] > $verify_status['amount']): ?>
                                                <span class="ps-2 text-danger pulse-button minimum_Order_Amount_message"
                                                      data-bs-toggle="tooltip" data-bs-placement="right"
                                                      data-bs-custom-class="custom-tooltip"
                                                      data-bs-title="<?php echo e(translate('minimum_Order_Amount')); ?> <?php echo e(\App\Utils\Helpers::currency_converter($verify_status['minimum_order_amount'])); ?> <?php echo e(translate('for')); ?> <?php if($cartItem->seller_is=='admin'): ?> <?php echo e(getWebConfig(name: 'company_name')); ?> <?php else: ?> <?php echo e(\App\Utils\get_shop_name($cartItem['seller_id'])); ?> <?php endif; ?>">
                                                    <i class="bi bi-info-circle"></i>
                                                </span>
                                            <?php endif; ?>
                                        </div>

                                        <?php if($physical_product && $shippingMethod=='sellerwise_shipping' && $shipping_type == 'order_wise'): ?>
                                            <?php
                                                $choosen_shipping=\App\Models\CartShipping::where(['cart_group_id'=>$cartItem['cart_group_id']])->first()
                                            ?>

                                            <?php if(isset($choosen_shipping)==false): ?>
                                                <?php $choosen_shipping['shipping_method_id']=0 ?>
                                            <?php endif; ?>

                                            <?php
                                                $shippings=\App\Utils\Helpers::get_shipping_methods($cartItem['seller_id'],$cartItem['seller_is'])

                                            ?>
                                            <?php if($physical_product && $shippingMethod=='sellerwise_shipping' && $shipping_type == 'order_wise'): ?>
                                                <div
                                                    class=" bg-white select-method-border rounded  py-2 position-relative">
                                                    <div class="d-flex ">
                                                        <div
                                                            class="flex-middle flex-nowrap fw-semibold text-dark mx-3 text-capitalize">
                                                            <i class="bi bi-truck"></i>
                                                            <?php echo e(translate('shipping_method')); ?> :
                                                        </div>

                                                        <div class="dropdown">
                                                            <a class="text-dark" href="javascript:" data-bs-toggle="dropdown">
                                                                    <?php
                                                                    $shippings_title = translate('choose_shipping_method');
                                                                    foreach ($shippings as $shipping) {
                                                                        if ($choosen_shipping['shipping_method_id'] == $shipping['id']) {
                                                                            $shippings_title = ucfirst($shipping['title']) . ' ( ' . $shipping['duration'] . ' ) ' . \App\Utils\Helpers::currency_converter($shipping['cost']);
                                                                        }
                                                                    }
                                                                    ?>
                                                                <?php echo e($shippings_title); ?>

                                                                <i class="ms-1 text-small bi bi-chevron-down"></i>
                                                            </a>
                                                            <div class="dropdown-menu __dropdown-menu">
                                                                <ul class="">
                                                                    <?php $__currentLoopData = $shippings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipping): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <li class="cursor-pointer text-dark px-3 py-1 set_shipping_id_function"
                                                                            data-id="<?php echo e($shipping['id']); ?>"
                                                                            data-cartgroup="<?php echo e($cartItem['cart_group_id']); ?>"
                                                                        >
                                                                            <?php echo e(ucfirst($shipping['title']).' ( '.$shipping['duration'].' ) '.\App\Utils\Helpers::currency_converter($shipping['cost'])); ?>

                                                                        </li>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php if($shipping_type != 'order_wise'): ?>
                                                <div class=" bg-white select-method-border rounded  py-2">
                                                    <div class="d-flex ">
                                                        <div
                                                            class="flex-middle flex-nowrap fw-semibold text-dark mx-3 text-capitalize">
                                                            <i class="bi bi-truck"></i>
                                                            <?php echo e(translate('shipping_cost')); ?> :
                                                        </div>
                                                        <div class="">
                                                            <span><?php echo e(\App\Utils\Helpers::currency_converter($total_shipping_cost)); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $physical_product = false;
                            foreach ($group as $row) {
                                if ($row->product_type == 'physical') {
                                    $physical_product = true;
                                }
                            }
                        ?>
                        <?php ($product_null_status = 0); ?>
                        <?php ($total_amount = 0); ?>
                        <?php $__currentLoopData = $group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php ($product = $cartItem->allProducts); ?>

                            <?php if(!$product): ?>
                                <?php ($product_null_status = 1); ?>
                            <?php endif; ?>


                            <form class="cart add_to_cart_form<?php echo e($cartItem['id']); ?>"
                                  id="add_to_cart_form_web<?php echo e($cartItem['id']); ?>"
                                  action="<?php echo e(route('cart.update-variation')); ?>"
                                  data-redirecturl="<?php echo e(route('checkout-details')); ?>"
                                  data-varianturl="<?php echo e(route('cart.variant_price')); ?>"
                                  data-errormessage="<?php echo e(translate('please_choose_all_the_options')); ?>"
                                  data-outofstock="<?php echo e(translate('sorry').', '.translate('out_of_stock')); ?>.">
                                <?php echo csrf_field(); ?>
                                <table class="table __table vertical-middle cart-list-table-custom">

                                    <tbody>
                                    <tr>
                                        <td>
                                            <input type="text" name="id" value="<?php echo e($cartItem->id); ?>" hidden>
                                            <input type="text" name="product_id" value="<?php echo e($product->id); ?>" hidden>
                                            <div class="cart-product  align-items-center">
                                                <label class="form-check position-relative overflow-hidden">
                                                    <?php if($product->status == 1): ?>
                                                        <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                             src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.$product['thumbnail'], type: 'product')); ?>">
                                                    <?php elseif($product->status == 0): ?>
                                                        <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                             src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.$product['thumbnail'], type: 'product')); ?>">
                                                        <span
                                                            class="temporary-closed position-absolute text-center p-2">
                                                                    <span><?php echo e(translate('not_available')); ?></span>
                                                                </span>
                                                    <?php else: ?>
                                                        <img loading="lazy"
                                                             src="<?php echo e(theme_asset('assets/img/image-place-holder.png')); ?>"
                                                             alt="<?php echo e(translate('product')); ?>">
                                                        <span
                                                            class="temporary-closed position-absolute text-center p-2">
                                                                    <span><?php echo e(translate('not_available')); ?></span>
                                                                </span>
                                                    <?php endif; ?>
                                                </label>


                                                <div class="cont <?php echo e($product->status == 0 ? 'blur-section':''); ?>">
                                                    <a href="<?php echo e($product->status == 1 ? route('product',$product['slug']) : 'javascript:'); ?>"
                                                       class="name text-title">
                                                        <?php echo e($product->name); ?>

                                                    </a>
                                                    <div class="d-flex column-gap-1">
                                                        <span><?php echo e(translate('price')); ?></span> <span>:</span> <strong
                                                            class="product_price<?php echo e($cartItem['id']); ?>"><?php echo e(\App\Utils\Helpers::currency_converter($cartItem->price)); ?></strong>
                                                    </div>
                                                    <div class="d-flex column-gap-1">
                                                        <?php if(isset($product->category)): ?>
                                                            <span><?php echo e(translate('category')); ?> </span> <span>:</span>
                                                            <strong><?php echo e(isset($product->category) ? $product->category->name:''); ?></strong>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php if($product): ?>
                                                        <?php if($product->product_type == "physical"): ?>
                                                            <div class="d-flex flex-wrap column-gap-3">
                                                                <?php if(!empty(json_decode($product->colors))): ?>
                                                                    <div class="d-flex column-gap-1">
                                                                        <span><?php echo e(translate('color')); ?> </span>
                                                                        <span>:</span>
                                                                        <select
                                                                            class="no-border-select variants-class<?php echo e($key); ?> update_add_to_cart_by_variation_web"
                                                                            data-id="<?php echo e($cartItem['id']); ?>"
                                                                            name="color">
                                                                            <?php $__currentLoopData = json_decode($product->colors); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option
                                                                                    value="<?php echo e($value); ?>" <?php echo e($cartItem->color == $value ? 'selected':''); ?>><?php echo e(\App\Utils\get_color_name($value)); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                    </div>
                                                                <?php endif; ?>

                                                                <?php ($variations = json_decode($cartItem->variations,true)); ?>
                                                                <?php $__currentLoopData = json_decode($product->choice_options); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <div class="d-flex column-gap-1">
                                                                        <span> <?php echo e(translate( $choice->title )); ?> </span>
                                                                        <span>:</span>
                                                                        <select
                                                                            class="no-border-select variants-class<?php echo e($key); ?> update_add_to_cart_by_variation_web"
                                                                            data-id="<?php echo e($cartItem['id']); ?>"
                                                                            name="<?php echo e($choice->name); ?>">
                                                                            <?php $__currentLoopData = $choice->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option
                                                                                    value="<?php echo e(trim($value)); ?>" <?php echo e(in_array(trim($value),$variations,true) ? 'selected' : ''); ?>><?php echo e(ucwords($value)); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>
                                                            <?php if( $shipping_type != 'order_wise'): ?>
                                                                <div class="d-flex column-gap-1">
                                                                    <span><?php echo e(translate('shipping_cost')); ?></span> <span>:</span>
                                                                    <strong
                                                                        class=""><?php echo e(\App\Utils\Helpers::currency_converter($cartItem['shipping_cost'])); ?></strong>
                                                                </div>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <?php if($cartItem['discount'] > 0): ?>
                                                <span class="badge badge-soft-base product_discount<?php echo e($cartItem['id']); ?>">-<?php echo e(\App\Utils\Helpers::currency_converter($cartItem['discount']*$cartItem['quantity'])); ?></span>
                                            <?php else: ?>
                                                <span
                                                    class="badge text-capitalize badge-soft-secondary discount<?php echo e($cartItem['id']); ?>"><?php echo e(translate('no_discount')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center">
                                            <?php ($minimum_order=\App\Utils\ProductManager::get_product($cartItem['product_id'])); ?>

                                            <?php if($minimum_order): ?>
                                                <div class="quantity __quantity">
                                                    <input type="number"
                                                           class="quantity__qty cart-qty-input cart-quantity-web<?php echo e($cartItem['id']); ?> form-control cartQuantity<?php echo e($cartItem['id']); ?> updateCartQuantityList_cart_data"
                                                           value="<?php echo e($cartItem['quantity']); ?>" name="quantity"
                                                           id="cartQuantityWeb<?php echo e($cartItem['id']); ?>"
                                                           data-minorder="<?php echo e($minimum_order->minimum_order_qty); ?>"
                                                           data-cart="<?php echo e($cartItem['id']); ?>" data-value="0"
                                                           data-action=""
                                                           data-min="<?php echo e(isset($cartItem->product->minimum_order_qty) ? $cartItem->product->minimum_order_qty : 1); ?>">
                                                    <div>
                                                        <div
                                                            class="quantity__plus cart-qty-btn updateCartQuantityList_cart_data"
                                                            data-minorder="<?php echo e($minimum_order->minimum_order_qty); ?>"
                                                            data-cart="<?php echo e($cartItem['id']); ?>" data-value="1"
                                                            data-action=""
                                                        >
                                                            <i class="bi bi-plus "></i>
                                                        </div>
                                                        <div
                                                            class="quantity__minus cart-qty-btn updateCartQuantityList_cart_data"
                                                            data-minorder="<?php echo e($minimum_order->minimum_order_qty); ?>"
                                                            data-cart="<?php echo e($cartItem['id']); ?>" data-value="-1"
                                                            data-action="<?php echo e($cartItem['quantity'] == $minimum_order->minimum_order_qty ? 'delete':'minus'); ?>"
                                                        >
                                                            <i class="<?php echo e($cartItem['quantity'] == (isset($cartItem->product->minimum_order_qty) ? $cartItem->product->minimum_order_qty : 1) ? 'bi bi-trash3-fill text-danger fs-10' : 'bi bi-dash-lg'); ?>"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <div class="quantity __quantity">
                                                    <input type="text"
                                                           class="quantity__qty cart-qty-input cart-quantity-web<?php echo e($cartItem['id']); ?> form-control cartQuantity<?php echo e($cartItem['id']); ?>"
                                                           name="quantity" id="cartQuantity<?php echo e($cartItem['id']); ?>"
                                                           data-min="<?php echo e($cartItem['quantity']); ?>"
                                                           value="<?php echo e($cartItem['quantity']); ?>" readonly>
                                                    <div>
                                                        <div class="cart-qty-btn disabled"
                                                             title="<?php echo e(translate('product_not_available')); ?>">
                                                            <i class="bi bi-exclamation-circle text-danger"></i>
                                                        </div>
                                                        <div class="cart-qty-btn updateCartQuantityList_cart_data"
                                                             data-minorder="<?php echo e($cartItem['quantity']+1); ?>"
                                                             data-cart="<?php echo e($cartItem['id']); ?>"
                                                             data-value="-<?php echo e($cartItem['quantity']); ?>"
                                                             data-action="delete">
                                                            <i class="bi bi-trash3-fill text-danger fs-10}"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <?php ($total_amount = $total_amount + ($cartItem['price']-$cartItem['discount'])*$cartItem['quantity']); ?>
                                        <td class="text-center"><?php echo e(\App\Utils\Helpers::currency_converter(($cartItem['price']-$cartItem['discount'])*$cartItem['quantity'])); ?></td>

                                    </tr>
                                    </tbody>
                                </table>
                            </form>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>

                            <?php ($free_delivery_status = \App\Utils\OrderManager::free_delivery_order_amount($group[0]->cart_group_id)); ?>

                            <?php if($free_delivery_status['status'] && (session()->missing('coupon_type') || session('coupon_type') !='free_delivery')): ?>
                                <div class="free-delivery-area px-3 mb-3">
                                    <div class="d-flex align-items-center gap-3">
                                        <img loading="lazy"
                                            src="<?php echo e(theme_asset('assets/img/free-shipping.svg')); ?>"
                                            alt="<?php echo e(translate('free_shipping')); ?>" width="40">
                                        <?php if($free_delivery_status['amount_need'] <= 0): ?>
                                            <span
                                                class="text-muted fs-16"><?php echo e(translate('you_Get_Free_Delivery_Bonus')); ?></span>
                                        <?php else: ?>
                                            <span
                                                class="need-for-free-delivery font-bold"><?php echo e(\App\Utils\Helpers::currency_converter($free_delivery_status['amount_need'])); ?></span>
                                            <span
                                                class="text-muted fs-16"><?php echo e(translate('add_more_for_free_delivery')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="progress free-delivery-progress">
                                        <div class="progress-bar" role="progressbar"
                                             style="width: <?php echo e($free_delivery_status['percentage']); ?>%"
                                             aria-valuenow="<?php echo e($free_delivery_status['percentage']); ?>" aria-valuemin="0"
                                             aria-valuemax="100"></div>
                                    </div>
                                </div>
                            <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>


                <div class="d-flex d-md-none flex-column mt-4 gap-3">
                    <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group_key=>$group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $physical_product = false;
                            $total_shipping_cost = 0;
                            foreach ($group as $row) {
                                if ($row->product_type == 'physical') {
                                    $physical_product = true;
                                }
                                if ($row->product_type == 'physical' && $row->shipping_type != "order_wise") {
                                    $total_shipping_cost += $row->shipping_cost;
                                }
                            }
                            ?>
                        <?php $__currentLoopData = $group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart_key=>$cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($shippingMethod=='inhouse_shipping'): ?>
                                    <?php
                                    $admin_shipping = \App\Models\ShippingType::where('seller_id', 0)->first();
                                    $shipping_type = isset($admin_shipping) == true ? $admin_shipping->shipping_type : 'order_wise';
                                    ?>
                            <?php else: ?>
                                    <?php
                                    if ($cartItem->seller_is == 'admin') {
                                        $admin_shipping = \App\Models\ShippingType::where('seller_id', 0)->first();
                                        $shipping_type = isset($admin_shipping) == true ? $admin_shipping->shipping_type : 'order_wise';
                                    } else {
                                        $seller_shipping = \App\Models\ShippingType::where('seller_id', $cartItem->seller_id)->first();
                                        $shipping_type = isset($seller_shipping) == true ? $seller_shipping->shipping_type : 'order_wise';
                                    }
                                    ?>
                            <?php endif; ?>
                            <?php if($cart_key==0): ?>
                                <div class="--bg-6 border-0 rounded py-2 px-2 px-sm-3 ">
                                    <div class="d-flex flex-wrap gap-2 align-items-center justify-content-between ">
                                        <div class="flex-grow-1">
                                            <div class="d-flex">
                                                <?php if($cartItem->seller_is=='admin'): ?>
                                                    <a href="<?php echo e(route('shopView',['id'=>0])); ?>" class="cart-shop">
                                                        <img loading="lazy" alt="<?php echo e(translate('shop')); ?>"
                                                             src="<?php echo e(getValidImage(path: "storage/app/public/company/".$web_config['fav_icon']->value, type: 'logo')); ?>">
                                                        <h6 class="name text-base text-nowrap w-100"><?php echo e($web_config['name']->value); ?></h6>
                                                    </a>
                                                <?php else: ?>
                                                    <a href="<?php echo e(route('shopView',['id'=>$cartItem->seller_id])); ?>"
                                                       class="cart-shop">
                                                        <img loading="lazy" alt="<?php echo e(translate('shop')); ?>"
                                                             src="<?php echo e(getValidImage(path: 'storage/app/public/shop/'.($cartItem->seller->shop->image ?? ''), type: 'shop')); ?>">
                                                        <h6 class="name text-base text-nowrap w-100"><?php echo e($cartItem->seller->shop->name); ?></h6>
                                                    </a>
                                                <?php endif; ?>

                                                    <?php
                                                    $verify_status = \App\Utils\OrderManager::minimum_order_amount_verify($request, $group_key);
                                                    ?>

                                                <?php if($verify_status['minimum_order_amount'] > $verify_status['amount']): ?>
                                                    <span
                                                        class="ps-2 text-danger pulse-button minimum_Order_Amount_message"
                                                        data-bs-title="<?php echo e(translate('minimum_Order_Amount')); ?> <?php echo e(\App\Utils\Helpers::currency_converter($verify_status['minimum_order_amount'])); ?> <?php echo e(translate('for')); ?> <?php if($cartItem->seller_is=='admin'): ?> <?php echo e(getWebConfig(name: 'company_name')); ?> <?php else: ?> <?php echo e(\App\Utils\get_shop_name($cartItem['seller_id'])); ?> <?php endif; ?>">
                                                    <i class="bi bi-info-circle"></i>
                                                </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php if($physical_product && $shippingMethod=='sellerwise_shipping' && $shipping_type == 'order_wise'): ?>
                                            <?php ($choosen_shipping=\App\Models\CartShipping::where(['cart_group_id'=>$cartItem['cart_group_id']])->first()); ?>
                                            <?php if(isset($choosen_shipping)==false): ?>
                                                <?php ( $choosen_shipping['shipping_method_id']= 0 ); ?>
                                            <?php endif; ?>

                                            <?php ($shippings=\App\Utils\Helpers::get_shipping_methods($cartItem['seller_id'],$cartItem['seller_is'])); ?>

                                            <?php if($physical_product && $shippingMethod=='sellerwise_shipping' && $shipping_type == 'order_wise'): ?>
                                                <div class="max-sm-100px bg-white select-method-border rounded  py-2">
                                                    <div class="d-flex overflow-hidden">
                                                        <div class="flex-middle flex-nowrap fw-semibold text-dark mx-2">
                                                            <i class="bi bi-truck"></i>
                                                        </div>

                                                        <div class="dropdown">
                                                            <a class="text-dark text-truncate" href="javascript:" data-bs-toggle="dropdown">
                                                                    <?php
                                                                    $shippings_title = translate('choose_shipping_method');
                                                                    foreach ($shippings as $shipping) {
                                                                        if ($choosen_shipping['shipping_method_id'] == $shipping['id']) {
                                                                            $shippings_title = ucfirst($shipping['title']) . ' ( ' . $shipping['duration'] . ' ) ' . \App\Utils\Helpers::currency_converter($shipping['cost']);
                                                                        }
                                                                    }
                                                                    ?>
                                                                <?php echo e($shippings_title); ?>

                                                                <i class="ms-1 text-small bi bi-chevron-down"></i>
                                                            </a>
                                                            <div class="dropdown-menu __dropdown-menu">
                                                                <ul class="">
                                                                    <?php $__currentLoopData = $shippings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipping): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <li class="cursor-pointer text-dark px-3 py-1 set_shipping_id_function"
                                                                            data-id="<?php echo e($shipping['id']); ?>"
                                                                            data-cartgroup="<?php echo e($cartItem['cart_group_id']); ?>"
                                                                        >
                                                                            <?php echo e(ucfirst($shipping['title']).' ( '.$shipping['duration'].' ) '.\App\Utils\Helpers::currency_converter($shipping['cost'])); ?>

                                                                        </li>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <div class=" bg-white select-method-border rounded  py-2">
                                                <div class="d-flex ">
                                                    <div
                                                        class="flex-middle flex-nowrap fw-semibold text-dark mx-3 text-capitalize">
                                                        <i class="bi bi-truck"></i>
                                                        <?php echo e(translate('shipping_cost')); ?> :
                                                    </div>
                                                    <div class="">
                                                        <span><?php echo e(\App\Utils\Helpers::currency_converter($total_shipping_cost)); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $physical_product = false;
                            foreach ($group as $row) {
                                if ($row->product_type == 'physical') {
                                    $physical_product = true;
                                }
                            }
                            ?>
                        <?php $__currentLoopData = $group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php ($product = $cartItem->product); ?>

                            <form class="cart add_to_cart_form<?php echo e($cartItem['id']); ?>"
                                  id="add_to_cart_form_mobile<?php echo e($cartItem['id']); ?>"
                                  action="<?php echo e(route('cart.update-variation')); ?>"
                                  data-redirecturl="<?php echo e(route('checkout-details')); ?>"
                                  data-varianturl="<?php echo e(route('cart.variant_price')); ?>"
                                  data-errormessage="<?php echo e(translate('please_choose_all_the_options')); ?>"
                                  data-outofstock="<?php echo e(translate('sorry').', '.translate('out_of_stock')); ?>.">
                                <?php echo csrf_field(); ?>
                                <div class="d-flex gap-3 pb-3 border-bottom justify-content-between align-items-center">
                                    <input type="text" name="id" value="<?php echo e($cartItem->id); ?>" hidden>
                                    <input type="text" name="product_id"
                                           value="<?php echo e(isset($product) ? $product->id : ''); ?>" hidden>
                                    <div class="cart-product">
                                        <label class="form-check">
                                            <?php if(isset($product)): ?>
                                                <img loading="lazy" alt="<?php echo e(translate('product')); ?>"
                                                     src="<?php echo e(getValidImage(path: 'storage/app/public/product/thumbnail/'.$product['thumbnail'], type: 'product')); ?>">
                                            <?php else: ?>
                                                <img loading="lazy"
                                                    src="<?php echo e(theme_asset('assets/img/image-place-holder.png')); ?>"
                                                    alt="<?php echo e(translate('product')); ?>">

                                            <?php endif; ?>
                                        </label>
                                        <div class="cont d-flex flex-column gap-1">
                                            <a href="<?php echo e(isset($product) ? route('product',$product['slug']) : 'javascript:'); ?>"
                                               class="name text-title"><?php echo e(isset($product) ? $product->name : 'N/a'); ?></a>
                                            <div class="d-flex column-gap-1">
                                                <span><?php echo e(translate('price')); ?></span> <span>:</span> <strong
                                                    class="product_price<?php echo e($cartItem['id']); ?>"><?php echo e(\App\Utils\Helpers::currency_converter($cartItem->price)); ?></strong>
                                            </div>
                                            <div class="d-flex column-gap-1">
                                                <?php if(isset($product->category)): ?>
                                                    <span><?php echo e(translate('category')); ?> </span> <span>:</span>
                                                    <strong><?php echo e(isset($product->category) ? $product->category->name:''); ?></strong>
                                                <?php endif; ?>
                                            </div>
                                            <?php if(isset($product)): ?>
                                                <div class="d-flex column-gap-1">
                                                    <?php if($cartItem['discount'] > 0 ): ?>
                                                        <span><?php echo e(translate('discount')); ?></span> <span>:</span>
                                                        <strong
                                                            class="product_discount<?php echo e($cartItem['id']); ?>"><?php echo e(\App\Utils\Helpers::currency_converter($cartItem['discount']*$cartItem['quantity'])); ?></strong>
                                                    <?php else: ?>
                                                        <span><?php echo e(translate('discount')); ?></span> <span>:</span>
                                                        <span
                                                            class="badge text-capitalize badge-soft-secondary discount<?php echo e($cartItem['id']); ?>"><?php echo e(translate('no_discount')); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="d-flex column-gap-1">
                                                    <span><?php echo e(translate('total_price')); ?></span> <span>:</span>
                                                    <strong><?php echo e(\App\Utils\Helpers::currency_converter(($cartItem['price']-$cartItem['discount'])*$cartItem['quantity'])); ?></strong>
                                                </div>

                                                <?php if($product->product_type == "physical"): ?>
                                                    <?php if( $shipping_type != 'order_wise' ): ?>
                                                        <div class="d-flex column-gap-1">
                                                            <span><?php echo e(translate('shipping_cost')); ?></span> <span>:</span>
                                                            <strong><?php echo e(\App\Utils\Helpers::currency_converter($cartItem['shipping_cost'])); ?></strong>
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="column-gap-3">
                                                        <?php if(!empty(json_decode($product->colors))): ?>
                                                            <div class="d-flex column-gap-1">
                                                                <span><?php echo e(translate('color')); ?> </span> <span>:</span>
                                                                <select
                                                                    class="no-border-select text-title variants-class<?php echo e($key); ?> update_add_to_cart_by_variation_mobile"
                                                                    data-id="<?php echo e($cartItem['id']); ?>" name="color">
                                                                    <?php $__currentLoopData = json_decode($product->colors); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option
                                                                            value="<?php echo e($value); ?>"<?php echo e($cartItem->color == $value ? 'selected':''); ?>><?php echo e(\App\Utils\get_color_name($value)); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php ($variations = json_decode($cartItem->variations,true)); ?>
                                                        <?php $__currentLoopData = json_decode($product->choice_options); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $choice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="d-flex column-gap-1">
                                                                <span> <?php echo e(translate( $choice->title )); ?> </span>
                                                                <span>:</span>
                                                                <select
                                                                    class="no-border-select text-title variants-class<?php echo e($key); ?> update_add_to_cart_by_variation_mobile"
                                                                    data-id="<?php echo e($cartItem['id']); ?>"
                                                                    name="<?php echo e($choice->name); ?>">
                                                                    <?php $__currentLoopData = $choice->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option
                                                                            value="<?php echo e(trim($value)); ?>" <?php echo e(in_array(trim($value),$variations,true) ? 'selected' : ''); ?>><?php echo e(ucwords($value)); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                N/a
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php ($minimum_order=\App\Utils\ProductManager::get_product($cartItem['product_id'])); ?>
                                    <?php if($minimum_order): ?>
                                        <div class="quantity quantity--style-two d-flex flex-column align-items-center">
                                            <div
                                                class="quantity__minus cart-qty-btn updateCartQuantityListMobile_cart_data"
                                                data-minorder="<?php echo e($minimum_order->minimum_order_qty); ?>"
                                                data-cart="<?php echo e($cartItem['id']); ?>" data-value="-1"
                                                data-action="<?php echo e($cartItem['quantity'] == $minimum_order->minimum_order_qty ? 'delete':'minus'); ?>"
                                            >
                                                <i class="<?php echo e($cartItem['quantity'] == (isset($cartItem->product->minimum_order_qty) ? $cartItem->product->minimum_order_qty : 1) ? 'bi bi-trash3-fill text-danger fs-10' : 'bi bi-dash-lg'); ?>"></i>
                                            </div>
                                            <input type="text"
                                                   class="updateCartQuantityListMobile_cart_data quantity__qty cart-qty-input form-control cart-quantity-mobile<?php echo e($cartItem['id']); ?> cartQuantity<?php echo e($cartItem['id']); ?>"
                                                   value="<?php echo e($cartItem['quantity']); ?>" name="quantity"
                                                   id="cartQuantityMobile<?php echo e($cartItem['id']); ?>"
                                                   data-minorder="<?php echo e($minimum_order->minimum_order_qty); ?>"
                                                   data-cart="<?php echo e($cartItem['id']); ?>" data-value="0" data-action=""
                                                   data-min="<?php echo e(isset($cartItem->product->minimum_order_qty) ? $cartItem->product->minimum_order_qty : 1); ?>">

                                            <div
                                                class="quantity__plus cart-qty-btn updateCartQuantityListMobile_cart_data"
                                                data-minorder="<?php echo e($minimum_order->minimum_order_qty); ?>"
                                                data-cart="<?php echo e($cartItem['id']); ?>" data-value="1" data-action="">
                                                <i class="bi bi-plus "></i>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="quantity quantity--style-two d-flex flex-column align-items-center">
                                            <div class="cart-qty-btn updateCartQuantityList_cart_data"
                                                 data-minorder="<?php echo e($cartItem['quantity']+1); ?>"
                                                 data-cart="<?php echo e($cartItem['id']); ?>"
                                                 data-value="-<?php echo e($cartItem['quantity']); ?>" data-action="delete">
                                                <i class="bi bi-trash3-fill text-danger fs-10"></i>
                                            </div>
                                            <input type="text"
                                                   class="quantity__qty cart-qty-input form-control cart-quantity-mobile<?php echo e($cartItem['id']); ?> cartQuantity<?php echo e($cartItem['id']); ?> updateCartQuantityList_cart_data"
                                                   data-minorder="<?php echo e($minimum_order->minimum_order_qty ?? 1); ?>"
                                                   data-cart="<?php echo e($cartItem['id']); ?>" data-value="0" data-action=""
                                                   value="<?php echo e($cartItem['quantity']); ?>" name="quantity"
                                                   id="cartQuantityMobile<?php echo e($cartItem['id']); ?>"
                                                   data-min="<?php echo e($cartItem['quantity']); ?>" disabled>
                                            <div class="cart-qty-btn" disabled
                                                 title="<?php echo e(translate('product_not_available')); ?>">
                                                <i class="bi bi-exclamation-circle text-danger"></i>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </form>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php if($free_delivery_status['status'] && (session()->missing('coupon_type') || session('coupon_type') !='free_delivery')): ?>
                            <div class="free-delivery-area px-3 mb-3">
                                <div class="d-flex align-items-center gap-3">
                                    <img loading="lazy"
                                        src="<?php echo e(theme_asset('assets/img/free-shipping.svg')); ?>"
                                         alt="<?php echo e(translate('free_shipping')); ?>" width="40">
                                    <?php if($free_delivery_status['amount_need'] <= 0): ?>
                                        <span
                                            class="text-muted fs-16"><?php echo e(translate('you_Get_Free_Delivery_Bonus')); ?></span>
                                    <?php else: ?>
                                        <span
                                            class="need-for-free-delivery font-bold"><?php echo e(\App\Utils\Helpers::currency_converter($free_delivery_status['amount_need'])); ?></span>
                                        <span
                                            class="text-muted fs-16"><?php echo e(translate('add_more_for_free_delivery')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="progress free-delivery-progress">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo e($free_delivery_status['percentage']); ?>%"
                                         aria-valuenow="<?php echo e($free_delivery_status['percentage']); ?>" aria-valuemin="0"
                                         aria-valuemax="100"></div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>


                <div>
                    <?php if($shippingMethod=='inhouse_shipping'): ?>
                            <?php
                            $physical_product = false;
                            foreach ($cart as $group_key => $group) {
                                foreach ($group as $row) {
                                    if ($row->product_type == 'physical') {
                                        $physical_product = true;
                                    }
                                }
                            }

                            $admin_shipping = \App\Models\ShippingType::where('seller_id', 0)->first();
                            $shipping_type = isset($admin_shipping) == true ? $admin_shipping->shipping_type : 'order_wise';
                            ?>
                        <?php if($shipping_type == 'order_wise' && $physical_product): ?>
                            <?php ($shippings=\App\Utils\Helpers::get_shipping_methods(1,'admin')); ?>
                            <?php ($choosen_shipping=\App\Models\CartShipping::where(['cart_group_id'=>$cartItem['cart_group_id']])->first()); ?>

                            <?php if(isset($choosen_shipping)==false): ?>
                                <?php ($choosen_shipping['shipping_method_id']=0); ?>
                            <?php endif; ?>
                            <div class="row">
                                <div class="col-12">
                                    <select
                                        class="form-control bg-transparent text-dark text-truncate outline-custom-remove form-select set_shipping_onchange">
                                        <option><?php echo e(translate('choose_shipping_method')); ?></option>
                                        <?php $__currentLoopData = $shippings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipping): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                value="<?php echo e($shipping['id']); ?>" <?php echo e($choosen_shipping['shipping_method_id']==$shipping['id']?'selected':''); ?>>
                                                <?php echo e($shipping['title'].' ( '.$shipping['duration'].' ) '.\App\Utils\Helpers::currency_converter($shipping['cost'])); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                    <form method="get">
                        <div class="form-group mt-3">
                            <div class="row">
                                <div class="col-12">
                                    <label for="order_note" class="form--label mb-2"><?php echo e(translate('order_note')); ?> <span
                                            class="form-label">(<?php echo e(translate('optional')); ?>)</span></label>
                                    <textarea class="form-control w-100" rows="5" id="order_note"
                                              name="order_note"><?php echo e(session('order_note')); ?></textarea>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
            <div class="col-lg-4 ps-lg-4 ps-xl-5">
                <?php echo $__env->make('theme-views.partials._total-cost', ['product_null_status'=>$product_null_status], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

        </div>
    </div>
<?php else: ?>
    <div class="d-flex justify-content-center align-items-center">
        <h4 class="text-danger text-capitalize"><?php echo e(translate('cart_empty')); ?></h4>
    </div>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(theme_asset('assets/js/cart-details.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php /**PATH /home/elitedesignbd/ecommerce10.elitedesign.com.bd/resources/themes/theme_fashion/theme-views/layouts/partials/_cart-details.blade.php ENDPATH**/ ?>