<?php $sslcommerzStatus = get_payment_setting('status', SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>
<table class="table payment-method-item">
    <tbody>
    <tr class="border-pay-row">
        <td class="border-pay-col"><i class="fa fa-theme-payments"></i></td>
        <td style="width: 20%;">
            <img class="filter-black" src="<?php echo e(url('vendor/core/plugins/sslcommerz/images/sslcommerz.png')); ?>"
                 alt="SslCommerz">
        </td>
        <td class="border-right">
            <ul>
                <li>
                    <a href="https://sslcommerz.com" target="_blank"><?php echo e(__('SslCommerz')); ?></a>
                    <p><?php echo e(__('Customer can buy product and pay directly using Visa, Credit card via :name', ['name' => 'SslCommerz'])); ?></p>
                </li>
            </ul>
        </td>
    </tr>
    <tr class="bg-white">
        <td colspan="3">
            <div class="float-start" style="margin-top: 5px;">
                <div
                    class="payment-name-label-group <?php if(get_payment_setting('status', SSLCOMMERZ_PAYMENT_METHOD_NAME) == 0): ?> hidden <?php endif; ?>">
                    <span class="payment-note v-a-t"><?php echo e(trans('plugins/payment::payment.use')); ?>:</span> <label
                        class="ws-nm inline-display method-name-label"><?php echo e(get_payment_setting('name', SSLCOMMERZ_PAYMENT_METHOD_NAME, __('Online payment via :name', ['name' => 'SslCommerz']))); ?></label>
                </div>
            </div>
            <div class="float-end">
                <a class="btn btn-secondary toggle-payment-item edit-payment-item-btn-trigger <?php if($sslcommerzStatus == 0): ?> hidden <?php endif; ?>"><?php echo e(trans('plugins/payment::payment.edit')); ?></a>
                <a class="btn btn-secondary toggle-payment-item save-payment-item-btn-trigger <?php if($sslcommerzStatus == 1): ?> hidden <?php endif; ?>"><?php echo e(trans('plugins/payment::payment.settings')); ?></a>
            </div>
        </td>
    </tr>
    <tr class="paypal-online-payment payment-content-item hidden">
        <td class="border-left" colspan="3">
            <?php echo Form::open(); ?>

            <?php echo Form::hidden('type', SSLCOMMERZ_PAYMENT_METHOD_NAME, ['class' => 'payment_type']); ?>

            <div class="row">
                <div class="col-sm-6">
                    <ul>
                        <li>
                            <label><?php echo e(trans('plugins/payment::payment.configuration_instruction', ['name' => 'SslCommerz'])); ?></label>
                        </li>
                        <li class="payment-note">
                            <p><?php echo e(trans('plugins/payment::payment.configuration_requirement', ['name' => 'SslCommerz'])); ?>

                                :</p>
                            <ul class="m-md-l" style="list-style-type:decimal">
                                <li style="list-style-type:decimal">
                                    <p>For registration in Sandbox, click the link <a
                                            href="https://developer.sslcommerz.com/registration/" target="_blank">https://developer.sslcommerz.com/registration</a></p>
                                    <p>For registration in Production, click the link <a
                                            href="https://signup.sslcommerz.com/register" target="_blank">https://signup.sslcommerz.com/register</a></p>
                                </li>
                                <li style="list-style-type:decimal">
                                    <p><?php echo e(__('After registration at :name, you will have Store ID and Store Password (API/Secret key)', ['name' => 'SslCommerz'])); ?></p>
                                </li>
                                <li style="list-style-type:decimal">
                                    <p><?php echo e(__('Enter Store ID and Store Password (API/Secret key) into the box in right hand')); ?></p>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="col-sm-6">
                    <div class="well bg-white">
                        <div class="form-group mb-3">
                            <label class="text-title-field"
                                   for="sslcommerz_name"><?php echo e(trans('plugins/payment::payment.method_name')); ?></label>
                            <input type="text" class="next-input" name="payment_<?php echo e(SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>_name"
                                   id="sslcommerz_name" data-counter="400"
                                   value="<?php echo e(get_payment_setting('name', SSLCOMMERZ_PAYMENT_METHOD_NAME, __('Online payment via :name', ['name' => 'SslCommerz']))); ?>">
                        </div>
                        <div class="form-group mb-3">
                            <label class="text-title-field" for="payment_<?php echo e(SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>_description"><?php echo e(trans('core/base::forms.description')); ?></label>
                            <textarea class="next-input" name="payment_<?php echo e(SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>_description" id="payment_<?php echo e(SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>_description"><?php echo e(get_payment_setting('description', SSLCOMMERZ_PAYMENT_METHOD_NAME, __('The largest payment gateway aggregator in Bangladesh and a pioneer in the FinTech industry since 2010'))); ?></textarea>
                        </div>
                        <p class="payment-note">
                            <?php echo e(trans('plugins/payment::payment.please_provide_information')); ?> <a target="_blank" href="https://sslcommerz.com">SslCommerz</a>:
                        </p>
                        <div class="form-group mb-3">
                            <label class="text-title-field" for="<?php echo e(SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>_store_id"><?php echo e(__('Store ID')); ?></label>
                            <input type="text" class="next-input"
                                   name="payment_<?php echo e(SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>_store_id" id="<?php echo e(SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>_store_id"
                                   value="<?php echo e(get_payment_setting('store_id', SSLCOMMERZ_PAYMENT_METHOD_NAME)); ?>">
                        </div>
                        <div class="form-group mb-3">
                            <label class="text-title-field" for="<?php echo e(SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>_store_password"><?php echo e(__('Store Password (API/Secret key)')); ?></label>
                            <input type="password" class="next-input"
                                   name="payment_<?php echo e(SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>_store_password" id="<?php echo e(SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>_store_password"
                                   value="<?php echo e(get_payment_setting('store_password', SSLCOMMERZ_PAYMENT_METHOD_NAME)); ?>">
                        </div>
                        <div class="form-group mb-3">
                            <?php echo Form::hidden('payment_' . SSLCOMMERZ_PAYMENT_METHOD_NAME . '_mode', 1); ?>

                            <label class="next-label">
                                <input type="checkbox" value="0" name="payment_<?php echo e(SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>_mode" <?php if(setting('payment_' . SSLCOMMERZ_PAYMENT_METHOD_NAME . '_mode') == 0): ?> checked <?php endif; ?>>
                                <?php echo e(trans('plugins/payment::payment.sandbox_mode')); ?>

                            </label>
                        </div>

                        <?php echo apply_filters(PAYMENT_METHOD_SETTINGS_CONTENT, null, SSLCOMMERZ_PAYMENT_METHOD_NAME); ?>

                    </div>
                </div>
            </div>
            <div class="col-12 bg-white text-end">
                <button class="btn btn-warning disable-payment-item <?php if($sslcommerzStatus == 0): ?> hidden <?php endif; ?>"
                        type="button"><?php echo e(trans('plugins/payment::payment.deactivate')); ?></button>
                <button
                    class="btn btn-info save-payment-item btn-text-trigger-save <?php if($sslcommerzStatus == 1): ?> hidden <?php endif; ?>"
                    type="button"><?php echo e(trans('plugins/payment::payment.activate')); ?></button>
                <button
                    class="btn btn-info save-payment-item btn-text-trigger-update <?php if($sslcommerzStatus == 0): ?> hidden <?php endif; ?>"
                    type="button"><?php echo e(trans('plugins/payment::payment.update')); ?></button>
            </div>
            <?php echo Form::close(); ?>

        </td>
    </tr>
    </tbody>
</table>
<?php /**PATH /home/elitedesign/ecommerce12.elitedesign.com.bd/platform/plugins/sslcommerz/resources/views/settings.blade.php ENDPATH**/ ?>