<?php $paystackStatus = get_payment_setting('status', PAYSTACK_PAYMENT_METHOD_NAME); ?>
<table class="table payment-method-item">
    <tbody>
    <tr class="border-pay-row">
        <td class="border-pay-col"><i class="fa fa-theme-payments"></i></td>
        <td style="width: 20%;">
            <img class="filter-black" src="<?php echo e(url('vendor/core/plugins/paystack/images/paystack.png')); ?>"
                 alt="Paystack">
        </td>
        <td class="border-right">
            <ul>
                <li>
                    <a href="https://paystack.com" target="_blank"><?php echo e(__('Paystack')); ?></a>
                    <p><?php echo e(__('Customer can buy product and pay directly using Visa, Credit card via :name', ['name' => 'Paystack'])); ?></p>
                </li>
            </ul>
        </td>
    </tr>
    <tr class="bg-white">
        <td colspan="3">
            <div class="float-start" style="margin-top: 5px;">
                <div
                    class="payment-name-label-group <?php if(get_payment_setting('status', PAYSTACK_PAYMENT_METHOD_NAME) == 0): ?> hidden <?php endif; ?>">
                    <span class="payment-note v-a-t"><?php echo e(trans('plugins/payment::payment.use')); ?>:</span> <label
                        class="ws-nm inline-display method-name-label"><?php echo e(get_payment_setting('name', PAYSTACK_PAYMENT_METHOD_NAME)); ?></label>
                </div>
            </div>
            <div class="float-end">
                <a class="btn btn-secondary toggle-payment-item edit-payment-item-btn-trigger <?php if($paystackStatus == 0): ?> hidden <?php endif; ?>"><?php echo e(trans('plugins/payment::payment.edit')); ?></a>
                <a class="btn btn-secondary toggle-payment-item save-payment-item-btn-trigger <?php if($paystackStatus == 1): ?> hidden <?php endif; ?>"><?php echo e(trans('plugins/payment::payment.settings')); ?></a>
            </div>
        </td>
    </tr>
    <tr class="paypal-online-payment payment-content-item hidden">
        <td class="border-left" colspan="3">
            <?php echo Form::open(); ?>

            <?php echo Form::hidden('type', PAYSTACK_PAYMENT_METHOD_NAME, ['class' => 'payment_type']); ?>

            <div class="row">
                <div class="col-sm-6">
                    <ul>
                        <li>
                            <label><?php echo e(trans('plugins/payment::payment.configuration_instruction', ['name' => 'Paystack'])); ?></label>
                        </li>
                        <li class="payment-note">
                            <p><?php echo e(trans('plugins/payment::payment.configuration_requirement', ['name' => 'Paystack'])); ?>

                                :</p>
                            <ul class="m-md-l" style="list-style-type:decimal">
                                <li style="list-style-type:decimal">
                                    <a href="https://paystack.com" target="_blank">
                                        <?php echo e(__('Register an account on :name', ['name' => 'Paystack'])); ?>

                                    </a>
                                </li>
                                <li style="list-style-type:decimal">
                                    <p><?php echo e(__('After registration at :name, you will have Public & Secret keys', ['name' => 'Paystack'])); ?></p>
                                </li>
                                <li style="list-style-type:decimal">
                                    <p><?php echo e(__('Enter Public, Secret into the box in right hand')); ?></p>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="col-sm-6">
                    <div class="well bg-white">
                        <div class="form-group mb-3">
                            <label class="text-title-field"
                                   for="paystack_name"><?php echo e(trans('plugins/payment::payment.method_name')); ?></label>
                            <input type="text" class="next-input" name="payment_<?php echo e(PAYSTACK_PAYMENT_METHOD_NAME); ?>_name"
                                   id="paystack_name" data-counter="400"
                                   value="<?php echo e(get_payment_setting('name', PAYSTACK_PAYMENT_METHOD_NAME, __('Online payment via :name', ['name' => 'Paystack']))); ?>">
                        </div>

                        <div class="form-group mb-3">
                            <label class="text-title-field" for="payment_<?php echo e(PAYSTACK_PAYMENT_METHOD_NAME); ?>_description"><?php echo e(trans('core/base::forms.description')); ?></label>
                            <textarea class="next-input" name="payment_<?php echo e(PAYSTACK_PAYMENT_METHOD_NAME); ?>_description" id="payment_<?php echo e(PAYSTACK_PAYMENT_METHOD_NAME); ?>_description"><?php echo e(get_payment_setting('description', PAYSTACK_PAYMENT_METHOD_NAME, __('Payment with Paystack'))); ?></textarea>
                        </div>

                        <p class="payment-note">
                            <?php echo e(trans('plugins/payment::payment.please_provide_information')); ?> <a target="_blank" href="https://paystack.com/">Paystack</a>:
                        </p>
                        <div class="form-group mb-3">
                            <label class="text-title-field" for="<?php echo e(PAYSTACK_PAYMENT_METHOD_NAME); ?>_public"><?php echo e(__('Public Key')); ?></label>
                            <input type="text" class="next-input"
                                   name="payment_<?php echo e(PAYSTACK_PAYMENT_METHOD_NAME); ?>_public" id="<?php echo e(PAYSTACK_PAYMENT_METHOD_NAME); ?>_public"
                                   value="<?php echo e(get_payment_setting('public', PAYSTACK_PAYMENT_METHOD_NAME)); ?>" placeholder="pk_****">
                        </div>
                        <div class="form-group mb-3">
                            <label class="text-title-field" for="<?php echo e(PAYSTACK_PAYMENT_METHOD_NAME); ?>_secret"><?php echo e(__('Secret Key')); ?></label>
                            <input type="password" class="next-input" id="<?php echo e(PAYSTACK_PAYMENT_METHOD_NAME); ?>_secret"
                                   name="payment_<?php echo e(PAYSTACK_PAYMENT_METHOD_NAME); ?>_secret"
                                   value="<?php echo e(get_payment_setting('secret', PAYSTACK_PAYMENT_METHOD_NAME)); ?>" placeholder="sk_****">
                        </div>

                        <?php echo apply_filters(PAYMENT_METHOD_SETTINGS_CONTENT, null, PAYSTACK_PAYMENT_METHOD_NAME); ?>

                    </div>
                </div>
            </div>
            <div class="col-12 bg-white text-end">
                <button class="btn btn-warning disable-payment-item <?php if($paystackStatus == 0): ?> hidden <?php endif; ?>"
                        type="button"><?php echo e(trans('plugins/payment::payment.deactivate')); ?></button>
                <button
                    class="btn btn-info save-payment-item btn-text-trigger-save <?php if($paystackStatus == 1): ?> hidden <?php endif; ?>"
                    type="button"><?php echo e(trans('plugins/payment::payment.activate')); ?></button>
                <button
                    class="btn btn-info save-payment-item btn-text-trigger-update <?php if($paystackStatus == 0): ?> hidden <?php endif; ?>"
                    type="button"><?php echo e(trans('plugins/payment::payment.update')); ?></button>
            </div>
            <?php echo Form::close(); ?>

        </td>
    </tr>
    </tbody>
</table>
<?php /**PATH /home/elitede1/ecommerce12.elitedesign.com.bd/platform/plugins/paystack/resources/views/settings.blade.php ENDPATH**/ ?>