<?php $__env->startSection('content'); ?>
    <div class="ps-section__header">
        <h3><?php echo e(SeoHelper::getTitle()); ?></h3>
    </div>
    <div class="ps-section__content">
        <div class="table-responsive">
            <table class="table ps-table--wishlist">
                <thead>
                    <tr>
                        <th><?php echo e(__('ID number')); ?></th>
                        <th><?php echo e(__('Date')); ?></th>
                        <th><?php echo e(__('Total')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                <?php if(count($orders) > 0): ?>
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(get_order_code($order->id)); ?></td>
                            <td><?php echo e($order->created_at->translatedFormat('M d, Y h:m')); ?></td>
                            <td><?php echo e(format_price($order->amount)); ?></td>
                            <td><?php echo $order->status->toHtml(); ?></td>
                            <td>
                                <a class="ps-btn ps-btn--sm ps-btn--small" href="<?php echo e(route('customer.orders.view', $order->id)); ?>"><?php echo e(__('View')); ?></a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center"><?php echo e(__('No orders!')); ?></td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="ps-pagination">
            <?php echo $orders->links(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(Theme::getThemeNamespace() . '::views.ecommerce.customers.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/ecommerce2.elitedesign.com.bd/platform/themes/martfury/views/ecommerce/customers/orders/list.blade.php ENDPATH**/ ?>