<div class="form-group mb-3">
    <input type="hidden" name="products" value="<?php if($flashSale->id): ?><?php echo e(implode(',', array_filter($flashSale->products()->allRelatedIds()->toArray()))); ?><?php endif; ?>" />
    <div class="box-search-advance product">
        <div>
            <input type="text" class="next-input textbox-advancesearch" placeholder="<?php echo e(trans('plugins/ecommerce::products.search_products')); ?>" data-target="<?php echo e(route('products.get-list-product-for-search')); ?>">
        </div>
        <div class="panel panel-default">

        </div>
    </div>

    <div class="list-selected-products <?php if(!$products->count()): ?> hidden <?php endif; ?>">
        <div class="mt20"><label class="text-title-field"><?php echo e(trans('plugins/ecommerce::products.selected_products')); ?>:</label></div>
        <div class="table-wrapper p-none mt10 mb20 ps-relative">
            <table class="table-normal">
                <tbody>
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-product-id="<?php echo e($product->id); ?>">
                        <td class="width-60-px min-width-60-px" style="padding-top: 15px;">
                            <div class="wrap-img vertical-align-m-i">
                                <img class="thumb-image" src="<?php echo e(RvMedia::getImageUrl($product->image, 'thumb', false, RvMedia::getDefaultImage())); ?>" alt="<?php echo e($product->name); ?>"></div>
                        </td>
                        <td class="pl5 p-r5 min-width-200-px" style="padding-top: 15px;">
                            <a class="hover-underline pre-line" href="<?php echo e(route('products.edit', $product->id)); ?>" target="_blank"><?php echo e($product->name); ?> (<?php echo e(format_price($product->sale_price ?: $product->price)); ?>)</a>
                        </td>
                        <td class="pl5 p-r5 text-end width-20-px min-width-20-px" style="padding-top: 15px;">
                            <a href="#" class="btn-trigger-remove-selected-product" title="<?php echo e(trans('plugins/ecommerce::products.delete')); ?>" data-id="<?php echo e($product->id); ?>">
                                <i class="fa fa-times"></i>
                            </a>
                        </td>
                    </tr>
                    <tr data-product-id="<?php echo e($product->id); ?>">
                        <td colspan="3" style="border-top: none; overflow: hidden; <?php if(!$loop->last): ?> border-bottom: 1px solid #ececec; <?php endif; ?>">
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group mb-3">
                                        <label class="control-label required"><?php echo e(trans('plugins/ecommerce::products.price')); ?></label>
                                        <input type="text" class="form-control input-mask-number" data-thousands-separator="<?php echo e(EcommerceHelper::getThousandSeparatorForInputMask()); ?>" data-decimal-separator="<?php echo e(EcommerceHelper::getDecimalSeparatorForInputMask()); ?>" name="products_extra[<?php echo e($index); ?>][price]" value="<?php echo e($product->pivot->price); ?>">
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group mb-3">
                                        <label class="control-label required"><?php echo e(trans('plugins/ecommerce::products.quantity')); ?></label>
                                        <input type="text" class="form-control input-mask-number" data-thousands-separator="<?php echo e(EcommerceHelper::getThousandSeparatorForInputMask()); ?>" data-decimal-separator="<?php echo e(EcommerceHelper::getDecimalSeparatorForInputMask()); ?>" name="products_extra[<?php echo e($index); ?>][quantity]" value="<?php echo e($product->pivot->quantity); ?>">
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

</div>

<script id="selected_product_list_template" type="text/x-custom-template">
    <tr>
        <td class="width-60-px min-width-60-px">
            <div class="wrap-img vertical-align-m-i">
                <img class="thumb-image" src="__image__" alt="__name__" title="__name__">
            </div>
        </td>
        <td class="pl5 p-r5 min-width-200-px">
            <a class="hover-underline pre-line" href="__url__">__name__</a>
            <p class="type-subdued">__attributes__</p>
        </td>
        <td class="pl5 p-r5 text-end width-20-px min-width-20-px">
            <a href="#" class="btn-trigger-remove-selected-product" title="<?php echo e(trans('plugins/ecommerce::products.delete')); ?>" data-id="__id__">
                <i class="fa fa-times"></i>
            </a>
        </td>
    </tr>
    <tr data-product-id="__id__">
        <td colspan="3" style="border-top: none; border-bottom: 1px solid #ececec;">
            <div class="row">
                <div class="col-6">
                    <div class="form-group mb-3">
                        <label class="control-label required"><?php echo e(trans('plugins/ecommerce::products.price')); ?></label>
                        <input type="text" class="form-control input-mask-number" data-thousands-separator="<?php echo e(EcommerceHelper::getThousandSeparatorForInputMask()); ?>" data-decimal-separator="<?php echo e(EcommerceHelper::getDecimalSeparatorForInputMask()); ?>" name="products_extra[__index__][price]" value="__price__">
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group mb-3">
                        <label class="control-label required"><?php echo e(trans('plugins/ecommerce::products.quantity')); ?></label>
                        <input type="text" class="form-control" name="products_extra[__index__][quantity]" value="1">
                    </div>
                </div>
            </div>
        </td>
    </tr>
</script>
<?php /**PATH /home/elitedes/ecommerce2.elitedesign.com.bd/platform/plugins/ecommerce/resources/views/flash-sales/products.blade.php ENDPATH**/ ?>