<?php $__env->startSection('content'); ?>
    <?php Theme::set('pageName', __('Order information')) ?>
    <div class="card">
        <div class="card-header">
            <h3><?php echo e(__('Order information')); ?></h3>
        </div>
        <div class="card-body">
            <div class="customer-order-detail">
                <div class="row">
                    <div class="col-md-6">
                        <div class="order-slogan">
                            <?php
                                $logo = theme_option('logo_in_the_checkout_page') ?: theme_option('logo');
                            ?>
                            <?php if($logo): ?>
                                <img width="100" src="<?php echo e(RvMedia::getImageUrl($logo)); ?>"
                                     alt="<?php echo e(theme_option('site_title')); ?>">
                                <br/>
                            <?php endif; ?>
                            <?php echo e(setting('contact_address')); ?>

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="order-meta">
                            <p><span><?php echo e(__('Order number')); ?>:</span> <span
                                    class="order-detail-value"><?php echo e(get_order_code($order->id)); ?></span></p>
                            <span><?php echo e(__('Time')); ?>:</span> <span
                                class="order-detail-value"><?php echo e($order->created_at->translatedFormat('M d, Y h:m')); ?></span>
                        </div>
                    </div>
                </div>

                <h5><?php echo e(__('Order information')); ?></h5>
                <div class="col-12">
                    <span><?php echo e(__('Order status')); ?>:</span> <span
                        class="order-detail-value"><?php echo $order->status->toHtml(); ?></span>
                </div>

                <div class="col-12">
                    <span><?php echo e(__('Payment method')); ?>:</span> <span
                        class="order-detail-value"> <?php echo $order->payment->payment_channel->label(); ?> </span>
                    <br>
                    <span><?php echo e(__('Payment status')); ?>:</span> <span
                        class="order-detail-value"><?php echo $order->payment->status->toHtml(); ?></span>
                </div>

                <div class="col-12">
                    <span><?php echo e(__('Amount')); ?>:</span> <span
                        class="order-detail-value"> <?php echo e(format_price($order->amount)); ?> </span>
                </div>

                <?php if(EcommerceHelper::isTaxEnabled()): ?>
                    <div class="col-12">
                        <span><?php echo e(__('Tax')); ?>:</span> <span
                            class="order-detail-value"> <?php echo e(format_price($order->tax_amount)); ?> </span>
                    </div>
                <?php endif; ?>

                <div class="col-12">
                    <span><?php echo e(__('Shipping fee')); ?>:</span> <span
                        class="order-detail-value">  <?php echo e(format_price($order->shipping_amount)); ?> </span>
                </div>

                <div class="col-12">
                    <?php if($order->description): ?>
                        <span><?php echo e(__('Note')); ?>:</span> <span class="order-detail-value text-warning"><?php echo e($order->description); ?> </span>&nbsp;
                    <?php endif; ?>
                </div>
                <br>
                <h5><?php echo e(__('Customer information')); ?></h5>

                <div class="col-12">
                    <span><?php echo e(__('Full Name')); ?>:</span> <span class="order-detail-value"><?php echo e($order->address->name); ?> </span>
                </div>

                <div class="col-12">
                    <span><?php echo e(__('Phone')); ?>:</span> <span class="order-detail-value"><?php echo e($order->address->phone); ?> </span>
                </div>

                <div class="col-12">
                    <span><?php echo e(__('Address')); ?>:</span> <span
                        class="order-detail-value"> <?php echo e($order->address->address); ?> </span>
                </div>

                <div class="col-12">
                    <span><?php echo e(__('City')); ?>:</span> <span
                        class="order-detail-value"><?php echo e($order->address->city_name); ?> </span>
                </div>
                <div class="col-12">
                    <span><?php echo e(__('State')); ?>:</span> <span
                        class="order-detail-value"> <?php echo e($order->address->state_name); ?> </span>
                </div>
                <div class="col-12">
                    <span><?php echo e(__('Country')); ?>:</span> <span
                        class="order-detail-value"> <?php echo e($order->address->country_name); ?> </span>
                </div>
                <br>
                <h5><?php echo e(__('Order detail')); ?></h5>
                <div class="col-12">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                            <tr>
                                <th class="text-center">#</th>
                                <th class="text-center"><?php echo e(__('Image')); ?></th>
                                <th><?php echo e(__('Product')); ?></th>
                                <th class="text-center"><?php echo e(__('Amount')); ?></th>
                                <th class="text-right" style="width: 100px"><?php echo e(__('Quantity')); ?></th>
                                <th class="price text-right"><?php echo e(__('Total')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $order->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $orderProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $product = get_products([
                                    'condition' => [
                                        'ec_products.id' => $orderProduct->product_id,
                                    ],
                                    'take'   => 1,
                                    'select' => [
                                        'ec_products.id',
                                        'ec_products.images',
                                        'ec_products.name',
                                        'ec_products.price',
                                        'ec_products.sale_price',
                                        'ec_products.sale_type',
                                        'ec_products.start_date',
                                        'ec_products.end_date',
                                        'ec_products.sku',
                                        'ec_products.is_variation',
                                        'ec_products.status',
                                        'ec_products.order',
                                        'ec_products.created_at',
                                    ],
                                ]);

                                ?>
                                <tr>
                                    <td class="text-center"><?php echo e($key + 1); ?></td>
                                    <td class="text-center">
                                        <img src="<?php echo e(RvMedia::getImageUrl($product ? $product->image : null, 'thumb', false, RvMedia::getDefaultImage())); ?>" width="50" alt="<?php echo e($orderProduct->product_name); ?>">
                                    </td>
                                    <td>
                                        <?php echo e($orderProduct->product_name); ?> <?php if($product && $product->sku): ?> (<?php echo e($product->sku); ?>) <?php endif; ?>
                                        <?php if($product && $product->is_variation): ?>
                                            <p class="mb-0">
                                                <small><?php echo e($product->variation_attributes); ?></small>
                                            </p>
                                        <?php endif; ?>

                                        <?php if(!empty($orderProduct->options) && is_array($orderProduct->options)): ?>
                                            <?php $__currentLoopData = $orderProduct->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(!empty($option['key']) && !empty($option['value'])): ?>
                                                    <p class="mb-0"><small><?php echo e($option['key']); ?>: <strong> <?php echo e($option['value']); ?></strong></small></p>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                        <?php if(is_plugin_active('marketplace') && $product && $product->original_product->store->id): ?>
                                            <p class="d-block mb-0 sold-by">
                                                <small><?php echo e(__('Sold by')); ?>: <a href="<?php echo e($product->original_product->store->url); ?>"><?php echo e($product->original_product->store->name); ?></a>
                                                </small>
                                            </p>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(format_price($orderProduct->price)); ?></td>
                                    <td class="text-center"><?php echo e($orderProduct->qty); ?></td>
                                    <td class="money text-right">
                                        <strong>
                                            <?php echo e(format_price($orderProduct->price * $orderProduct->qty)); ?>

                                        </strong>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <?php if($order->shipment->id): ?>
                    <br>
                    <h5><?php echo e(__('Shipping Information:')); ?></h5>
                    <p><span class="d-inline-block"><?php echo e(__('Shipping Status')); ?></span>: <strong class="d-inline-block text-info"><?php echo BaseHelper::clean($order->shipment->status->toHtml()); ?></strong></p>
                    <?php if($order->shipment->shipping_company_name): ?>
                        <p><span class="d-inline-block"><?php echo e(__('Shipping Company Name')); ?></span>: <strong class="d-inline-block"><?php echo e($order->shipment->shipping_company_name); ?></strong></p>
                    <?php endif; ?>
                    <?php if($order->shipment->tracking_id): ?>
                        <p><span class="d-inline-block"><?php echo e(__('Tracking ID')); ?></span>: <strong class="d-inline-block"><?php echo e($order->shipment->tracking_id); ?></strong></p>
                    <?php endif; ?>
                    <?php if($order->shipment->tracking_link): ?>
                        <p><span class="d-inline-block"><?php echo e(__('Tracking Link')); ?></span>: <a
                                    href="<?php echo e($order->shipment->tracking_link); ?>" target="_blank"><strong class="d-inline-block"><?php echo e($order->shipment->tracking_link); ?></strong></a></p>
                    <?php endif; ?>
                    <?php if($order->shipment->note): ?>
                        <p><span class="d-inline-block"><?php echo e(__('Delivery Notes')); ?></span>: <strong class="d-inline-block"><?php echo e($order->shipment->note); ?></strong></p>
                    <?php endif; ?>
                    <?php if($order->shipment->estimate_date_shipped): ?>
                        <p><span class="d-inline-block"><?php echo e(__('Estimate Date Shipped')); ?></span>: <strong class="d-inline-block"><?php echo e($order->shipment->estimate_date_shipped); ?></strong></p>
                    <?php endif; ?>
                    <?php if($order->shipment->date_shipped): ?>
                        <p><span class="d-inline-block"><?php echo e(__('Date Shipped')); ?></span>: <strong class="d-inline-block"><?php echo e($order->shipment->date_shipped); ?></strong></p>
                    <?php endif; ?>
                <?php endif; ?>

                <br>
                <div>
                    <?php if($order->isInvoiceAvailable()): ?>
                        <a href="<?php echo e(route('customer.print-order', $order->id)); ?>" class="ps-btn ps-btn--sm mr-10"><i class="fa fa-download"></i> <?php echo e(__('Download invoice')); ?></a>
                    <?php endif; ?>
                    <?php if($order->canBeCanceled()): ?>
                        <a href="<?php echo e(route('customer.orders.cancel', $order->id)); ?>" onclick="return confirm('<?php echo e(__('Are you sure?')); ?>')" class="ps-btn ps-btn--sm ps-btn--danger"><?php echo e(__('Cancel order')); ?></a>
                    <?php endif; ?>
                    <?php if($order->canBeReturned()): ?>
                        <a href="<?php echo e(route('customer.order_returns.request_view', $order->id)); ?>"
                           class="ps-btn ps-btn--sm ps-btn--danger">
                            <?php echo e(__('Return Product(s)')); ?>

                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(Theme::getThemeNamespace() . '::views.ecommerce.customers.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/ecommerce2.elitedesign.com.bd/platform/themes/martfury/views/ecommerce/customers/orders/view.blade.php ENDPATH**/ ?>