<?php $__env->startSection('content'); ?>
    <?php echo Form::open(['route' => 'marketplace.vendor.become-vendor', 'class' => 'ps-form--account-setting', 'method' => 'POST']); ?>

        <div class="ps-form__header">
            <h3><?php echo e(SeoHelper::getTitle()); ?></h3>
        </div>
        <div class="ps-form__content">
            <input type="hidden" name="is_vendor" value="1">
            <div class="form-group">
                <label for="shop-name" class="required"><?php echo e(__('Shop Name')); ?></label>
                <input class="form-control" name="shop_name" id="shop-name" type="text" value="<?php echo e(old('shop_name')); ?>" placeholder="<?php echo e(__('Shop Name')); ?>">
                <?php if($errors->has('shop_name')): ?>
                    <span class="text-danger"><?php echo e($errors->first('shop_name')); ?></span>
                <?php endif; ?>
            </div>
            <div class="form-group shop-url-wrapper">
                <label for="shop-url" class="required float-left"><?php echo e(__('Shop URL')); ?></label>
                <span class="d-inline-block float-right shop-url-status"></span>
                <input class="form-control" name="shop_url" id="shop-url" type="text" value="<?php echo e(old('shop_url')); ?>" placeholder="<?php echo e(__('Shop URL')); ?>" data-url="<?php echo e(route('public.ajax.check-store-url')); ?>">
                <?php if($errors->has('shop_url')): ?>
                    <span class="text-danger"><?php echo e($errors->first('shop_url')); ?></span>
                <?php endif; ?>
                <span class="d-inline-block"><small data-base-url="<?php echo e(route('public.store', '')); ?>"><?php echo e(route('public.store', (string)old('shop_url', ''))); ?></small></span>
            </div>
            <div class="form-group">
                <label for="shop-phone" class="required"><?php echo e(__('Phone Number')); ?></label>
                <input class="form-control" name="shop_phone" id="shop-phone" type="text" value="<?php echo e(old('shop_phone')); ?>" placeholder="<?php echo e(__('Shop phone')); ?>">
                <?php if($errors->has('shop_phone')): ?>
                    <span class="text-danger"><?php echo e($errors->first('shop_phone')); ?></span>
                <?php endif; ?>
            </div>

            <div class="form-group text-center">
                <div class="form-group submit">
                    <button class="ps-btn"><?php echo e(__('Register')); ?></button>
                </div>
            </div>
        </div>
    <?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make(Theme::getThemeNamespace() . '::views.ecommerce.customers.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/ecommerce2.elitedesign.com.bd/platform/themes/martfury/views/marketplace/become-vendor.blade.php ENDPATH**/ ?>