<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-3 right-sidebar">
        <div class="widget meta-boxes">
            <div class="widget-title">
                <h4><label for="status" class="control-label" aria-required="true"><?php echo e(trans('plugins/marketplace::revenue.store_information')); ?></label></h4>
            </div>
            <div class="widget-body">
                <div class="form-group mb-3">
                    <div class="border-bottom py-2">
                        <div class="text-center">
                            <div class="text-center">
                                <img src="<?php echo e(RvMedia::getImageUrl($store->logo, 'thumb', false, RvMedia::getDefaultImage())); ?>" width="120" class="mb-2" style="border-radius: 50%" alt="avatar" />
                            </div>
                            <div class="text-center">
                                <strong>
                                    <a href="<?php echo e($store->url); ?>" target="_blank"><?php echo e($store->name); ?> <i class="fas fa-external-link-alt"></i></a>
                                </strong>
                            </div>
                        </div>
                    </div>
                    <div class="py-2">
                        <span><?php echo e(trans('plugins/marketplace::revenue.vendor_name')); ?>:</span>
                        <strong><a href="<?php echo e(route('customers.edit', $customer->id)); ?>" target="_blank"><?php echo e($customer->name); ?> <i class="fas fa-external-link-alt"></i></a></strong>
                    </div>
                    <div class="py-2">
                        <span><?php echo e(trans('plugins/marketplace::revenue.balance')); ?>:</span>
                        <strong class="vendor-balance"><?php echo e(format_price($customer->balance)); ?> <a href="#" data-bs-toggle="modal" data-bs-target="#update-balance-modal"><i class="fa fa-edit"></i></a> </strong>
                    </div>
                    <div>
                        <span><?php echo e(trans('plugins/marketplace::revenue.products')); ?>:</span>
                        <strong><?php echo e(number_format($store->products()->count())); ?></strong>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-9">
        <div class="widget meta-boxes">
            <div class="widget-title">
                <h4><label for="status" class="control-label" aria-required="true"><?php echo e(trans('plugins/marketplace::revenue.statements')); ?></label></h4>
                <a href="#" class="me-2 d-inline-block float-end" data-bs-toggle="modal" data-bs-target="#update-balance-modal">
                    <small><i class="fa fa-edit"></i> <?php echo e(trans('plugins/marketplace::revenue.update_balance')); ?></small>
                </a>
            </div>
            <div class="widget-body">
                <?php echo $table->renderTable(); ?>

            </div>
        </div>
    </div>

    <?php echo Form::modalAction('update-balance-modal',
        trans('plugins/marketplace::revenue.update_balance_title'),
        'info',
        view('plugins/marketplace::stores.balance-form', compact('store', 'customer'))->render(),
        'confirm-update-amount-button',
        trans('core/base::tables.submit'),
        'modal-md'); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(BaseHelper::getAdminMasterLayoutTemplate(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/ecommerce2.elitedesign.com.bd/platform/plugins/marketplace/resources/views/stores/index.blade.php ENDPATH**/ ?>