<div class="ps-my-account">
    <div class="container">
        <form class="ps-form--account ps-tab-root" method="POST" action="<?php echo e(route('customer.register.post')); ?>">
            <?php echo csrf_field(); ?>
            <div class="ps-form__content">
                <h4><?php echo e(__('Register An Account')); ?></h4>
                <div class="form-group">
                    <input class="form-control" name="name" id="txt-name" type="text" value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(__('Your Name')); ?>">
                    <?php if($errors->has('name')): ?>
                        <span class="text-danger small"><?php echo e($errors->first('name')); ?></span>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <input class="form-control" name="email" id="txt-email" type="email" value="<?php echo e(old('email')); ?>" autocomplete="email" placeholder="<?php echo e(__('Your Email')); ?>">
                    <?php if($errors->has('email')): ?>
                        <span class="text-danger small"><?php echo e($errors->first('email')); ?></span>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <input class="form-control" type="password" name="password" id="txt-password" autocomplete="new-password" placeholder="<?php echo e(__('Password')); ?>">
                    <?php if($errors->has('password')): ?>
                        <span class="text-danger small"><?php echo e($errors->first('password')); ?></span>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <input class="form-control" type="password" name="password_confirmation" id="txt-password-confirmation" autocomplete="new-password" placeholder="<?php echo e(__('Password Confirmation')); ?>">
                    <?php if($errors->has('password_confirmation')): ?>
                        <span class="text-danger small"><?php echo e($errors->first('password_confirmation')); ?></span>
                    <?php endif; ?>
                </div>
                <?php if(is_plugin_active('marketplace')): ?>
                    <div class="show-if-vendor" <?php if(old('is_vendor') == 0): ?> style="display: none" <?php endif; ?>>
                        <div class="form-group">
                            <label for="shop-name" class="required"><?php echo e(__('Shop Name')); ?></label>
                            <input class="form-control" name="shop_name" id="shop-name" type="text" value="<?php echo e(old('shop_name')); ?>" placeholder="<?php echo e(__('Shop Name')); ?>">
                            <?php if($errors->has('shop_name')): ?>
                                <span class="text-danger small"><?php echo e($errors->first('shop_name')); ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="form-group shop-url-wrapper">
                            <label for="shop-url" class="required float-left"><?php echo e(__('Shop URL')); ?></label>
                            <span class="d-inline-block float-right shop-url-status"></span>
                            <input class="form-control" name="shop_url" id="shop-url" type="text" value="<?php echo e(old('shop_url')); ?>" placeholder="<?php echo e(__('Shop URL')); ?>" data-url="<?php echo e(route('public.ajax.check-store-url')); ?>">
                            <?php if($errors->has('shop_url')): ?>
                                <span class="text-danger small"><?php echo e($errors->first('shop_url')); ?></span>
                            <?php else: ?>
                                <span class="d-inline-block"><small data-base-url="<?php echo e(route('public.store', '')); ?>"><?php echo e(route('public.store', (string)old('shop_url'))); ?></small></span>
                            <?php endif; ?>
                        </div>
                        <div class="form-group">
                            <label for="shop-phone" class="required"><?php echo e(__('Phone Number')); ?></label>
                            <input class="form-control" name="shop_phone" id="shop-phone" type="text" value="<?php echo e(old('shop_phone')); ?>" placeholder="<?php echo e(__('Shop phone')); ?>">
                            <?php if($errors->has('shop_phone')): ?>
                                <span class="text-danger small"><?php echo e($errors->first('shop_phone')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="form-group user-role">
                        <p>
                            <label>
                                <input type="radio" name="is_vendor" value="0" <?php if(old('is_vendor') == 0): ?> checked="checked" <?php endif; ?>>
                                <span class="d-inline-block">
                                    <?php echo e(__('I am a customer')); ?>

                                </span>
                            </label>
                        </p>
                        <p>
                            <label>
                                <input type="radio" name="is_vendor" value="1" <?php if(old('is_vendor') == 1): ?> checked="checked" <?php endif; ?>>
                                <span class="d-inline-block">
                                    <?php echo e(__('I am a vendor')); ?>

                                </span>
                            </label>
                        </p>
                    </div>
                <?php endif; ?>
                <div class="form-group">
                    <p><?php echo e(__('Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our privacy policy.')); ?></p>
                </div>
                <div class="form-group">
                    <div class="ps-checkbox">
                        <input type="hidden" name="agree_terms_and_policy" value="0">
                        <input class="form-control" type="checkbox" name="agree_terms_and_policy" id="agree-terms-and-policy" value="1" <?php if(old('agree_terms_and_policy') == 1): ?> checked <?php endif; ?>>
                        <label for="agree-terms-and-policy"><?php echo e(__('I agree to terms & Policy.')); ?></label>
                    </div>
                    <?php if($errors->has('agree_terms_and_policy')): ?>
                        <span class="text-danger small"><?php echo e($errors->first('agree_terms_and_policy')); ?></span>
                    <?php endif; ?>
                </div>

                <?php if(is_plugin_active('captcha') && setting('enable_captcha') && get_ecommerce_setting('enable_recaptcha_in_register_page', 0)): ?>
                    <div class="form-group">
		                <?php echo Captcha::display(); ?>

                    </div>
                <?php endif; ?>

                <div class="form-group submit">
                    <button class="ps-btn ps-btn--fullwidth" type="submit"><?php echo e(__('Sign up')); ?></button>
                </div>

                <div class="form-group">
                    <p class="text-center"><?php echo e(__('Already have an account?')); ?> <a href="<?php echo e(route('customer.login')); ?>" class="d-inline-block"><?php echo e(__('Log in')); ?></a></p>
                </div>
            </div>
            <div class="ps-form__footer">
                <?php echo apply_filters(BASE_FILTER_AFTER_LOGIN_OR_REGISTER_FORM, null, \Botble\Ecommerce\Models\Customer::class); ?>

            </div>
        </form>
    </div>
</div>

<?php /**PATH /home/elitedesignbd/ecommerce11.elitedesign.com.bd/platform/themes/martfury/views/ecommerce/customers/register.blade.php ENDPATH**/ ?>