<?php
    $value = count($values) ? ($values[0] ?? []) : [];
    $isDefaultLanguage = ! defined('LANGUAGE_ADVANCED_MODULE_SCREEN_NAME') ||
        ! request()->input('ref_lang') ||
        request()->input('ref_lang') == Language::getDefaultLocaleCode();
?>

<div class="col-md-12 option-setting-tab" <?php if($isDefaultLanguage): ?> style="display: none" <?php endif; ?> id="option-setting-multiple">
    <table class="table table-bordered setting-option">
        <thead>
        <tr>
            <?php if($isDefaultLanguage): ?>
                <th scope="col">#</th>
            <?php endif; ?>
            <th scope="col"><?php echo e(trans('plugins/ecommerce::product-option.label')); ?></th>
            <?php if($isDefaultLanguage): ?>
                <th scope="col"><?php echo e(trans('plugins/ecommerce::product-option.price')); ?></th>
                <th scope="col" colspan="2"><?php echo e(trans('plugins/ecommerce::product-option.price_type')); ?></th>
            <?php endif; ?>
        </tr>
        </thead>
        <tbody class="option-sortable">
        <?php if($values->count()): ?>
            <?php $__currentLoopData = $values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="option-row ui-state-default" data-index="<?php echo e($key); ?>">
                    <input type="hidden" name="options[<?php echo e($key); ?>][id]" value="<?php echo e($value->id); ?>">
                    <input type="hidden" name="options[<?php echo e($key); ?>][order]" value="<?php echo e($value->order !== 9999 ? $value->order : $key); ?>">
                    <?php if($isDefaultLanguage): ?>
                        <td class="text-center">
                            <i class="fa fa-sort"></i>
                        </td>
                    <?php endif; ?>
                    <td>
                        <input type="text" class="form-control option-label" name="options[<?php echo e($key); ?>][option_value]" value="<?php echo e($value->option_value); ?>"
                               placeholder="<?php echo e(trans('plugins/ecommerce::product-option.label_placeholder')); ?>"/>
                    </td>
                    <?php if($isDefaultLanguage): ?>
                        <td>
                            <input type="number" class="form-control affect_price" name="options[<?php echo e($key); ?>][affect_price]" value="<?php echo e($value->affect_price); ?>"
                                   placeholder="<?php echo e(trans('plugins/ecommerce::product-option.affect_price_label')); ?>"/>
                        </td>
                        <td>
                            <select class="form-select affect_type" name="options[<?php echo e($key); ?>][affect_type]">
                                <option <?php echo e($value->affect_type == 0 ? 'selected' : ''); ?> value="0"><?php echo e(trans('plugins/ecommerce::product-option.fixed')); ?></option>
                                <option <?php echo e($value->affect_type == 1 ? 'selected' : ''); ?> value="1"><?php echo e(trans('plugins/ecommerce::product-option.percent')); ?></option>
                            </select>
                        </td>
                        <td style="width: 50px">
                            <button class="btn btn-default remove-row" data-index="0"><i class="fa fa-trash"></i></button>
                        </td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr class="option-row" data-index="0">
                <?php if($isDefaultLanguage): ?>
                    <td class="text-center">
                        <i class="fa fa-sort"></i>
                    </td>
                <?php endif; ?>
                <td>
                    <input type="text" class="form-control option-label" name="options[0][option_value]" value=""
                           placeholder="<?php echo e(trans('plugins/ecommerce::product-option.label_placeholder')); ?>"/>
                </td>
                <?php if($isDefaultLanguage): ?>
                    <td>
                        <input type="number" class="form-control affect_price" name="options[0][affect_price]" value=""
                               placeholder="<?php echo e(trans('plugins/ecommerce::product-option.affect_price_label')); ?>"/>
                    </td>
                    <td>
                        <select class="form-select affect_type" name="options[0][affect_type]">
                            <option value="0"><?php echo e(trans('plugins/ecommerce::product-option.fixed')); ?></option>
                            <option value="1"><?php echo e(trans('plugins/ecommerce::product-option.percent')); ?></option>
                        </select>
                    </td>
                    <td style="width: 50px">
                        <button class="btn btn-default remove-row" data-index="0"><i class="fa fa-trash"></i></button>
                    </td>
                <?php endif; ?>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
    <?php if($isDefaultLanguage): ?>
        <button type="button" class="btn btn-info mt-3 add-new-row" id="add-new-row"><?php echo e(trans('plugins/ecommerce::product-option.add_new_row')); ?></button>
    <?php endif; ?>
</div>

<?php if($isDefaultLanguage): ?>
    <div class="empty"><?php echo e(trans('plugins/ecommerce::product-option.please_choose_option_type')); ?></div>
<?php endif; ?>
<?php /**PATH /home/elitedesign/ecommerce12.elitedesign.com.bd/platform/plugins/ecommerce/resources/views/product-options/option-admin.blade.php ENDPATH**/ ?>