<?php if($orderReturn): ?>
    <div class="customer-order-detail">
        <div class="row">
            <div class="col-md-6">
                <h5><?php echo e(__('Return Product(s) Information')); ?></h5>
                <p>
                    <span><?php echo e(__('Request number')); ?>: </span>
                    <strong><?php echo e($orderReturn->code); ?></strong>
                </p>
                <p>
                    <span><?php echo e(__('Order Id')); ?>: </span>
                    <strong><?php echo e($orderReturn->order->code); ?></strong>
                </p>
            </div>
            <div class="col-md-6">
                <p>
                    <span><?php echo e(__('Time')); ?>: </span>
                    <strong class="text-info"><?php echo e($orderReturn->created_at->translatedFormat('h:m d/m/Y')); ?></strong>
                </p>
                <p>
                    <span><?php echo e(__('Status')); ?>: </span>
                    <strong class="text-warning"><?php echo e($orderReturn->return_status->label()); ?></strong>
                </p>
                <?php if(! EcommerceHelper::allowPartialReturn()): ?>
                    <p>
                        <span><?php echo e(__('Reason')); ?>: </span>
                        <strong class="text-warning"><?php echo e($orderReturn->reason->label()); ?></strong>
                    </p>
                <?php endif; ?>
            </div>
        </div>
        <br/>
        <h5><?php echo e(__('Return items')); ?></h5>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover align-middle">
                        <thead>
                            <tr>
                                <th class="text-center">#</th>
                                <th class="text-center"><?php echo e(__('Image')); ?></th>
                                <th><?php echo e(__('Product')); ?></th>
                                <th class="text-center"><?php echo e(__('Quantity')); ?></th>
                                <th class="text-center"><?php echo e(__('Refund amount')); ?></th>
                                <?php if(EcommerceHelper::allowPartialReturn()): ?>
                                    <th class="text-center"><?php echo e(__('Reason')); ?></th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $orderReturn->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $orderProduct = $item->orderProduct;
                                ?>
                                <tr>
                                    <td class="text-center"><?php echo e($loop->iteration); ?></td>
                                    <td class="text-center">
                                        <img src="<?php echo e(RvMedia::getImageUrl($item->product_image, 'thumb', false, RvMedia::getDefaultImage())); ?>"
                                            alt="<?php echo e($item->product_name); ?>" width="50">
                                    </td>
                                    <td>
                                        <?php echo e($item->product_name); ?>

                                        <?php if($orderProduct): ?>
                                            <?php if($sku = Arr::get($orderProduct->options, 'sku')): ?>
                                                (<?php echo e($sku); ?>)
                                            <?php endif; ?>
                                            <?php if($attributes = Arr::get($orderProduct->options, 'attributes')): ?>
                                                <p>
                                                    <small><?php echo e($attributes); ?></small>
                                                </p>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <strong class="text-info"><?php echo e(number_format($item->qty)); ?></strong>
                                    </td>
                                    <td class="text-center">
                                        <strong class="text-info"><?php echo e(format_price($item->refund_amount)); ?></strong>
                                    </td>
                                    <?php if(EcommerceHelper::allowPartialReturn()): ?>
                                        <td class="text-center">
                                            <span class="text-warning"><?php echo e($item->reason->label()); ?></span>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php else: ?>
    <p class="text-center text-danger"><?php echo e(__('Order Return Request not found!')); ?></p>
<?php endif; ?>
<?php /**PATH /home/elitede1/ecommerce12.elitedesign.com.bd/platform/plugins/ecommerce/resources/views/themes/includes/order-return-detail.blade.php ENDPATH**/ ?>