<?php $__env->startSection('content'); ?>
    <?php echo Form::open(['class' => 'form-import-data', 'files' => 'true']); ?>

        <div class="row justify-content-center">
            <div class="col-xxl-6 col-xl-8 col-lg-10 col-12">
                <div class="widget meta-boxes">
                    <div class="widget-title pl-2">
                        <h4><?php echo e(trans('plugins/ecommerce::bulk-import.menu')); ?></h4>
                    </div>
                    <div class="widget-body">
                        <div class="form-group mb-3 <?php if($errors->has('type')): ?> has-error <?php endif; ?>">
                            <label class="control-label required" for="type">
                                <?php echo e(trans('plugins/ecommerce::bulk-import.import_types.name')); ?>

                            </label>
                            <?php echo Form::customSelect('type', [
                                'all' => trans('plugins/ecommerce::bulk-import.import_types.all'),
                                'products' => trans('plugins/ecommerce::bulk-import.import_types.products'),
                                'variations' => trans('plugins/ecommerce::bulk-import.import_types.variations'),
                            ], null, ['required' => true]); ?>

                            <?php echo Form::error('type', $errors); ?>

                        </div>
                        <div class="form-group mb-3 <?php if($errors->has('file')): ?> has-error <?php endif; ?>">
                            <label class="control-label required" for="input-group-file">
                                <?php echo e(trans('plugins/ecommerce::bulk-import.choose_file')); ?>

                            </label>
                            <?php echo Form::file('file', [
                                'id' => 'input-group-file',
                                'class' => 'form-control',
                                'required' => true,
                                'aria-describedby' => 'input-group-addon',
                            ]); ?>

                            <label class="d-block mt-1 help-block" for="input-group-file">
                                <?php echo e(trans('plugins/ecommerce::bulk-import.choose_file_with_mime', ['types' =>  implode(', ', config('plugins.ecommerce.general.bulk-import.mimes', []))])); ?>

                            </label>

                            <?php echo Form::error('file', $errors); ?>

                            <div class="mt-3 text-center p-2 border bg-light">
                                <a href="#" class="download-template"
                                    data-url="<?php echo e(route('ecommerce.bulk-import.download-template')); ?>"
                                    data-extension="csv"
                                    data-filename="template_products_import.csv"
                                    data-downloading="<i class='fas fa-spinner fa-spin'></i> <?php echo e(trans('plugins/ecommerce::bulk-import.downloading')); ?>">
                                    <i class="fas fa-file-csv"></i>
                                    <?php echo e(trans('plugins/ecommerce::bulk-import.download-csv-file')); ?>

                                </a> &nbsp; | &nbsp;
                                <a href="#" class="download-template"
                                    data-url="<?php echo e(route('ecommerce.bulk-import.download-template')); ?>"
                                    data-extension="xlsx"
                                    data-filename="template_products_import.xlsx"
                                    data-downloading="<i class='fas fa-spinner fa-spin'></i> <?php echo e(trans('plugins/ecommerce::bulk-import.downloading')); ?>">
                                    <i class="fas fa-file-excel"></i>
                                    <?php echo e(trans('plugins/ecommerce::bulk-import.download-excel-file')); ?>

                                </a>
                            </div>
                        </div>
                        <div class="form-group mb-3 d-grid">
                            <button type="submit" class="btn btn-info"
                                    data-choose-file="<?php echo e(trans('plugins/ecommerce::bulk-import.please_choose_the_file')); ?>"
                                    data-loading-text="<?php echo e(trans('plugins/ecommerce::bulk-import.loading_text')); ?>"
                                    data-complete-text="<?php echo e(trans('plugins/ecommerce::bulk-import.imported_successfully')); ?>"
                                    id="input-group-addon">
                                <?php echo e(trans('plugins/ecommerce::bulk-import.start_import')); ?>

                            </button>
                        </div>
                    </div>
                </div>
                <div class="hidden main-form-message">
                    <p id="imported-message"></p>
                    <div class="show-errors hidden">
                        <h3 class="text-warning text-center"><?php echo e(trans('plugins/ecommerce::bulk-import.failures')); ?></h3>
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                  <th scope="col">#<?php echo e(trans('plugins/ecommerce::bulk-import.row')); ?></th>
                                  <th scope="col"><?php echo e(trans('plugins/ecommerce::bulk-import.attribute')); ?></th>
                                  <th scope="col"><?php echo e(trans('plugins/ecommerce::bulk-import.errors')); ?></th>
                                </tr>
                            </thead>
                            <tbody id="imported-listing">

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    <?php echo Form::close(); ?>


    <div class="widget meta-boxes">
        <div class="widget-title pl-2">
            <h4 class="text-info"><?php echo e(trans('plugins/ecommerce::bulk-import.template')); ?></h4>
        </div>
        <div class="widget-body">
            <div class="table-responsive">
                <table class="table text-start table-striped table-bordered">
                    <thead>
                        <tr>
                            <?php $__currentLoopData = $headings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $heading): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <th><?php echo e($heading); ?></th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <?php $__currentLoopData = $headings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $h): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td><?php echo e(Arr::get($product, $k)); ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="widget meta-boxes mt-4">
        <div class="widget-title pl-2">
            <h4 class="text-info"><?php echo e(trans('plugins/ecommerce::bulk-import.rules')); ?></h4>
        </div>
        <div class="widget-body">
            <table class="table text-start table-bordered">
                <thead>
                    <tr>
                        <th scope="col"><?php echo e(trans('plugins/ecommerce::bulk-import.column')); ?></th>
                        <th scope="col"><?php echo e(trans('plugins/ecommerce::bulk-import.rules')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th scope="row"><?php echo e(Arr::get($headings, $k)); ?></th>
                            <td>(<?php echo e($rule); ?>)</td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <script type="text/x-custom-template" id="failure-template">
        <tr>
            <td scope="row">__row__</td>
            <td>__attribute__</td>
            <td>__errors__</td>
        </tr>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(BaseHelper::getAdminMasterLayoutTemplate(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/ecommerce2.elitedesign.com.bd/platform/plugins/ecommerce/resources/views/bulk-import/index.blade.php ENDPATH**/ ?>