<?php $__env->startSection('content'); ?>
    <div class="section-header">
        <h3><?php echo e(SeoHelper::getTitle()); ?></h3>
    </div>
    <div class="section-content">
        <div class="table-responsive">
            <table class="table table-striped align-middle">
                <thead>
                    <tr>
                        <th><?php echo e(__('Image')); ?></th>
                        <th><?php echo e(__('Product Name')); ?></th>
                        <th class="text-center"><?php echo e(__('Times downloaded')); ?></th>
                        <th><?php echo e(__('Ordered at')); ?></th>
                        <th><?php echo e(__('Action')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($orderProducts) > 0): ?>
                        <?php $__currentLoopData = $orderProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <img src="<?php echo e(RvMedia::getImageUrl($orderProduct->product_image, 'thumb', false, RvMedia::getDefaultImage())); ?>" width="50" alt="<?php echo e($orderProduct->product_name); ?>">
                                </td>
                                <td>
                                    <?php echo e($orderProduct->product_name); ?>

                                    <?php if($sku = Arr::get($orderProduct->options, 'sku')): ?> (<?php echo e($sku); ?>) <?php endif; ?>
                                    <?php if($attributes = Arr::get($orderProduct->options, 'attributes')): ?>
                                        <p class="mb-0">
                                            <small><?php echo e($attributes); ?></small>
                                        </p>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <span><?php echo e($orderProduct->times_downloaded); ?></span>
                                </td>
                                <td><?php echo e($orderProduct->created_at->translatedFormat('M d, Y h:m')); ?></td>
                                <td>
                                    <a class="btn btn-primary btn-sm" href="<?php echo e(route('customer.downloads.product', $orderProduct->id)); ?>">
                                        <i class="icon icon-download"></i>
                                        <span><?php echo e(__('Download')); ?></span>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center"><?php echo e(__('No digital products!')); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="pagination">
            <?php echo $orderProducts->links(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(EcommerceHelper::viewPath('customers.master'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/ecommerce2.elitedesign.com.bd/platform/plugins/ecommerce/resources/views/themes/customers/orders/downloads.blade.php ENDPATH**/ ?>