<?php if($products->count()): ?>
    <div class="panel__content row py-2 mx-0">
        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-12 py-2">
                <div class="row">
                    <div class="col-3 product__thumbnail">
                        <a href="<?php echo e($product->url); ?>" class="img-fluid-eq">
                            <div class="img-fluid-eq__dummy dummy-mt-8"></div>
                            <div class="img-fluid-eq__wrap">
                                <img class="product-thumbnail__img"
                                    src="<?php echo e(RvMedia::getImageUrl($product->image, 'small', false, RvMedia::getDefaultImage())); ?>"
                                    alt="<?php echo e($product->name); ?>">
                            </div>
                        </a>
                    </div>
                    <div class="col-9 product__content">
                        <a class="product__title" href="<?php echo e($product->url); ?>"><?php echo BaseHelper::clean($product->name); ?></a>
                        <?php if(EcommerceHelper::isReviewEnabled() && $product->reviews_avg > 0): ?>
                            <?php echo Theme::partial('star-rating', ['avg' => $product->reviews_avg, 'count' => $product->reviews_count]); ?>

                        <?php endif; ?>
                        <?php echo Theme::partial('ecommerce.product-price', compact('product')); ?>

                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php if($products->hasMorePages() && $products->nextPageUrl()): ?>
            <div class="col-12 text-center loadmore-container">
                <button class="btn loadmore position-relative mx-auto" href="<?php echo e($products->withQueryString()->nextPageUrl()); ?>">
                    <span><?php echo e(__('Load more')); ?></span>
                    <span class="svg-icon ms-1">
                        <svg>
                            <use href="#svg-icon-chevron-down" xlink:href="#svg-icon-chevron-down"></use>
                        </svg>
                    </span>
                </button>
            </div>
        <?php endif; ?>
    </div>
    <div class="panel__footer text-center">
        <a href="<?php echo e(route('public.products', $queries)); ?>"><?php echo e(__('See all results')); ?></a>
    </div>
<?php else: ?>
    <div class="panel__content row py-2 mx-0">
        <div class="text-center"><?php echo e(__('No products found.')); ?></div>
    </div>
<?php endif; ?>
<?php /**PATH /home/elitedesign/ecommerce13.elitedesign.com.bd/platform/themes/farmart/partials/ajax-search-results.blade.php ENDPATH**/ ?>