<?php $razorpayStatus = get_payment_setting('status', RAZORPAY_PAYMENT_METHOD_NAME); ?>
<table class="table payment-method-item">
    <tbody>
    <tr class="border-pay-row">
        <td class="border-pay-col"><i class="fa fa-theme-payments"></i></td>
        <td style="width: 20%;">
            <img class="filter-black" src="<?php echo e(url('vendor/core/plugins/razorpay/images/razorpay.svg')); ?>"
                 alt="Razorpay">
        </td>
        <td class="border-right">
            <ul>
                <li>
                    <a href="https://razorpay.com" target="_blank">Razorpay</a>
                    <p><?php echo e(__('Customer can buy product and pay directly using Visa, Credit card via Razorpay')); ?></p>
                </li>
            </ul>
        </td>
    </tr>
    <tr class="bg-white">
        <td colspan="3">
            <div class="float-start" style="margin-top: 5px;">
                <div
                    class="payment-name-label-group <?php if(get_payment_setting('status', RAZORPAY_PAYMENT_METHOD_NAME) == 0): ?> hidden <?php endif; ?>">
                    <span class="payment-note v-a-t"><?php echo e(trans('plugins/payment::payment.use')); ?>:</span> <label
                        class="ws-nm inline-display method-name-label"><?php echo e(get_payment_setting('name', RAZORPAY_PAYMENT_METHOD_NAME)); ?></label>
                </div>
            </div>
            <div class="float-end">
                <a class="btn btn-secondary toggle-payment-item edit-payment-item-btn-trigger <?php if($razorpayStatus == 0): ?> hidden <?php endif; ?>"><?php echo e(trans('plugins/payment::payment.edit')); ?></a>
                <a class="btn btn-secondary toggle-payment-item save-payment-item-btn-trigger <?php if($razorpayStatus == 1): ?> hidden <?php endif; ?>"><?php echo e(trans('plugins/payment::payment.settings')); ?></a>
            </div>
        </td>
    </tr>
    <tr class="paypal-online-payment payment-content-item hidden">
        <td class="border-left" colspan="3">
            <?php echo Form::open(); ?>

            <?php echo Form::hidden('type', RAZORPAY_PAYMENT_METHOD_NAME, ['class' => 'payment_type']); ?>

            <div class="row">
                <div class="col-sm-6">
                    <ul>
                        <li>
                            <label><?php echo e(trans('plugins/payment::payment.configuration_instruction', ['name' => 'Razorpay'])); ?></label>
                        </li>
                        <li class="payment-note">
                            <p><?php echo e(trans('plugins/payment::payment.configuration_requirement', ['name' => 'Razorpay'])); ?>

                                :</p>
                            <ul class="m-md-l" style="list-style-type:decimal">
                                <li style="list-style-type:decimal">
                                    <a href="https://razorpay.com" target="_blank">
                                        <?php echo e(__('Register an account on Razorpay')); ?>

                                    </a>
                                </li>
                                <li style="list-style-type:decimal">
                                    <p><?php echo e(__('After registration at :name, you will have Client ID, Client Secret', ['name' => 'Razorpay'])); ?></p>
                                </li>
                                <li style="list-style-type:decimal">
                                    <p><?php echo e(__('Enter Client ID, Secret into the box in right hand')); ?></p>
                                </li>
                                <li style="list-style-type:decimal">
                                    <p><?php echo BaseHelper::clean("Then you need to create a new webhook. To create a webhook, go to <strong>Account Settings</strong> -> <strong>API keys</strong> -> <strong>Webhooks</strong> and paste the below url to <strong>Webhook URL</strong> field. At <strong>Active Events</strong> field, check to <strong>Payment Events</strong> and <strong>Order Events</strong> checkbox."); ?></p>
                                    <p>
                                        <code><?php echo e(route('payments.razorpay.webhook')); ?></code>
                                    </p>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="col-sm-6">
                    <div class="well bg-white">
                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '4d69f58c2cfdff5049123ae0e3ca253b::text-input','data' => ['name' => 'payment_' . RAZORPAY_PAYMENT_METHOD_NAME . '_name','label' => trans('plugins/payment::payment.method_name'),'value' => get_payment_setting('name', RAZORPAY_PAYMENT_METHOD_NAME, __('Online payment via :name', ['name' => 'Razorpay'])),'dataCounter' => '400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('core-setting::text-input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('payment_' . RAZORPAY_PAYMENT_METHOD_NAME . '_name'),'label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(trans('plugins/payment::payment.method_name')),'value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(get_payment_setting('name', RAZORPAY_PAYMENT_METHOD_NAME, __('Online payment via :name', ['name' => 'Razorpay']))),'data-counter' => '400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                        <div class="form-group mb-3">
                            <label class="text-title-field" for="payment_<?php echo e(RAZORPAY_PAYMENT_METHOD_NAME); ?>_description"><?php echo e(trans('core/base::forms.description')); ?></label>
                            <textarea class="next-input" name="payment_<?php echo e(RAZORPAY_PAYMENT_METHOD_NAME); ?>_description" id="payment_<?php echo e(RAZORPAY_PAYMENT_METHOD_NAME); ?>_description"><?php echo e(get_payment_setting('description', RAZORPAY_PAYMENT_METHOD_NAME, __('Payment with Razorpay'))); ?></textarea>
                        </div>

                        <p class="payment-note">
                            <?php echo e(trans('plugins/payment::payment.please_provide_information')); ?> <a target="_blank" href="https://razorpay.com">Razorpay</a>:
                        </p>

                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '4d69f58c2cfdff5049123ae0e3ca253b::text-input','data' => ['name' => 'payment_' . RAZORPAY_PAYMENT_METHOD_NAME . '_key','label' => __('Key'),'value' => get_payment_setting('key', RAZORPAY_PAYMENT_METHOD_NAME),'placeholder' => 'rzp_***']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('core-setting::text-input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('payment_' . RAZORPAY_PAYMENT_METHOD_NAME . '_key'),'label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Key')),'value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(get_payment_setting('key', RAZORPAY_PAYMENT_METHOD_NAME)),'placeholder' => 'rzp_***']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '4d69f58c2cfdff5049123ae0e3ca253b::text-input','data' => ['name' => 'payment_' . RAZORPAY_PAYMENT_METHOD_NAME . '_secret','type' => 'password','label' => __('Secret'),'value' => get_payment_setting('secret', RAZORPAY_PAYMENT_METHOD_NAME),'placeholder' => '••••••••']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('core-setting::text-input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('payment_' . RAZORPAY_PAYMENT_METHOD_NAME . '_secret'),'type' => 'password','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Secret')),'value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(get_payment_setting('secret', RAZORPAY_PAYMENT_METHOD_NAME)),'placeholder' => '••••••••']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                        <?php echo apply_filters(PAYMENT_METHOD_SETTINGS_CONTENT, null, RAZORPAY_PAYMENT_METHOD_NAME); ?>

                    </div>
                </div>
            </div>
            <div class="col-12 bg-white text-end">
                <button class="btn btn-warning disable-payment-item <?php if($razorpayStatus == 0): ?> hidden <?php endif; ?>" type="button"><?php echo e(trans('plugins/payment::payment.deactivate')); ?></button>
                <button class="btn btn-info save-payment-item btn-text-trigger-save <?php if($razorpayStatus == 1): ?> hidden <?php endif; ?>" type="button"><?php echo e(trans('plugins/payment::payment.activate')); ?></button>
                <button class="btn btn-info save-payment-item btn-text-trigger-update <?php if($razorpayStatus == 0): ?> hidden <?php endif; ?>" type="button"><?php echo e(trans('plugins/payment::payment.update')); ?></button>
            </div>
            <?php echo Form::close(); ?>

        </td>
    </tr>
    </tbody>
</table>
<?php /**PATH /home/elitedes/ecommerce3.elitedesign.com.bd/platform/plugins/razorpay/resources/views/settings.blade.php ENDPATH**/ ?>