<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('plugins/ecommerce::themes.customers.product-reviews.icons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="section-header">
        <h3><?php echo e(SeoHelper::getTitle()); ?></h3>
    </div>
    <div class="section-content product-reviews-page">
        <ul class="nav nav-tabs nav-fill" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link <?php if(! request()->has('page')): ?> active <?php endif; ?>" id="waiting-tab"
                    data-toggle="tab" data-target="#waiting-tab-pane" data-bs-toggle="tab" data-bs-target="#waiting-tab-pane" type="button"
                    role="tab" aria-controls="waiting-tab-pane" aria-selected="true"><?php echo e(__('Waiting for your review')); ?> (<?php echo e($products->count()); ?>)</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link <?php if(request()->has('page')): ?> active <?php endif; ?>" id="reviewed-tab"
                    data-toggle="tab" data-target="#reviewed-tab-pane"
                    data-bs-toggle="tab" data-bs-target="#reviewed-tab-pane" type="button"
                    role="tab" aria-controls="reviewed-tab-pane" aria-selected="false"><?php echo e(__('Reviewed')); ?> (<?php echo e($reviews->total()); ?>)</button>
            </li>
        </ul>

        <div class="tab-content border border-top-0 p-2">
            <div class="tab-pane fade <?php if(! request()->has('page')): ?> show active <?php endif; ?>" id="waiting-tab-pane" role="tabpanel" aria-labelledby="waiting-tab" tabindex="0">
                <?php if($products->count()): ?>
                    <div class="row row-cols-md-3 row-cols-1 gx-2">
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col mt-3 ecommerce-product-item" data-id="<?php echo e($product->id); ?>">
                                <div class="card mb-3 p-1">
                                    <div class="row g-1">
                                        <div class="col-md-4">
                                            <img src="<?php echo e(RvMedia::getImageUrl($product->order_product_image ?: $product->image, 'thumb', false, RvMedia::getDefaultImage())); ?>"
                                                class="img-fluid rounded-start ecommerce-product-image" alt="<?php echo e($product->name); ?>">
                                        </div>
                                        <div class="col-md-8">
                                            <h6 class="card-title ecommerce-product-name"><?php echo e($product->order_product_name ?: $product->name); ?></h6>
                                            <?php if($product->order_completed_at): ?>
                                                <div class="text-secondary">
                                                    <span><?php echo e(__('Order completed at:')); ?></span>
                                                    <time><?php echo e(Carbon\Carbon::parse($product->order_completed_at)->translatedFormat('M d, Y h:m')); ?></time>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-12">
                                            <div class="d-flex ecommerce-product-star">
                                                <?php for($i = 5; $i >= 1; $i--): ?>
                                                    <label class="order-<?php echo e($i); ?>">
                                                        <span class="ecommerce-icon" data-star="<?php echo e($i); ?>">
                                                            <svg> 
                                                                <use href="#ecommerce-icon-star" xlink:href="#ecommerce-icon-star"></use>
                                                            </svg>
                                                        </span>
                                                    </label>
                                                <?php endfor; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info">
                        <span><?php echo e(__('You do not have any products to review yet. Just shopping!')); ?></span>
                    </div>
                <?php endif; ?>
            </div>
            <div class="tab-pane fade <?php if(request()->has('page')): ?> show active <?php endif; ?>" id="reviewed-tab-pane" role="tabpanel" aria-labelledby="reviewed-tab" tabindex="0">
                <?php echo $__env->make('plugins/ecommerce::themes.customers.product-reviews.reviewed', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
        
        <?php echo $__env->make('plugins/ecommerce::themes.customers.product-reviews.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make(EcommerceHelper::viewPath('customers.master'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/ecommerce3.elitedesign.com.bd/platform/plugins/ecommerce/resources/views/themes/customers/product-reviews/list.blade.php ENDPATH**/ ?>