<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=5, user-scalable=1" name="viewport"/>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Fonts-->
    <link href="https://fonts.googleapis.com/css?family=<?php echo e(urlencode(theme_option('primary_font', 'Muli'))); ?>:400,600,700&subset=latin,latin-ext" rel="stylesheet" type="text/css">
    <!-- CSS Library-->

    <style>
        :root {
            --primary-font: '<?php echo e(theme_option('primary_font', 'Muli')); ?>', sans-serif;
            --primary-color: <?php echo e(theme_option('primary_color', '#fab528')); ?>;
            --heading-color: <?php echo e(theme_option('heading_color', '#000')); ?>;
            --text-color: <?php echo e(theme_option('text_color', '#000')); ?>;
            --primary-button-color: <?php echo e(theme_option('primary_button_color', '#000')); ?>;
            --top-header-background-color: <?php echo e(theme_option('top_header_background_color', '#f7f7f7')); ?>;
            --middle-header-background-color: <?php echo e(theme_option('middle_header_background_color', '#fff')); ?>;
            --bottom-header-background-color: <?php echo e(theme_option('bottom_header_background_color', '#fff')); ?>;
            --header-text-color: <?php echo e(theme_option('header_text_color', '#000')); ?>;
            --footer-text-color: <?php echo e(theme_option('footer_text_color', '#555')); ?>;
            --footer-heading-color: <?php echo e(theme_option('footer_heading_color', '#555')); ?>;
            --footer-hover-color: <?php echo e(theme_option('footer_hover_color', '#fab528')); ?>;
            --footer-border-color: <?php echo e(theme_option('footer_border_color', '#dee2e6')); ?>;
        }
    </style>

    <?php echo Theme::header(); ?>

</head>
<body <?php if(BaseHelper::siteLanguageDirection() == 'rtl'): ?> dir="rtl" <?php endif; ?>>
    <?php if(theme_option('preloader_enabled', 'yes') == 'yes'): ?>
        <div class="preloader" id="preloader">
            <div class="preloader-loading"></div>
        </div>
    <?php endif; ?>

    <div id="main-content">
        <?php echo Theme::content(); ?>

    </div>

    <script>
        'use strict';

        window.siteConfig = {
            "countdown_text" : {
                "days"   : "<?php echo e(__('days')); ?>",
                "hours"  : "<?php echo e(__('hours')); ?>",
                "minutes": "<?php echo e(__('mins')); ?>",
                "seconds": "<?php echo e(__('secs')); ?>"
            }
        };
    </script>

    <?php echo Theme::footer(); ?>

</body>
</html>

<?php /**PATH /home/elitedes/ecommerce3.elitedesign.com.bd/platform/themes/farmart/layouts/coming-soon.blade.php ENDPATH**/ ?>