<div class="table-responsive">
    <table class="table table-striped">
        <thead>
            <tr>
                <th><?php echo e(__('Image')); ?></th>
                <th><?php echo e(__('Product Name')); ?></th>
                <th><?php echo e(__('Date')); ?></th>
                <th><?php echo e(__('Star')); ?></th>
                <th width="200"><?php echo e(__('Comment')); ?></th>
                <th><?php echo e(__('Actions')); ?></th>
            </tr>
        </thead>
        <tbody>
        <?php if($reviews->total() > 0): ?>
            <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <th scope="row">
                        <img src="<?php echo e(RvMedia::getImageUrl($item->product->image, 'thumb', false, RvMedia::getDefaultImage())); ?>"
                            alt="<?php echo e($item->product->name); ?>" class="img-thumb" style="max-width: 70px">
                    </th>
                    <th scope="row">
                        <a href="<?php echo e($item->product->url); ?>"><?php echo e($item->product->name); ?></a>
                    </th>
                    <td><?php echo e($item->created_at->translatedFormat('M d, Y h:m')); ?></td>
                    <td>
                        <span><?php echo e($item->star); ?></span>
                        <span class="ecommerce-icon text-primary">
                            <svg>
                                <use href="#ecommerce-icon-star-o" xlink:href="#ecommerce-icon-star-o"></use>
                            </svg>
                        </span>
                    </td>
                    <td><?php echo e(Str::limit($item->comment, 120)); ?></td>
                    <td>
                        <?php echo Form::open([
                            'url' => route('public.reviews.destroy', $item->id),
                            'onSubmit' => 'return confirm("' . __('Do you really want to delete the review?') . '")']); ?>

                            <input type="hidden" name="_method" value="DELETE">
                            <button class="btn btn-danger btn-sm"><?php echo e(__('Delete')); ?></button>
                        <?php echo Form::close(); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr>
                <td colspan="6" class="text-center"><?php echo e(__('No reviews!')); ?></td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<div class="pagination">
    <?php echo $reviews->links(); ?>

</div>
<?php /**PATH /home/elitedes/ecommerce3.elitedesign.com.bd/platform/plugins/ecommerce/resources/views/themes/customers/product-reviews/reviewed.blade.php ENDPATH**/ ?>