<div class="mb-3">
    <label class="form-label required" for="shop-name-register"><?php echo e(__('Shop Name')); ?></label>
    <input class="form-control <?php if($errors->has('shop_name')): ?> is-invalid <?php endif; ?>"
        id="shop-name-register" type="text" name="shop_name" placeholder="<?php echo e(__('Store Name')); ?>" value="<?php echo e(old('shop_name')); ?>">
    <?php if($errors->has('shop_name')): ?>
        <div class="invalid-feedback"><?php echo e($errors->first('shop_name')); ?></div>
    <?php endif; ?>
</div>
<div class="form-group mb-3 position-relative">
    <label class="form-label required" for="shop-url-register"><?php echo e(__('Shop URL')); ?></label>
    <input class="form-control <?php if($errors->has('shop_url')): ?> is-invalid <?php endif; ?>" id="shop-url-register" type="text"
        name="shop_url"
        placeholder="<?php echo e(__('Store URL')); ?>" value="<?php echo e(old('shop_url')); ?>"
        data-url="<?php echo e(route('public.ajax.check-store-url')); ?>">
    <?php if($errors->has('shop_url')): ?>
        <div class="invalid-feedback"><?php echo e($errors->first('shop_url')); ?></div>
    <?php else: ?>
        <span class="d-inline-block">
            <small data-base-url="<?php echo e(route('public.store', '')); ?>"><?php echo e(route('public.store', (string)old('shop_url'))); ?></small>
        </span>
    <?php endif; ?>
    <span class="position-absolute top-0 end-0 shop-url-status"></span>
</div>
<div class="mb-3">
    <label class="form-label required" for="shop-phone-register"><?php echo e(__('Phone Number')); ?></label>
    <input class="form-control <?php if($errors->has('shop_phone')): ?> is-invalid <?php endif; ?>" id="shop-phone-register" type="text" name="shop_phone"
        placeholder="<?php echo e(__('Ex: 0943243332')); ?>">
    <?php if($errors->has('shop_phone')): ?>
        <div class="invalid-feedback"><?php echo e($errors->first('shop_phone')); ?></div>
    <?php endif; ?>
</div>
<?php /**PATH /home/elitede1/ecommerce13.elitedesign.com.bd/platform/themes/farmart/views/marketplace/includes/become-vendor-form.blade.php ENDPATH**/ ?>