<?php
    Theme::layout('full-width');
    Theme::asset()->container('footer')->remove('ecommerce-utilities-js');
?>
<?php echo Theme::partial('page-header', ['size' => 'xxxl']); ?>


<?php
    $menus = [
        'customer.overview' => [
            'label' => __('Overview'),
        ],
        'customer.edit-account' => [
            'label' => __('Profile'),
        ],
        'customer.orders' => [
            'label'  => __('Orders'),
            'routes' => ['customer.orders.view']
        ],
        'customer.product-reviews' => [
            'label'  => __('Product Reviews'),
            'routes' => ['customer.product-reviews']
        ],
        'customer.downloads' => [
            'label' => __('Downloads'),
        ],
        'customer.order_returns' => [
            'label'  => __('Order Return Requests'),
            'routes' => ['customer.order_returns', 'customer.order_returns.detail']
        ],
        'customer.address' => [
            'label'  => __('Addresses'),
            'routes' => [
                'customer.address.create',
                'customer.address.edit'
            ]
        ],
        'customer.change-password' => [
            'label' => __('Change password'),
        ],
    ];

    $routeName = Route::currentRouteName();

    if (! EcommerceHelper::isEnabledSupportDigitalProducts()) {
        unset($menus['customer.downloads']);
    }

    if (! EcommerceHelper::isReviewEnabled()) {
        unset($menus['customer.product-reviews']);
    }

    if (! EcommerceHelper::isOrderReturnEnabled()) {
        unset($menus['customer.order_returns']);
    }
?>
<div class="container-xxxl">
    <div class="row my-4">
        <div class="col-md-3">
            <ul class="nav flex-column dashboard-navigation">
                <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="nav-item">
                        <a class="nav-link
                            <?php if($routeName == $key
                            || in_array($routeName, Arr::get($item, 'routes', []))): ?> active <?php endif; ?>"
                            aria-current="<?php if($routeName == $key
                            || in_array($routeName, Arr::get($item, 'routes', []))): ?> true <?php else: ?> false <?php endif; ?>"
                            href="<?php echo e(route($key)); ?>"><?php echo e(Arr::get($item, 'label')); ?></a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if(is_plugin_active('marketplace')): ?>
                    <?php if(auth('customer')->user()->is_vendor): ?>
                        <li class="nav-item">
                            <a class="nav-link" aria-current="false" href="<?php echo e(route('marketplace.vendor.dashboard')); ?>"><?php echo e(__('Vendor dashboard')); ?></a>
                        </li>
                    <?php else: ?>
                        <li class="nav-item <?php if($routeName == 'marketplace.vendor.become-vendor'): ?> active <?php endif; ?>">
                            <a class="nav-link" aria-current="<?php if($routeName == 'marketplace.vendor.become-vendor'): ?> active <?php endif; ?>"
                                href="<?php echo e(route('marketplace.vendor.become-vendor')); ?>"><?php echo e(__('Become a vendor')); ?></a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <li class="nav-item">
                    <a class="nav-link" aria-current="false" href="<?php echo e(route('customer.logout')); ?>"><?php echo e(__('Logout')); ?></a>
                </li>
            </ul>
        </div>
        <div class="col-md-9">
            <div class="customer-dashboard-container">
                <div class="customer-dashboard-content">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/elitede1/ecommerce13.elitedesign.com.bd/platform/themes/farmart/views/ecommerce/customers/master.blade.php ENDPATH**/ ?>