<?php if($order): ?>
    <div class="customer-order-detail">
        <div class="row">
            <div class="col-md-6">
                <h5><?php echo e(__('Order information')); ?></h5>
                <p>
                    <span><?php echo e(__('Order number')); ?>: </span>
                    <strong><?php echo e($order->code); ?></strong>
                </p>
                <p>
                    <span><?php echo e(__('Time')); ?>: </span>
                    <strong><?php echo e($order->created_at->translatedFormat('h:m d/m/Y')); ?></strong>
                </p>
                <p>
                    <span><?php echo e(__('Order status')); ?>: </span>
                    <strong class="text-info"><?php echo e($order->status->label()); ?></strong>
                </p>
                <?php if(is_plugin_active('payment')): ?>
                    <p>
                        <span><?php echo e(__('Payment method')); ?>: </span>
                        <strong class="text-info"><?php echo e($order->payment->payment_channel->label()); ?></strong>
                    </p>
                    <p>
                        <span><?php echo e(__('Payment status')); ?>: </span>
                        <strong class="text-info"><?php echo e($order->payment->status->label()); ?></strong>
                    </p>
                <?php endif; ?>
                <?php if($order->description): ?>
                    <p>
                        <span><?php echo e(__('Note')); ?>: </span>
                        <strong class="text-warning"><i><?php echo e($order->description); ?></i></strong>
                    </p>
                <?php endif; ?>
            </div>
            <div class="col-md-6">
                <h5><?php echo e(__('Customer information')); ?></h5>
                <p>
                    <span><?php echo e(__('Full Name')); ?>: </span>
                    <strong><?php echo e($order->address->name); ?></strong>
                </p>
                <p>
                    <span><?php echo e(__('Phone')); ?>: </span>
                    <strong><?php echo e($order->address->phone); ?></strong>
                </p>
                <p>
                    <span><?php echo e(__('Address')); ?>: </span>
                    <strong> <?php echo e($order->address->address); ?></strong>
                </p>
                <p>
                    <span><?php echo e(__('City')); ?>: </span>
                    <strong><?php echo e($order->address->city_name); ?></strong>
                </p>
                <p>
                    <span><?php echo e(__('State')); ?>: </span>
                    <strong> <?php echo e($order->address->state_name); ?></strong>
                </p>
                <p>
                    <span><?php echo e(__('Country')); ?>: </span>
                    <strong> <?php echo e($order->address->country_name); ?></strong>
                </p>
                <?php if(EcommerceHelper::isZipCodeEnabled()): ?>
                    <p>
                        <span><?php echo e(__('Zip code')); ?>: </span>
                        <strong> <?php echo e($order->address->zip_code); ?></strong>
                    </p>
                <?php endif; ?>
            </div>
        </div>
        <br>
        <h5><?php echo e(__('Order detail')); ?></h5>
        <div>
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle">
                    <thead>
                        <tr>
                            <th class="text-center">#</th>
                            <th class="text-center"><?php echo e(__('Image')); ?></th>
                            <th><?php echo e(__('Product')); ?></th>
                            <th class="text-center"><?php echo e(__('Amount')); ?></th>
                            <th class="text-end" style="width: 100px"><?php echo e(__('Quantity')); ?></th>
                            <th class="price text-end"><?php echo e(__('Total')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $order->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="text-center"><?php echo e($loop->iteration); ?></td>
                                <td class="text-center">
                                    <img src="<?php echo e(RvMedia::getImageUrl($orderProduct->product_image, 'thumb', false, RvMedia::getDefaultImage())); ?>"
                                        width="50" alt="<?php echo e($orderProduct->product_name); ?>">
                                </td>
                                <td>
                                    <?php echo e($orderProduct->product_name); ?>

                                    <?php if($sku = Arr::get($orderProduct->options, 'sku')): ?>
                                        (<?php echo e($sku); ?>)
                                    <?php endif; ?>
                                    <?php if($attributes = Arr::get($orderProduct->options, 'attributes')): ?>
                                        <p class="mb-0">
                                            <small><?php echo e($attributes); ?></small>
                                        </p>
                                    <?php endif; ?>

                                    <?php echo $__env->make('plugins/ecommerce::themes.includes.cart-item-options-extras', ['options' => $orderProduct->options], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                    <?php if(! empty($orderProduct->product_options) && is_array($orderProduct->product_options)): ?>
                                        <?php echo render_product_options_html($orderProduct->product_options, $orderProduct->price); ?>

                                    <?php endif; ?>
                                </td>
                                <td class="text-center"><?php echo e(format_price($orderProduct->price_with_tax)); ?></td>
                                <td class="text-center"><?php echo e($orderProduct->qty); ?></td>
                                <td class="money text-end">
                                    <strong>
                                        <?php echo e(format_price($orderProduct->total_price_with_tax)); ?>

                                    </strong>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <p>
                <span><?php echo e(__('Shipping fee')); ?>: </span>
                <strong><?php echo e(format_price($order->shipping_amount)); ?></strong>
            </p>
            <p>
                <span><?php echo e(__('Total Amount')); ?>: </span>
                <strong><?php echo e(format_price($order->amount)); ?></strong>
            </p>
        </div>

        <?php if($order->shipment->id): ?>
            <br>
            <h5><?php echo e(__('Shipping Information')); ?>: </h5>
            <p>
                <span class="d-inline-block"><?php echo e(__('Shipping Status')); ?>: </span>
                <strong
                    class="d-inline-block text-info"><?php echo BaseHelper::clean($order->shipment->status->toHtml()); ?></strong>
            </p>
            <?php if($order->shipment->shipping_company_name): ?>
                <p>
                    <span class="d-inline-block"><?php echo e(__('Shipping Company Name')); ?>: </span>
                    <strong class="d-inline-block"><?php echo e($order->shipment->shipping_company_name); ?></strong>
                </p>
            <?php endif; ?>
            <?php if($order->shipment->tracking_id): ?>
                <p>
                    <span class="d-inline-block"><?php echo e(__('Tracking ID')); ?>: </span>
                    <strong class="d-inline-block"><?php echo e($order->shipment->tracking_id); ?></strong>
                </p>
            <?php endif; ?>
            <?php if($order->shipment->tracking_link): ?>
                <p>
                    <span class="d-inline-block"><?php echo e(__('Tracking Link')); ?>: </span>
                    <strong class="d-inline-block">
                        <a href="<?php echo e($order->shipment->tracking_link); ?>"
                           target="_blank"><?php echo e($order->shipment->tracking_link); ?></a>
                    </strong>
                </p>
            <?php endif; ?>
            <?php if($order->shipment->note): ?>
                <p>
                    <span class="d-inline-block"><?php echo e(__('Delivery Notes')); ?>: </span>
                    <strong class="d-inline-block"><?php echo e($order->shipment->note); ?></strong>
                </p>
            <?php endif; ?>
            <?php if($order->shipment->estimate_date_shipped): ?>
                <p>
                    <span class="d-inline-block"><?php echo e(__('Estimate Date Shipped')); ?>: </span>
                    <strong class="d-inline-block"><?php echo e($order->shipment->estimate_date_shipped); ?></strong>
                </p>
            <?php endif; ?>
            <?php if($order->shipment->date_shipped): ?>
                <p>
                    <span class="d-inline-block"><?php echo e(__('Date Shipped')); ?>: </span>
                    <strong class="d-inline-block"><?php echo e($order->shipment->date_shipped); ?></strong>
                </p>
            <?php endif; ?>
        <?php endif; ?>
    </div>
<?php elseif(request()->input('order_id') || request()->input('email')): ?>
    <p class="text-center text-danger"><?php echo e(__('Order not found!')); ?></p>
<?php endif; ?>
<?php /**PATH /home/elitedes/ecommerce3.elitedesign.com.bd/platform/plugins/ecommerce/resources/views/themes/includes/order-tracking-detail.blade.php ENDPATH**/ ?>