<div class="row">
    <div class="col-md-6">
        <div class="form-group mb-3 <?php if($errors->has('name')): ?> has-error <?php endif; ?>">
            <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.name')); ?></label>
            <input type="text" name="name" id="address_name" placeholder="<?php echo e(trans('plugins/ecommerce::addresses.name_placeholder')); ?>" class="form-control"
                   value="<?php echo e(old('name', $address)); ?>">
            <?php echo Form::error('name', $errors); ?>

        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group mb-3 <?php if($errors->has('phone')): ?> has-error <?php endif; ?>">
            <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.phone')); ?></label>
            <input type="text" name="phone" id="address_phone" placeholder="<?php echo e(trans('plugins/ecommerce::addresses.phone_placeholder')); ?>" class="form-control"
                   value="<?php echo e(old('phone', $address)); ?>">
            <?php echo Form::error('phone', $errors); ?>

        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="form-group mb-3 <?php if($errors->has('zip_code')): ?> has-error <?php endif; ?>">
            <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.zip')); ?></label>
            <input type="text" name="zip_code" id="address_zip_code" placeholder="<?php echo e(trans('plugins/ecommerce::addresses.zip_placeholder')); ?>" class="form-control"
                   value="<?php echo e(old('zip_code', $address)); ?>">
            <?php echo Form::error('zip_code', $errors); ?>

        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group mb-3 <?php if($errors->has('email')): ?> has-error <?php endif; ?>">
            <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.email')); ?></label>
            <input type="text" name="email" id="address_email" placeholder="<?php echo e(trans('plugins/ecommerce::addresses.email_placeholder')); ?>" class="form-control"
                   value="<?php echo e(old('email', $address)); ?>">
            <?php echo Form::error('email', $errors); ?>

        </div>
    </div>
</div>
<div class="row">
    <div class="col-12">
        <div class="form-group mb-3 <?php if($errors->has('address')): ?> has-error <?php endif; ?>">
            <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.address')); ?></label>
            <input type="text" name="address" id="address_address" placeholder="<?php echo e(trans('plugins/ecommerce::addresses.address_placeholder')); ?>" class="form-control"
                   value="<?php echo e(old('address', $address)); ?>">
            <?php echo Form::error('address', $errors); ?>

        </div>
    </div>
</div>
<div class="row">
    <div class="col-12">
        <?php if(EcommerceHelper::isUsingInMultipleCountries()): ?>
            <div class="form-group mb-3 <?php if($errors->has('country')): ?> has-error <?php endif; ?>">
                <label for="country"><?php echo e(__('Country')); ?>:</label>
                <?php echo Form::customSelect('country', EcommerceHelper::getAvailableCountries(), old('country', $address->country), ['id' => 'country', 'data-type' => 'country']); ?>

            </div>
            <?php echo Form::error('country', $errors); ?>

        <?php else: ?>
            <input type="hidden" name="country" value="<?php echo e(EcommerceHelper::getFirstCountryId()); ?>">
        <?php endif; ?>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="form-group mb-3 <?php if($errors->has('state')): ?> has-error <?php endif; ?>">
            <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.state')); ?></label>
            <?php if(EcommerceHelper::loadCountriesStatesCitiesFromPluginLocation()): ?>
                <?php echo Form::customSelect('country', EcommerceHelper::getAvailableStatesByCountry(old('country', $address->country)), old('state', $address->state), ['id' => 'state', 'data-type' => 'state', 'data-url' => route('ajax.states-by-country')]); ?>

            <?php else: ?>
                <input id="state" type="text" class="form-control" name="state" value="<?php echo e(old('state', $address)); ?>">
            <?php endif; ?>
            <?php echo Form::error('state', $errors); ?>

        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group mb-3 <?php if($errors->has('city')): ?> has-error <?php endif; ?>">
            <label class="text-title-field"><?php echo e(trans('plugins/ecommerce::addresses.city')); ?></label>
            <?php if(EcommerceHelper::loadCountriesStatesCitiesFromPluginLocation()): ?>
                <?php echo Form::customSelect('city', EcommerceHelper::getAvailableStatesByCountry(old('state', $address->state)), old('city', $address->city), ['id' => 'city', 'data-type' => 'city', 'data-url' => route('ajax.cities-by-state')]); ?>

            <?php else: ?>
                <input id="city" type="text" class="form-control" name="city" value="<?php echo e(old('city', $address)); ?>">
            <?php endif; ?>
            <?php echo Form::error('city', $errors); ?>

        </div>
    </div>
</div>
<?php /**PATH /home/elitedesign/ecommerce13.elitedesign.com.bd/platform/plugins/ecommerce/resources/views/customers/addresses/form.blade.php ENDPATH**/ ?>