<div class="container product-detail-container">
    <div class="row">
        <div class="col-md-6">
            <div class="px-1 py-1 px-lg-5 py-lg-5 py-md-1 my-lg-5 my-md-1 my-2 mb-4">
                <?php echo Theme::partial('ecommerce.product-gallery', compact('product', 'productImages')); ?>

            </div>
        </div>
        <div class="col-md-6">
            <div class="product-modal-entry product-details">
                <div class="entry-product-header">
                    <div class="product-header-left">
                        <h2 class="h3 product_title entry-title"><a href="<?php echo e($product->url); ?>"><?php echo BaseHelper::clean($product->name); ?></a></h2>
                        <div class="product-entry-meta">
                            <?php if($product->brand_id): ?>
                                <p class="mb-0 me-2 pe-2 text-secondary"><?php echo e(__('Brand')); ?>: <a href="<?php echo e($product->brand->url); ?>"><?php echo e($product->brand->name); ?></a></p>
                            <?php endif; ?>

                            <?php if(EcommerceHelper::isReviewEnabled()): ?>
                                <div class="col-auto">
                                    <?php echo Theme::partial('star-rating', ['avg' => $product->reviews_avg, 'count' => $product->reviews_count]); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php echo Theme::partial('ecommerce.product-price', compact('product')); ?>


                <?php if(is_plugin_active('marketplace') && $product->store_id): ?>
                    <div class="product-meta-sold-by my-2">
                        <span class="d-inline-block"><?php echo e(__('Sold By')); ?>: </span>
                        <a href="<?php echo e($product->store->url); ?>">
                            <?php echo e($product->store->name); ?>

                        </a>
                    </div>
                <?php endif; ?>

                <?php echo Theme::partial('ecommerce.product-availability', compact('product', 'productVariation')); ?>


                <div class="product-details__short-description">
                    <?php echo apply_filters('ecommerce_before_product_description', null, $product); ?>

                    <?php echo BaseHelper::clean($product->description); ?>

                    <?php echo apply_filters('ecommerce_after_product_description', null, $product); ?>

                </div>
                <?php echo Theme::partial('ecommerce.product-cart-form', compact('product', 'wishlistIds', 'selectedAttrs') + ['withButtons' => true, 'withVariations' => true, 'withBuyNow' => true]); ?>


                <div class="meta-sku <?php if(!$product->sku): ?> d-none <?php endif; ?>">
                    <span class="meta-label d-inline-block"><?php echo e(__('SKU')); ?>:</span>
                    <span class="meta-value"><?php echo e($product->sku); ?></span>
                </div>
                <?php if($product->categories->count()): ?>
                    <div class="meta-categories">
                        <span class="meta-label d-inline-block"><?php echo e(__('Categories')); ?>:</span>
                        <?php $__currentLoopData = $product->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e($category->url); ?>"><?php echo BaseHelper::clean($category->name); ?></a><?php if(!$loop->last): ?>, <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
                <?php if($product->tags->count()): ?>
                    <div class="meta-categories">
                        <span class="meta-label d-inline-block"><?php echo e(__('Tags')); ?>:</span>
                        <?php $__currentLoopData = $product->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e($tag->url); ?>"><?php echo e($tag->name); ?></a><?php if(!$loop->last): ?>, <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>

            </div>
            <?php if(theme_option('social_share_enabled', 'yes') == 'yes'): ?>
                <div class="mt-5">
                    <?php echo Theme::partial('share-socials', compact('product')); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH /home/elitedesignbd/ecommerce12.elitedesign.com.bd/platform/themes/farmart/partials/ecommerce/quick-view.blade.php ENDPATH**/ ?>