<?php $__env->startSection('content'); ?>
    <?php
        $customer = auth('customer')->user();
    ?>
    <p><?php echo BaseHelper::clean(__('Hello <strong>:name</strong> (not <strong>:name</strong>? <a class="text-primary" href=":link">Log out</a>)', [
            'name' => $customer->name,
            'link' => route('customer.logout'),
        ])); ?></p>

    <p><?php echo BaseHelper::clean(__('From your account dashboard you can view your <a class="text-primary" href=":order">recent orders</a>, manage your <a class="text-primary" href=":addresses">shipping and billing addresses</a>, and <a class="text-primary" href=":edit_account">edit your password and account details</a>.', [
            'order'        => route('customer.orders'),
            'addresses'    => route('customer.address'),
            'edit_account' => route('customer.edit-account'),
        ])); ?></p>

    <?php if(!$customer->orders()->count()): ?>
        <div class="alert alert-info d-flex align-items-center justify-content-between border-0" role="alert">
            <div>
                <span class="svg-icon">
                    <svg>
                        <use href="#svg-icon-check-circle" xlink:href="#svg-icon-check-circle"></use>
                    </svg>
                </span>
                <span class="ms-2"><?php echo e(__('No order has been made yet')); ?>.</span>
            </div>
            <a class="box-shadow" href="<?php echo e(route('public.products')); ?>"><?php echo e(__('Browse products')); ?></a>
        </div>
    <?php endif; ?>

    <p><?php echo e(__('The following addresses will be used on the checkout page by default')); ?>.</p>
    <div class="customer-address py-3">
        <div class="d-flex justify-content-between py-2">
            <h4><?php echo e(__('Addresses')); ?></h4>
            <a class="add-address text-primary" href="<?php echo e(route('customer.address.create')); ?>"><?php echo e(__('Add')); ?></a>
        </div>
        <?php echo $__env->make(Theme::getThemeNamespace() . '::views.ecommerce.customers.address.items', ['addresses' => $customer->addresses()->limit(3)->get()], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make(Theme::getThemeNamespace() . '::views.ecommerce.customers.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesignbd/ecom12.elitedesign.com.bd/platform/themes/farmart/views/ecommerce/customers/overview.blade.php ENDPATH**/ ?>