

<?php $__env->startSection('title', $data->title); ?>
<?php $gtext = gtext(); ?>

<?php $__env->startSection('meta-content'); ?>
	<meta name="keywords" content="<?php echo e($data->og_keywords); ?>" />
	<meta name="description" content="<?php echo e($data->og_description ? $data->og_description : $data->short_desc); ?>" />
	<meta property="og:title" content="<?php echo e($data->og_title ? $data->og_title : $data->title); ?>" />
	<meta property="og:site_name" content="<?php echo e($gtext['site_name']); ?>" />
	<meta property="og:description" content="<?php echo e($data->og_description ? $data->og_description : $data->short_desc); ?>" />
	<meta property="og:type" content="article" />
	<meta property="og:url" content="<?php echo e(url()->current()); ?>" />
	<meta property="og:image" content="<?php echo e($data->og_image ? asset('public/media/'.$data->og_image) : asset('public/media/'.$data->f_thumbnail)); ?>" />
	<meta property="og:image:width" content="600" />
	<meta property="og:image:height" content="315" />
	<?php if($gtext['fb_publish'] == 1): ?>
	<meta name="fb:app_id" property="fb:app_id" content="<?php echo e($gtext['fb_app_id']); ?>" />
	<?php endif; ?>
	<meta name="twitter:card" content="summary_large_image">
	<?php if($gtext['twitter_publish'] == 1): ?>
	<meta name="twitter:site" content="<?php echo e($gtext['twitter_id']); ?>">
	<meta name="twitter:creator" content="<?php echo e($gtext['twitter_id']); ?>">
	<?php endif; ?>
	<meta name="twitter:url" content="<?php echo e(url()->current()); ?>">
	<meta name="twitter:title" content="<?php echo e($data->og_title ? $data->og_title : $data->title); ?>">
	<meta name="twitter:description" content="<?php echo e($data->og_description ? $data->og_description : $data->short_desc); ?>">
	<meta name="twitter:image" content="<?php echo e($data->og_image ? asset('public/media/'.$data->og_image) : asset('public/media/'.$data->f_thumbnail)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('frontend.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<main class="main">
	<!-- Page Breadcrumb -->
	<div class="breadcrumb-section">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a></li>
							<li class="breadcrumb-item active" aria-current="page"><?php echo e($data->title); ?></li>
						</ol>
					</nav>
				</div>
				<div class="col-lg-6">
					<div class="page-title">
						<h1><?php echo e($data->title); ?></h1>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Page Breadcrumb/ -->
	
	<!-- Inner Section -->
	<section class="inner-section inner-section-bg">
		<div class="container">
			<div class="row">
				<div class="col-xl-5">
					<div class="product-details-slider pd-slider-for">
						<?php if(count($pro_images)>0): ?>
						<?php $__currentLoopData = $pro_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="item">
							<img src="<?php echo e(asset('public/media/'.$row->thumbnail)); ?>" alt="<?php echo e($key); ?>" />
						</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php else: ?>
						<div class="item">
							<img src="<?php echo e(asset('public/media/'.$data->f_thumbnail)); ?>" alt="<?php echo e($data->title); ?>" />
						</div>
						<?php endif; ?>
					</div>
					<div class="thumbnail-card pd-slider-nav">
						<?php if(count($pro_images)>0): ?>
						<?php $__currentLoopData = $pro_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<img src="<?php echo e(asset('public/media/'.$row->thumbnail)); ?>" alt="<?php echo e($key); ?>" />
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php else: ?>
						<img src="<?php echo e(asset('public/media/'.$data->f_thumbnail)); ?>" alt="<?php echo e($data->title); ?>" />
						<?php endif; ?>
					</div>
				</div>
				<div class="col-xl-7">
					<div class="pr_details">
						<h4 class="product_title"><?php echo e($data->title); ?></h4>
						<?php if($data->short_desc != ''): ?>
						<p><?php echo e($data->short_desc); ?></p>
						<?php endif; ?>
						<?php if($data->shop_name != ''): ?>
						<div class="pr_extra"><strong><?php echo e(__('Sold By')); ?>:</strong> <a href="<?php echo e(route('frontend.stores', [$data->seller_id, str_slug($data->shop_url)])); ?>"><?php echo e($data->shop_name); ?></a></div>
						<?php endif; ?>
						<div class="product_price">
							<?php if($data->sale_price != ''): ?>
								<?php if($gtext['currency_position'] == 'left'): ?>
								<div class="item-price"><?php echo e($gtext['currency_icon']); ?><?php echo e(NumberFormat($data->sale_price)); ?></div>
								<?php else: ?>
								<div class="item-price"><?php echo e(NumberFormat($data->sale_price)); ?><?php echo e($gtext['currency_icon']); ?></div>
								<?php endif; ?>
							<?php endif; ?>
							<?php if(($data->is_discount == 1) && ($data->old_price !='')): ?>
								
								<?php 
									$discount = number_format((($data->old_price - $data->sale_price)*100)/$data->old_price);
								?>
							
								<?php if($gtext['currency_position'] == 'left'): ?>
								<div class="old-item-price"><?php echo e($gtext['currency_icon']); ?><?php echo e(NumberFormat($data->old_price)); ?></div><span class="discount">-<?php echo e($discount); ?>%</span>
								<?php else: ?>
								<div class="old-item-price"><?php echo e(NumberFormat($data->old_price)); ?><?php echo e($gtext['currency_icon']); ?></div><span class="discount">-<?php echo e($discount); ?>%</span>
								<?php endif; ?>
							<?php endif; ?>
						</div>
						<?php if($data->variation_size != ''): ?>
						<div class="pr_widget">
							<label class="widget-title"><?php echo e(__('Unit')); ?></label>
							<ul class="widget-size">
								<li class="unit active"><?php echo e($data->variation_size); ?></li>
							</ul>
						</div>
						<?php endif; ?>
						<div class="pr_quantity">
							<label for="quantity"><?php echo e(__('Quantity')); ?></label>
							<input name="quantity" id="quantity" type="number" min="1" max="<?php echo e($data->is_stock == 1 ? $data->stock_qty : 999); ?>" value="1">
						</div>
						<div class="pr_buy_cart">
							<a class="btn theme-btn cart product_addtocart" data-id="<?php echo e($data->id); ?>" data-stockqty="<?php echo e($data->is_stock == 1 ? $data->stock_qty : 999); ?>" href="javascript:void(0);"><?php echo e(__('Add To Cart')); ?></a>
							<a class="btn theme-btn cart product_buy_now" data-id="<?php echo e($data->id); ?>" data-stockqty="<?php echo e($data->is_stock == 1 ? $data->stock_qty : 999); ?>" href="javascript:void(0);"><?php echo e(__('Buy Now')); ?></a>
							<a class="btn theme-btn cart wishlist addtowishlist" data-id="<?php echo e($data->id); ?>" href="javascript:void(0);"><i class="bi bi-heart-fill"></i></a>
						</div>
						
						<?php if($data->is_stock == 1): ?>
							<?php if($data->stock_status_id == 1): ?>
							<div class="pr_extra"><strong><?php echo e(__('Availability')); ?>:</strong><span class="instock"><?php echo e($data->stock_qty); ?> <?php echo e(__('In Stock')); ?></span></div>
							<?php else: ?>
							<div class="pr_extra"><strong><?php echo e(__('Availability')); ?>:</strong><span class="stockout"><?php echo e(__('Out Of Stock')); ?></span></div>
							<?php endif; ?>
						<?php endif; ?>
						<?php if($data->is_stock == 1): ?>
							<?php if($data->sku != ''): ?>
							<div class="pr_extra"><strong><?php echo e(__('SKU')); ?>:</strong>  <?php echo e($data->sku); ?></div>
							<?php endif; ?>
						<?php endif; ?>
						<?php if($data->brandname != ''): ?>
						<div class="pr_extra"><strong><?php echo e(__('Brand')); ?>: </strong><a href="<?php echo e(route('frontend.brand', [$data->brand_id, str_slug($data->brandname)])); ?>"> <?php echo e($data->brandname); ?></a></div>
						<?php endif; ?>
						<div class="pr_extra"><strong><?php echo e(__('Category')); ?>: </strong> <a href="<?php echo e(route('frontend.product-category', [$data->cat_id, $data->cat_slug])); ?>"><?php echo e($data->cat_name); ?></a></div>
						
						<div class="pr_widget">
							<label class="widget-title"><?php echo e(__('Share this')); ?></label>
							<div class="social-media">
								<a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('frontend.product', [$data->id, $data->slug])); ?>" target="_blank"><i class="bi bi-facebook"></i></a>
								<a href="https://twitter.com/intent/tweet?text=<?php echo e($data->title); ?>&url=<?php echo e(route('frontend.product', [$data->id, $data->slug])); ?>" target="_blank"><i class="bi bi-twitter"></i></a>
								<a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo e(route('frontend.product', [$data->id, $data->slug])); ?>&title=<?php echo e($data->title); ?>&summary=<?php echo e($data->short_desc); ?>" target="_blank"><i class="bi bi-linkedin"></i></a>
								<a href="https://wa.me/?text=<?php echo e(route('frontend.product', [$data->id, $data->slug])); ?>" target="_blank"><i class="bi bi-whatsapp"></i></a>
							</div>
						</div>
					</div>
				</div>
			</div>
			
			<!-- Product Description Review and Vendor -->
			<div class="row">
				<div class="col-lg-12">
					<?php if(Session::has('success')): ?>
					<div class="alert alert-success">
						<?php echo e(Session::get('success')); ?>

					</div>
					<?php endif; ?>
					
					<?php if(Session::has('fail')): ?>
					<div class="alert alert-danger">
						<?php echo e(Session::get('fail')); ?>

					</div>
					<?php endif; ?>
					
					<?php if($errors->any()): ?>
						<ul class="errors-list">
						<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<li><?php echo e($error); ?></li>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</ul>
					<?php endif; ?>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-12">
					<div class="pr-description-review">
						<div class="desc-review-nav nav">
							<a class="active" href="#des_description" data-bs-toggle="tab"><?php echo e(__('Description')); ?></a>
							<a href="#des_reviews" data-bs-toggle="tab"><?php echo e(__('Reviews')); ?> (<?php echo e($data->TotalReview); ?>)</a>
							<a href="#vendor" data-bs-toggle="tab"><?php echo e(__('Vendor')); ?></a>
						</div>
						<div class="tab-content">
							<!-- Description -->
							<div id="des_description" class="tab-pane active">
								<div class="entry">
									<?php echo $data->description; ?>

								</div>
							</div>
							<!-- /Description/ -->
							
							<!-- Review -->
							<div id="des_reviews" class="tab-pane">
								<div class="review-content">
									<!-- Review Form-->
									<div class="row">
										<div class="col-lg-6">
											<div class="review-form">
												<h4><?php echo e(__('Submit your review')); ?></h4>
												<p>Please <a href="<?php echo e(route('frontend.login')); ?>"><strong>login</strong></a> to write review!</p>
												<div class="form-product-review">
													<form class="form" method="POST" action="<?php echo e(route('frontend.saveReviews')); ?>">
														<?php echo csrf_field(); ?>
														<?php if(isset(Auth::user()->name)): ?>
														<div class="mb-3">
															<textarea name="comments" placeholder="<?php echo e(__('Write comment')); ?>" class="form-control" rows="3"></textarea>
														</div>
														<div class="mb-3">
															<label for="rating" class="form-label"><?php echo e(__('Your rating of this product')); ?></label>
															<select id="rating" name="rating" class="form-select form-select-sm">
																<option value="5">5 Star</option>
																<option value="4">4 Star</option>
																<option value="3">3 Star</option>
																<option value="2">2 Star</option>
																<option value="1">1 Star</option>
															</select>
														</div>
														<input name="item_id" type="hidden" value="<?php echo e($data->id); ?>" />
														<button type="submit" class="btn theme-btn" ><?php echo e(__('Submit Review')); ?></button>
														<?php else: ?>
														<div class="mb-3">
															<textarea name="comments" placeholder="<?php echo e(__('Write comment')); ?>" class="form-control" rows="3" disabled></textarea>
														</div>
														<a class="btn theme-btn" href="<?php echo e(route('frontend.login')); ?>"><i class="bi bi-box-arrow-in-right"></i> <?php echo e(__('Please Login')); ?></a>
														<?php endif; ?>
													</form>
												</div>
											</div>
										</div>
										<div class="col-lg-6">
										</div>
									</div>
									<!-- /Review Form/-->
									
									<!-- Product Review -->
									<?php if(count($pro_reviews)>0): ?>
									<div class="row">
										<div class="col-lg-12">
											<div class="review-heading">
												<h4><?php echo e($data->TotalReview); ?> <?php echo e(__('reviews for')); ?> - <?php echo e($data->title); ?></h4>
											</div>
											<div id="tp_datalist">
												<?php echo $__env->make('frontend.partials.products-reviews-grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
											</div>
										</div>
									</div>
									<?php endif; ?>
									<!-- /Product Review/ -->
								</div>
							</div>
							<!-- /Review/ -->
							
							<!-- Vendor -->
							<div id="vendor" class="tab-pane">
								<div class="store-content">
									<div class="row">
										<div class="col-lg-12">
											<div class="stores-card">
												<div class="store-logo">
													<?php if($seller_data->photo == ''): ?>
													<span class="text"><?php echo e(sub_str($seller_data->shop_name, 0,1)); ?></span>
													<?php else: ?>
													<img src="<?php echo e(asset('public/media/'.$seller_data->photo)); ?>" alt="<?php echo e($seller_data->shop_name); ?>"/>
													<?php endif; ?>
												</div>
												<div class="desc">
													<h3 class="store-name"><a href="<?php echo e(route('frontend.stores', [$data->seller_id, str_slug($data->shop_url)])); ?>"><?php echo e($seller_data->shop_name); ?></a></h3>
													<h6 class="since"><?php echo e(__('Since')); ?> <?php echo e(date('Y', strtotime($seller_data->created_at))); ?></h6>
													<div class="rating-wrap">
														<div class="stars-outer">
															<div class="stars-inner" style="width:<?php echo e($SellerReview['ReviewPercentage']); ?>%;"></div>
														</div>
														<span class="rating-count">(<?php echo e($SellerReview['TotalReview']); ?>)</span>
													</div>
													<ul class="info">
														<li><i class="bi bi-telephone"></i><?php echo e($seller_data->phone); ?></li>
														<li><i class="bi bi-envelope"></i><?php echo e($seller_data->email); ?></li>
														<li><i class="bi bi-geo-alt"></i><?php echo e($seller_data->address); ?></li>
													</ul>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Vendor/ -->
						</div>
					</div>
				</div>
			</div>
			<!-- /Product Description Review and Vendor/ -->		
		</div>
	</section>
	<!-- /Inner Section/ -->
	
	<!-- Popular Products -->
	<section class="section product-section">
		<div class="container">
			<div class="row">
				<div class="col">
					<div class="section-heading">
						<h2><?php echo e(__('Related Products')); ?></h2>
					</div>
				</div>
			</div>
			<div class="row owl-carousel caro-common category-carousel">
				<?php if(count($related_products)>0): ?>
					<?php $__currentLoopData = $related_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<?php 
						if(($row->is_discount == 1) && ($row->old_price !='')){
							$discount = number_format((($row->old_price - $row->sale_price)*100)/$row->old_price);
						}
					?>
					<div class="col-lg-12">
						<div class="item-card">
							<div class="item-image">
								<?php if(($row->is_discount == 1) && ($row->old_price !='')): ?>
								<span class="item-label"><?php echo e($discount); ?>% <?php echo e(__('Off')); ?></span>
								<?php endif; ?>
								<a href="<?php echo e(route('frontend.product', [$row->id, $row->slug])); ?>"><img src="<?php echo e(asset('public/media/'.$row->f_thumbnail)); ?>" alt="<?php echo e($row->title); ?>" /></a>
							</div>
							<div class="item-title">
								<a href="<?php echo e(route('frontend.product', [$row->id, $row->slug])); ?>"><?php echo e(str_limit($row->title)); ?></a>
							</div>
							<div class="rating-wrap">
								<div class="stars-outer">
									<div class="stars-inner" style="width:<?php echo e($row->ReviewPercentage); ?>%;"></div>
								</div>
								<span class="rating-count">(<?php echo e($row->TotalReview); ?>)</span>
							</div>
							<div class="item-sold">
								<?php echo e(__('Sold By')); ?> <a href="<?php echo e(route('frontend.stores', [$row->seller_id, str_slug($row->shop_url)])); ?>"><?php echo e(str_limit($row->shop_name)); ?></a>
							</div>
							<div class="item-pric-card">
								<?php if($row->sale_price != ''): ?>
									<?php if($gtext['currency_position'] == 'left'): ?>
									<div class="new-price"><?php echo e($gtext['currency_icon']); ?><?php echo e(NumberFormat($row->sale_price)); ?></div>
									<?php else: ?>
									<div class="new-price"><?php echo e(NumberFormat($row->sale_price)); ?><?php echo e($gtext['currency_icon']); ?></div>
									<?php endif; ?>
								<?php endif; ?>
								<?php if(($row->is_discount == 1) && ($row->old_price !='')): ?>
									<?php if($gtext['currency_position'] == 'left'): ?>
									<div class="old-price"><?php echo e($gtext['currency_icon']); ?><?php echo e(NumberFormat($row->old_price)); ?></div>
									<?php else: ?>
									<div class="old-price"><?php echo e(NumberFormat($row->old_price)); ?><?php echo e($gtext['currency_icon']); ?></div>
									<?php endif; ?>
								<?php endif; ?>
							</div>
							<div class="item-card-bottom">
								<a class="btn add-to-cart addtocart" data-id="<?php echo e($row->id); ?>" href="javascript:void(0);"><?php echo e(__('Add To Cart')); ?></a>
								<ul class="item-cart-list">
									<li><a class="addtowishlist" data-id="<?php echo e($row->id); ?>" href="javascript:void(0);"><i class="bi bi-heart"></i></a></li>
									<li><a href="<?php echo e(route('frontend.product', [$row->id, $row->slug])); ?>"><i class="bi bi-eye"></i></a></li>
								</ul>
							</div>
						</div>
					</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<?php else: ?>
					<?php $__currentLoopData = $category_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<?php 
						if(($row->is_discount == 1) && ($row->old_price !='')){
							$discount = number_format((($row->old_price - $row->sale_price)*100)/$row->old_price);
						}
					?>
					<div class="col-lg-12">
						<div class="item-card">
							<div class="item-image">
								<?php if(($row->is_discount == 1) && ($row->old_price !='')): ?>
								<span class="item-label"><?php echo e($discount); ?>% <?php echo e(__('Off')); ?></span>
								<?php endif; ?>
								<a href="<?php echo e(route('frontend.product', [$row->id, $row->slug])); ?>"><img src="<?php echo e(asset('public/media/'.$row->f_thumbnail)); ?>" alt="<?php echo e($row->title); ?>" /></a>
							</div>
							<div class="item-title">
								<a href="<?php echo e(route('frontend.product', [$row->id, $row->slug])); ?>"><?php echo e(str_limit($row->title)); ?></a>
							</div>
							<div class="rating-wrap">
								<div class="stars-outer">
									<div class="stars-inner" style="width:<?php echo e($row->ReviewPercentage); ?>%;"></div>
								</div>
								<span class="rating-count">(<?php echo e($row->TotalReview); ?>)</span>
							</div>
							<div class="item-sold">
								<?php echo e(__('Sold By')); ?> <a href="<?php echo e(route('frontend.stores', [$row->seller_id, str_slug($row->shop_url)])); ?>"><?php echo e(str_limit($row->shop_name)); ?></a>
							</div>
							<div class="item-pric-card">
								<?php if($row->sale_price != ''): ?>
									<?php if($gtext['currency_position'] == 'left'): ?>
									<div class="new-price"><?php echo e($gtext['currency_icon']); ?><?php echo e(NumberFormat($row->sale_price)); ?></div>
									<?php else: ?>
									<div class="new-price"><?php echo e(NumberFormat($row->sale_price)); ?><?php echo e($gtext['currency_icon']); ?></div>
									<?php endif; ?>
								<?php endif; ?>
								<?php if(($row->is_discount == 1) && ($row->old_price !='')): ?>
									<?php if($gtext['currency_position'] == 'left'): ?>
									<div class="old-price"><?php echo e($gtext['currency_icon']); ?><?php echo e(NumberFormat($row->old_price)); ?></div>
									<?php else: ?>
									<div class="old-price"><?php echo e(NumberFormat($row->old_price)); ?><?php echo e($gtext['currency_icon']); ?></div>
									<?php endif; ?>
								<?php endif; ?>
							</div>
							<div class="item-card-bottom">
								<a class="btn add-to-cart addtocart" data-id="<?php echo e($row->id); ?>" href="javascript:void(0);"><?php echo e(__('Add To Cart')); ?></a>
								<ul class="item-cart-list">
									<li><a class="addtowishlist" data-id="<?php echo e($row->id); ?>" href="javascript:void(0);"><i class="bi bi-heart"></i></a></li>
									<li><a href="<?php echo e(route('frontend.product', [$row->id, $row->slug])); ?>"><i class="bi bi-eye"></i></a></li>
								</ul>
							</div>
						</div>
					</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!-- /Popular Products/ -->
</main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
 	var item_id = "<?php echo e($data->id); ?>";
	var is_stock = "<?php echo e($data->is_stock); ?>";
	var is_stock_status = "<?php echo e($data->stock_status_id); ?>";
	
var TEXT = [];
	TEXT['Please enter quantity.'] = "<?php echo e(__('Please enter quantity.')); ?>";
	TEXT['The value must be less than or equal to'] = "<?php echo e(__('The value must be less than or equal to')); ?> <?php echo e($data->is_stock == 1 ? $data->stock_qty : ''); ?>";	
	TEXT['This product out of stock.'] = "<?php echo e(__('This product out of stock.')); ?>";	
</script>
<script src="<?php echo e(asset('public/frontend/pages/product.js')); ?>"></script>
<?php $__env->stopPush(); ?>	
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\resources\views/frontend/product.blade.php ENDPATH**/ ?>