@extends('frontend.layouts.user_panel')

@section('panel_content')

<div class="card">
    <form class="" id="sort_customers" action="" method="GET">
        <div class="card-header row gutters-5">
            <div class="col">
                <h5 class="mb-0 h6">{{translate('Notifications')}}</h5>
            </div>
        </div>
        <div class="card-body">
            <ul class="list-group list-group-flush">
                @forelse($notifications as $notification)
                    @if($notification->type == 'App\Notifications\OrderNotification')
                        <li class="list-group-item d-flex justify-content-between align-items- py-3">
                            <div class="media text-inherit">
                                <div class="media-body">
                                    <p class="mb-1 text-truncate-2">
                                        @if(Auth::user()->id == $notification->data['user_id'])
                                            {{ translate('Your Order: ') }}
                                            <a href="javascript:void(0)" onclick="show_purchase_history_details({{ $notification->data['order_id'] }})">
                                                {{ $notification->data['order_code'] }}
                                            </a>
                                            {{ translate(' has been '. ucfirst(str_replace('_', ' ', $notification->data['status']))) }}
                                        @else
                                            {{ translate('Order: ') }}
                                            <a href="javascript:void(0)" onclick="show_order_details({{ $notification->data['order_id'] }})">
                                                {{ $notification->data['order_code'] }}
                                            </a>
                                            {{ translate(' has been '. ucfirst(str_replace('_', ' ', $notification->data['status']))) }}
                                        @endif
                                    </p>
                                    <small class="text-muted">
                                        {{ date("F j Y, g:i a", strtotime($notification->created_at)) }}
                                    </small>
                                </div>
                            </div>
                        </li>
                    @endif

                @empty
                    <li class="list-group-item">
                        <div class="py-4 text-center fs-16">{{ translate('No notification found') }}</div>
                    </li>
                @endforelse
            </ul>

            {{ $notifications->links() }}
        </div>
    </form>
</div>

@endsection

@section('modal')
    <div class="modal fade" id="order_details" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div id="order-details-modal-body">

                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        
        function show_order_details(order_id)
        {
            $('#order-details-modal-body').html(null);

            if(!$('#modal-size').hasClass('modal-lg')){
                $('#modal-size').addClass('modal-lg');
            }

            $.post('{{ route('orders.details') }}', { _token : AIZ.data.csrf, order_id : order_id}, function(data){
                $('#order-details-modal-body').html(data);
                $('#order_details').modal();
                $('.c-preloader').hide();
            });
        }
        function sort_orders(el){
            $('#sort_orders').submit();
        }
    </script>
@endsection

