<?php $__env->startSection('content'); ?>

<style>
  .ps-2, .page-title {
      color: black !important;
  }
 .disable-click{
    pointer-events:none;
}
.status_color{
  color: #fff;
  border-radius: 5px;
  text-align: center;
}
.badge-primary{
    color: #fff;
    background: #007bff;
}
.badge-success {
    color: #fff;
    background-color: #28a745;
}
.badge-danger {
    color: #fff;
    background-color: #dc3545;
}
.badge-warning {
    color: #212529;
    background-color: #ffc107;
}
.badge-info {
    color: #fff;
    background-color: #17a2b8;
}
.badge-dark {
    color: #fff;
    background-color: #343a40;
}
.badge{
  font-size: 14px !important;
}
</style>

<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">SIS</a></li>
                    <li class="breadcrumb-item"><a href="javascript: void(0);">CRM</a></li>
                    <li class="breadcrumb-item active">Order List</li>
                </ol>
            </div>
            <h4 class="page-title">Order List</h4> 
        </div>
    </div>
</div>   
<!-- end page title --> 
<style>
    .btn.btn-sm{
        font-size: 12px;
    }    
</style>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="row mb-2">

                    <div class="col-xl-7 text-left">
                        <div class="#" style="">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.create')): ?>
                                <a href="<?php echo e(route('admin.orders.create')); ?>" class="btn btn-sm btn-danger mb-1"><i class="mdi mdi-basket me-1"></i> Add New Order</a>
                            <?php endif; ?>
                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.edit')): ?>
                                <a class="btn_modal btn btn-sm btn-info mb-1" href="<?php echo e(route('admin.assignUser')); ?>"><i class="mdi mdi-plus me-1"></i>
                                    Assign User
                                </a>
                            <?php endif; ?>
                            <a class="btn_modal btn btn-sm btn-info mb-1" href="<?php echo e(route('admin.orderStatusUpdateMulti')); ?>"><i class="mdi mdi-plus me-1"></i>
                               Status Change
                            </a>
                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.delete')): ?>
                                <a class="multi_order_delete btn btn-sm btn-danger mb-1" href="<?php echo e(route('admin.deleteAllOrder')); ?>"><i class="mdi mdi-plus me-1"></i>
                                    Delete All
                                </a>
                            <?php endif; ?>
                            <?php $isPending = \App\Models\Order::where(['status' => 'pending'])->first(); ?>
                            <a class="multi_order_print btn btn-sm btn-success mb-1" href="<?php echo e(route('admin.orderList')); ?>"><i class="mdi mdi-plus me-1"></i>
                                Print
                            </a>                            
                          <a class="send_to_redx btn btn-sm btn-dark mb-1" href="<?php echo e(route('admin.createRedxParcel')); ?>">
                                Send to Redx
                          </a>                          
                          <a class="send_to_pathao btn btn-sm btn-primary mb-1" href="<?php echo e(route('admin.createPathaoParcel')); ?>">
                                Send to Pathao
                          </a>
                          
                          <a class="send_to_steadfast btn btn-sm btn-success mb-1" href="<?php echo e(route('admin.createSteadfastParcel')); ?>">
                            Send to Steadfast
                          </a>
                          
                          <div class="col-md-4">
                            <select class="select2" name="courier_type">
                              <option value="" disabled selected>Choose Courier Option</option>
                              <option value="">All</option>
                              <option value="redx">Redx</option>
                              <option value="pathao">Pathao</option>
                              <option value="none">None</option>
                            </select>
                          </div>                          
                          <div class="col-md-4 d-none">
                            <select class="select2" name="redx_status">
                              <option value="" disabled selected>Choose Courier Status</option>
                              <option value="">All</option>
                              <option value="yes">Yes (<?php echo e($yes_count); ?>)</option>
                              <option value="no">No (<?php echo e($no_count); ?>)</option>
                            </select>
                          </div>
                        </div>
                    </div>
                    <div class="col-xl-4 d-none">
                        <div class="text-xl-end mt-xl-0 mt-2">                        
                            <a type="button" href="<?php echo e(route('admin.orderExport')); ?>" class="btn btn-light mb-2">Export</a>
                        </div>
                    </div><!-- end col-->
                </div>   
              
              <div class="d-none d-md-block d-lg-block">
                <form class="row gy-2 gx-2 align-items-center justify-content-xl-start justify-content-between" id="filter_form">
              <div class="col-12 d-flex justify-content-between align-items-center">
           
                <div class="d-flex">              
                  
                  <?php $__currentLoopData = getOrderStatus(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <label class="ps-2">
                    <input type="radio" class="order_sts"  name="status" value="<?php echo e($key); ?>"/>                    
                    <?php if(Auth::user()->hasRole('worker')): ?>
                    
                    <?php echo e($value); ?> (<?php echo e(\App\Models\Order::whereHas('details.product', function($q) {
                    	$q->whereNotNull('name');
                    })->where('status', $key)->where('assign_user_id', Auth::user()->id)->count()); ?>)
                    
                    <?php else: ?>
                    
                    <?php echo e($value); ?> (<?php echo e(\App\Models\Order::whereHas('details.product', function($q) {
                    	$q->whereNotNull('name');
                    })->where('status', $key)->count()); ?>)
                    
                    <?php endif; ?>                 
                    
                    
                  </label>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                  
                  
                                                 
                </div>
                 
                <div class="col-4">
                    <label for="inputPassword2" class="visually-hidden">Search</label>
                    <input type="search" class="form-control" id="inputPassword2" placeholder="Search..." name="q">
                  </div>
                
                  <!-- <div class="col-5 d-none">
                                <div class="d-flex align-items-center ">
                                    <label for="status-select" class="me-2">Status</label>
                                    <select class="form-select" id="status-select" name="status">
                                        <option selected value="">Choose...</option>
                                        
                                        <?php $__currentLoopData = getOrderStatus(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div> !-->
                
                  <div class="col-auto">
                    <label for="submit" class="visually-hidden">Submit</label>
                    <input type="button" class="form-control btn btn-sm btn-dark py-1" id="submit_search" value="Submit">
                  	</div>
     				</div>
                </form>   
              </div>

              <div class="col-sm-12 mt-2" id="rcvd_order">
                <div class="table-responsive">
                    <table class="table table-centered mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>                                    
                                    <div class="form-check">
                                      <label class="form-check-label">
                                        <input type="checkbox" class="form-check-input check_all" value="">
                                      </label>
                                    </div>
                                </th>

                              	<th style="width:7%">Action</th>
                                <th>Invoice ID</th>
                                <th>Date Order</th>
                                <th>Customers</th>
                                <th>Product SKU</th>
                                <th>Status</th>
                                <th>View Order</th>
                                <th>Assign User</th>
                              	<th style="width:15%">Courier</th>
                                <th>Amount</th>
                               <!-- <th>Discount</th> -->
                               
                               <!-- <th>Due</th> -->
                                
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <input type="checkbox" class="order_checkbox" value="<?php echo e($item->id); ?>">                                    
                                </td>

                              	<td>
                                    <a href="<?php echo e($item->status === 'pending' ? 'javascript:void(0)' : route('admin.orders.show',[$item->id])); ?>" target="<?php echo e($item->status === 'pending' ? '' : '_blank'); ?>" class="action-icon " title="<?php echo e($item->status === 'pending' ? 'pending invoice will not be printed' : 'Print Invoice'); ?>"> <i class="fa fa-print" aria-hidden="true"></i></a>
                                    <a href="<?php echo e(route('admin.orders.edit',[$item->id])); ?>" class="action-icon"> <i class="mdi mdi-square-edit-outline"></i></a>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order.delete')): ?>
                                    <a href="<?php echo e(route('admin.orders.destroy',[$item->id])); ?>" class="delete action-icon"> <i class="mdi mdi-delete"></i></a>
                                    <?php endif; ?>
                                </td>
                                <td style="color: #000;">#<?php echo e($item->invoice_no); ?></td>
                              	<td style="color: #000;"><?php echo e(\Carbon\Carbon::parse($item->created_at)->diffForHumans()); ?></td>
                                <td style="color: #000;"><?php echo e($item->first_name.' '.$item->last_name); ?><br>
                                    <?php echo e($item->shipping_address); ?><br>
                                    <?php echo e($item->mobile); ?> <a class="btn btn-sm btn-primary" href="tel:<?php echo e($item->mobile); ?>"><span>Call</span></a>
                                </td>
                              <td>
                                  
                                  <?php
                                    foreach($item->details as $detail)
                                    {
                                        if(!isset($detail->product['sku']) || $detail->product['sku'] == '')
                                        {
                                            ?> <span style="color: red;">Unavailable</span> <?php
                                            
                                        } else 
                                        {
                                            echo $detail->product['sku'];
                                        }
                                    }
                                  ?>
                                
                                </td>
                                <td style="width:15%"><a class="btn_modal" href="<?php echo e(route('admin.orderStatus', $item->id)); ?>">
                                      <?php if($item->status == 'pending'): ?>
                                      <span class="badge badge-primary"><?php echo e($item->status); ?></span>
                                      <?php elseif($item->status == 'processing'): ?>
                                      <span class="badge badge-info"><?php echo e($item->status); ?></span>
                                      <?php elseif($item->status == 'on_the_way'): ?>
                                      <span class="badge badge-dark"><?php echo e($item->status); ?></span>
                                      <?php elseif($item->status == 'on_hold'): ?>
                                      <span class="badge badge-warning"><?php echo e($item->status); ?></span>
                                      <?php elseif($item->status == 'complete'): ?>
                                      <span class="badge badge-success"><?php echo e($item->status); ?></span>
                                      <?php elseif($item->status == 'cancell'): ?>
                                      <span class="badge badge-danger"><?php echo e($item->status); ?></span>
                                      <?php endif; ?>
                                        
                                    </a>
                                </td>
                                <td><a href="<?php echo e(route('admin.orders.view', $item->id)); ?>" target="_blank">
                                        
                                        <span class="badge badge-info">View Order</span>                              
                                    </a>
                                </td>

                                <td style="color: #000;"><?php echo e($item->assign?$item->assign->username:''); ?></td>
                                <td style="color: #000;"><?php echo e($item->courier?$item->courier->name:''); ?> <br> <?php echo e($item->courier_tracking_id ?? ''); ?>

                              		<br> <?php echo e($item->area_name ?? ''); ?>

                              	</td>
								            <td style="color: #000;">
                                  <?php 
                                    $final_amount = $item->final_amount;                                    
                                    $fa = intval($final_amount);                                    
                                   echo $fa;                                    
                                  ?>                             
                              </td>  
                               
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                  	 </div>
                    <p><?php echo urldecode(str_replace("/?","?",$items->appends(Request::all())->render())); ?></p>
                </div>
            </div> <!-- end card-body-->
        </div> <!-- end card-->
    </div> <!-- end col -->
</div> <!-- end row -->
<?php $__env->stopSection(); ?> 

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/js/order.js')); ?>"></script>
<script>
$(document).ready(function(){
  
  $("select[name='redx_status']").on('change', function(){
      getOrderList();
  });   
  
  $("select[name='courier_type']").on('change', function(){
      getOrderList();
  });  
  
  $('.order_sts').on('click', function(){
      getOrderList();
  });
  
  function getOrderList()
  {
   	  var statusValue = $("input[name='status']:checked").val();
      var redx_status = $("select[name='redx_status']").val();
      var courier_type = $("select[name='courier_type']").val();
      $.ajax({
        type: 'GET',
      	url: "<?php echo e(route('admin.status_wise_order')); ?>",
        data: {statusValue, redx_status, courier_type},
        success: function(res){
      		if(res.success == true){            
              $('#rcvd_order').html(res.view);             	
            }
        }     
      }); 
  }
  
    $('#submit_search').on('click', function(){
      var searchValue = $("input[name='q']").val();
      $.ajax({
        type: 'GET',
      	url: "<?php echo e(route('admin.searchOrder')); ?>",
        data: {searchValue},
        success: function(res){
      		if(res.success == true){            
              $('#rcvd_order').html(res.view);             	
            }
        }     
      });
      
    });

    $(".check_all").on('change',function(){
      $(".order_checkbox").prop('checked',$(this).is(":checked"));
    });

    $(document).on('submit', 'form#order_status_update_form', function(e){
        e.preventDefault();
        var url = $(this).attr('action');
        var method = $(this).attr('method');
        let status=$(document).find('select#multi_status').val();
    
        var order = $('input.order_checkbox:checked').map(function(){
          return $(this).val();
        });
        var order_ids=order.get();
        
        if(order_ids.length ==0){
            toastr.error('Please Select An Order First !');
            return ;
        }
        
        $.ajax({
           type:'GET',
           url:url,
           data:{status,order_ids},
           success:function(res){
               if(res.status==true){
                toastr.success(res.msg);
                window.location.reload();
                
            }else if(res.status==false){
                toastr.error(res.msg);
            }
           }
        });
    
    });

    $(document).on('submit', 'form#order_assign_form', function(e){
        e.preventDefault();
        var url = $(this).attr('action');
        var method = $(this).attr('method');
        let assign_user_id=$(document).find('select#assign_user_id').val();
    
        var order = $('input.order_checkbox:checked').map(function(){
          return $(this).val();
        });
        var order_ids=order.get();
        
        if(order_ids.length ==0){
            toastr.error('Please Select An Order First !');
            return ;
        }
        
        $.ajax({
           type:'GET',
           url:url,
           data:{assign_user_id,order_ids},
           success:function(res){
               if(res.status==true){
                toastr.success(res.msg);
                window.location.reload();
                
            }else if(res.status==false){
                toastr.error(res.msg);
            }
           }
        });
    
    });

    $(document).on('click', 'a.multi_order_delete', function(e){
        e.preventDefault();
        var url = $(this).attr('href');
    
        var order = $('input.order_checkbox:checked').map(function(){
          return $(this).val();
        });
        var order_ids=order.get();
        
        if(order_ids.length ==0){
            toastr.error('Please Select An Order First !');
            return ;
        }
        
        $.ajax({
           type:'GET',
           url:url,
           data:{order_ids},
           success:function(res){
               if(res.status==true){
                toastr.success(res.msg);
                window.location.reload();
                
            }else if(res.status==false){
                toastr.error(res.msg);
            }
           }
        });
    
    }); 
    
    $(document).on('click', 'a.multi_order_print', function(e){
        e.preventDefault();
        var url = $(this).attr('href');
    
        var order = $('input.order_checkbox:checked').map(function(){
          return $(this).val();
        });
        var order_ids=order.get();
        
        if(order_ids.length ==0){
            toastr.error('Please Select Atleast One Order!');
            return ;
        }
        
        $.ajax({
           type:'GET',
           url,
           data:{order_ids},
           success:function(res){
               if(res.status==true){
                   console.log(res.items, res.info);                          
                   var myWindow = window.open("", "_blank");                   
  				   myWindow.document.write(res.view);                   
                // toastr.success(res.msg);
                // window.location.reload();
                   
            }else if(res.status==false){
                toastr.error(res.msg);
            }
           }
        });
    
    }); 
  
  
  //Redx Courier Service
  $(document).on('click', 'a.send_to_redx', function(e){
        e.preventDefault();
    // 	var statusValue = $("input[name='status']:checked").val();
        var url = $(this).attr('href');
    	let link = $(this);
        var order = $('input.order_checkbox:checked').map(function(){
          return $(this).val();
        });
        var order_ids=order.get();
        
        if(order_ids.length ==0){
            toastr.error('Please Select Atleast One Order!');
            return ;
        }        
    	
        // else if(statusValue != 'on_the_way'){
        //     toastr.error('Only On The Way Orders are Accepted!');
        //     return ;
        // }
    	
        
        $.ajax({
           type:'GET',
           url,
           data:{order_ids},
           beforeSend: function(){
             link.addClass('disable-click');
             link.text('Please wait...');
           },
           success:function(res){
               link.removeClass('disable-click');
               link.text('Send to Redx');
               if(res.status){               
                toastr.success(res.msg);
                   
            }else{
                toastr.error(res.msg);
            }
           }
        });
    
    });
  
  //Pathao Courier Service
  $(document).on('click', 'a.send_to_pathao', function(e){
        e.preventDefault();
    	var statusValue = $("input[name='status']:checked").val();
        var url = $(this).attr('href');
    	let link = $(this);
        var order = $('input.order_checkbox:checked').map(function(){
          return $(this).val();
        });
        var order_ids=order.get();
        
        if(order_ids.length ==0){
            toastr.error('Please Select Atleast One Order!');
            return ;
        }        
    	
        else if(statusValue != 'on_the_way'){
            toastr.error('Only On The Way Orders are Accepted!');
            return ;
        }
    	
        
        $.ajax({
           type:'GET',
           url,
           data:{order_ids},
           beforeSend: function(){
             link.addClass('disable-click');
             link.text('Please wait...');
           },
           success:function(res){
               link.removeClass('disable-click');
               link.text('Send to Pathao');
               if(res.status){               
                toastr.success(res.msg);
                   
            }else{
                toastr.error(`Invoice :${res.invoice} something went wrong!`);
              	console.log(res.errors);
            }
           }
        });
    
    });

  //Steadfast Courier Service
  $(document).on('click', 'a.send_to_steadfast', function(e){
        e.preventDefault();
    	var statusValue = $("input[name='status']:checked").val();
        var url = $(this).attr('href');
    	let link = $(this);
        var order = $('input.order_checkbox:checked').map(function(){
          return $(this).val();
        });
        var order_ids=order.get();
        
        if(order_ids.length ==0){
            toastr.error('Please Select Atleast One Order!');
            return ;
        }        
    	
        // else if(statusValue != '0'){
        //     toastr.error('Only On The Way Orders are Accepted!');
        //     return ;
        // }
    	
        
        $.ajax({
           type:'GET',
           url,
           data:{order_ids},
           beforeSend: function(){
             link.addClass('disable-click');
             link.text('Please wait...');
           },
           success:function(res){
               link.removeClass('disable-click');
               link.text('Send to Steadfast');
               if(res.status){               
                toastr.success(res.msg);
                   
            }else{
                toastr.error(`Invoice :${res.invoice} something went wrong!`);
              	console.log(res.errors);
            }
           }
        });
    
    });
    

    

})
  
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/roscombd/public_html/resources/views/backend/orders/index.blade.php ENDPATH**/ ?>