
<?php
$data=getProductInfo($product);
use App\Models\Information;
use App\Models\BanglaText;
$info = Information::first();
$bangla_text = BanglaText::first();
?>

<style>
    @media only screen and (min-width: 568px) and (max-width: 768px) {
        .axil-product {
            max-height: 455px !important;
        }
    }

    @media only screen and (min-width: 478px) and (max-width: 567px) {
        .axil-product {
            max-height: 412px !important;
        }
    }

    /*@media only screen and (min-width: 1850px) and (max-width: 2600px) {*/
    /*    .axil-product {*/
    /*        max-height: 407px !important;*/
    /*    }*/
    /*}*/

  @media only screen and (min-width: 1024px) and (max-width: 1155px) {
        .axil-product {
            max-height: 407px !important;
        }
    }

</style>


<div class="axil-product product-style-one" style="padding: 0px !important;">
    <div class="thumbnail" style="padding: 10px !important">
        <a href="<?php echo e(route('front.products.show',[$product->id])); ?>">
            <img src="<?php echo e(getImage('products', $product->image)); ?>" class="product_img" alt="Product Images">
        </a>

        <?php if($product->discount_type): ?>
        <div class="label-block label-right">
            <div class="product-badget" style="background: #F85606;"><?php echo e($product->discount_type=='fixed'?'':''); ?><?php echo e($product->discount); ?> <?php echo e($product->discount_type=='fixed'?'':'%'); ?> Off</div>
        </div>
        <?php endif; ?>
        <div class="product-hover-action">
            <ul class="cart-action d-none">
                <li class="quickview">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#quick-view-modal"><i class="far fa-eye"></i></a>
                </li>
                <li class="wishlist">
                    <a href="wishlist.php"><i class="far fa-heart"></i></a>
                </li>
            </ul>
        </div>
    </div>
    <div class="product-content" style="padding: 10px !important;">
        <div class="inner">
            <h5 class="title text-start"><a href="<?php echo e(route('front.products.show',[$product->id])); ?>"><?php echo e(\Illuminate\Support\Str::limit($product->name, 15)); ?></a></h5>
            <div class="product-price-variant text-start">
                <span class="price current-price" style="color: #F85606">

                  <?php
                    $curr = $info->currency;
                  ?>

                  <?php if($curr == 'BDT'): ?>
                    ৳ <?php echo e((int)$data['price']); ?>

                  <?php elseif($curr == 'Dollar'): ?>
                    $ <?php echo e($data['price']); ?>

                  <?php elseif($curr == 'Euro'): ?>
                     <?php echo e($data['price']); ?>

                  <?php elseif($curr == 'Rupee'): ?>
                     <?php echo e($data['price']); ?>

                  <?php else: ?>

                  <?php endif; ?>

              </span>
                <?php if($data['discount_amount'] > 0 && $data['old_price']): ?>
                <span class="price old-price" style="color: #a8b6e1">
                   <?php
                    $curr = $info->currency;
                  ?>

                  <?php if($curr == 'BDT'): ?>
                     <?php echo e((int)$data['old_price']); ?>

                  <?php elseif($curr == 'Dollar'): ?>
                    $ <?php echo e($data['old_price']); ?>

                  <?php elseif($curr == 'Euro'): ?>
                     <?php echo e($data['old_price']); ?>

                  <?php elseif($curr == 'Rupee'): ?>
                     <?php echo e($data['old_price']); ?>

                  <?php else: ?>

                   <?php endif; ?>
              </span>
                <?php endif; ?>
            </div>



        </div>
    </div>
   <?php if($product->type=="single"): ?>
            <form method="POST" action="<?php echo e(route('front.carts.store')); ?>" id="cart_form">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                <?php if($product->after_discount != '0'): ?>
                <input type="hidden" name="price" value="<?php echo e($product->after_discount); ?>">
                <?php else: ?>
                <input type="hidden" name="price" value="<?php echo e($product->sell_price); ?>">
                <?php endif; ?>
                <input type="hidden" name="variation_id" value="<?php echo e($product->variation->id ?? ''); ?>">
                <input type="hidden" name="is_stock" value="<?php echo e($product->is_stock); ?>">
                <div class="desktop-cart cart-count" style="padding-bottom: 0px;">
                    <div class="product-add-to-cart col-12">
                        <ul class="cart-action col-12">
                            <li class="select-option col-12" style="margin-bottom: 0px;">
                                <button type="submit" class="btn p-0 button m-auto text-light col-12" style="background: #F85606 !important;">


                                      <?php if($product->is_free_shipping == 0): ?>

                                             <p><b>
                                          <i class="fas fa-shopping-cart"></i>

                                         &nbsp; <?php echo e($bangla_text->order_text); ?> </b></p>

                                      <?php else: ?>

                                        <p><b>
                                          <i class="fas fa-shopping-cart"></i>

                                         &nbsp; <?php echo e($bangla_text->fshipping_text); ?> </b></p>

                                    <?php endif; ?>



                                        <span>
                                            <i class="fas fa-shopping-cart"></i>
                                        </span>
                                </button>
                            </li>
                        </ul>
                    </div>
                </div>
            </form>
            <?php else: ?>
            <div class="desktop-cart cart-count">
                    <div class="product-add-to-cart">
                        <ul class="cart-action">
                            <li class="col-12 reg" style="background: #F85606; padding: 7px;border-radius: 4px;">
                                <a type="submit" style="color:white;font-size: 13px;font-weight: 900;" href="<?php echo e(route('front.products.show',[$product->id])); ?>" ><i class="fas fa-shopping-cart"></i> &nbsp;  <?php echo e($bangla_text->order_text); ?> </a>
                            </li>
                        </ul>
                    </div>
                </div>
            <?php endif; ?>



</div>

<?php /**PATH /home/elitedesignbd/ecommerce4.elitedesign.com.bd/resources/views/frontend/products/partials/product_section.blade.php ENDPATH**/ ?>