<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\AddonInstallRequest;
use App\Repositories\Interfaces\Admin\AddonInterface;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class AddonController extends Controller
{
    protected $addon;

    public function __construct(AddonInterface $addon){
        $this->addon = $addon;
    }
    public function installAddons(){

        $addons = $this->addon->paginate(get_pagination('pagination'));
        return view('admin.addons.installed-addons',compact('addons'));
    }

    public function availableAddons(){

//        $url        = "https://desk.spagreen.net/yoori-plugins";

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://desk.spagreen.net/yoori-plugins",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_SSL_VERIFYPEER=> false,
            CURLOPT_MAXREDIRS => 2,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer gjMhFjGmLXsafyZ2",
                "Content-Type: application/json",
            ),

        ));

        $response = curl_exec($curl);

        $curl_info      = curl_getinfo($curl);
        curl_close($curl);

//        $response   = Http::get($url);

            $decodedResponse =json_decode($response);
            return view('admin.addons.available-addons',compact('decodedResponse','curl_info'));

    }
    public function statusChange(Request $request){
        if (config('app.demo_mode')):
            $response['message']    = __('This function is disabled in demo server.');
            $response['title']      = __('Ops..!');
            $response['status']     = 'error';
            return response()->json($response);
        endif;
        DB::beginTransaction();
        try {
            $this->addon->statusChange($request['data']);
            $response['message'] = __('Updated Successfully');
            $response['title']   = __('Success');
            $response['type']    ='addon';
            $response['status']   = 'success';
            DB::commit();
            return response()->json($response);
        } catch (\Exception $e) {
            DB::rollBack();
            Toastr::error($e->getMessage());
            return redirect()->back();
        }
    }

    public function installNewAddon(AddonInstallRequest $request): RedirectResponse
    {
        if (config('app.demo_mode')):
            Toastr::info(__('This function is disabled in demo server.'));
            return redirect()->back();
        endif;
        try {
            $response = $this->addon->install($request);
            if (is_string($response)) {
                return back()->with('response', $response);
            }
            Toastr::success($response['message']);
            return back()->with('success', $response['message']);
        } catch (\Exception $e) {
            Toastr::error($e->getMessage());
            return back()->withInput();
        }
    }
}
