<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * This is used by Laravel authentication to redirect users after login.
     *
     * @var string
     */
    public const HOME = '/home';

    /**
     * The controller namespace for the application.
     *
     * When present, controller route declarations will automatically be prefixed with this namespace.
     *
     * @var string|null
     */
    // protected $namespace = 'App\\Http\\Controllers';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        $this->configureRateLimiting();

        $this->routes(function () {
            $this->mapApiRoutes();
            $this->mapDeliveryHeroApiRoutes();
            $this->mapSellerApiRoutes();
            $this->mapWebRoutes();
            $this->mapInstallerRoutes();
            $this->mapAdminRoutes();
            $this->mapOtpRoutes();
            $this->mapRefundRoutes();
            $this->mapDeliveryHeroRoutes();
            $this->mapWholeSaleProductRoutes();
            $this->mapRewardRoutes();
            $this->mapSellerRoutes();
            $this->mapOfflinePaymentRoutes();
            $this->mapPosSystemRoutes();
            $this->mapChatSystemRoutes();
            $this->mapVideoShoppingRoutes();
            $this->mapSellerSubscriptionRoutes();
            $this->mapIshophetRoutes();
            $this->mapAffiliateRoutes();
            $this->mapSellerChatSystemRoutes();
            $this->mapAIWriterRoutes();
            $this->mapRamdhaniRoutes();
//            $this->mapHitpayPaymentGatewayRoutes();
//            $this->mapErsApi();
//            $this->mapPluginRoutes();
        });
    }

    /**
     * Configure the rate limiters for the application.
     *
     * @return void
     */
    protected function configureRateLimiting()
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by(optional($request->user())->id ?: $request->ip());
        });
    }

    protected function mapApiRoutes()
    {
        Route::prefix('api')
            ->middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/api.php'));
    }

    protected function mapDeliveryHeroApiRoutes()
    {
        Route::prefix('api')
            ->middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/delivery-hero-api.php'));
    }

    protected function mapSellerApiRoutes()
    {
        Route::prefix('api')
            ->middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/seller-api.php'));
    }

    protected function mapWebRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/web.php'));
    }

    protected function mapAdminRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/admin.php'));
    }

    protected function mapOtpRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/otp-system.php'));
    }

    protected function mapRefundRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/refund.php'));
    }
    protected function mapDeliveryHeroRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/delivery-hero.php'));
    }
    protected function mapWholeSaleProductRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/wholesale-product.php'));
    }
    protected function mapRewardRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/reward.php'));
    }
    protected function mapSellerRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/seller.php'));
    }
    protected function mapOfflinePaymentRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/offline-payment.php'));
    }
    protected function mapPosSystemRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/pos-system.php'));
    }
    protected function mapChatSystemRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/chat-messenger.php'));
    }
    protected function mapVideoShoppingRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/video-shopping.php'));
    }
    protected function mapInstallerRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/install.php'));
    }

    protected function mapSellerSubscriptionRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/seller-subscription.php'));
    }

    protected function mapIshophetRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/isophet.php'));
    }

    protected function mapAffiliateRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/affiliate.php'));
    }
    protected function mapSellerChatSystemRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/chat_system.php'));
    }

    protected function mapAIWriterRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/ai_writer.php'));
    }
    protected function mapRamdhaniRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/ramdhani.php'));
    }

    protected function mapHitpayPaymentGatewayRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/hitpay_payment_gateway.php'));
    }

    protected function mapErsApi()
    {
        Route::prefix('api')
            ->middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/ers-api.php'));
    }

    protected function mapPluginRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/plugin.php'));
    }
}
