<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductStocksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_stocks', function (Blueprint $table) {
            $table->id();
            $table->string('variant_ids')->nullable()->comment('first one is color,rest is attribute values');
            $table->bigInteger('product_id')->unsigned();
            $table->string('name')->nullable()->comment('auto generated by attributes and colors');
            $table->string('sku')->nullable();
            $table->integer('current_stock')->default(0);
            $table->double('price',20,3);
            $table->mediumText('image')->nullable();
            $table->bigInteger('image_id')->unsigned()->nullable();
            $table->timestamps();
        });

        $now = now();

        \App\Models\ProductStock::insert([
            'variant_ids' => NULL,
            'product_id' => 1,
            'name' => '',
            'sku' => 'Q59GQLJDJY9YKOQP',
            'current_stock' => 200,
            'price' => 9,
            'image' => '[]',
            'image_id' => NULL,
            'created_at' => $now,
            'updated_at' => $now,
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_stocks');
    }
}
